# Microsoft.Extensions.Logging

``` diff
 namespace Microsoft.Extensions.Logging {
     [UnsupportedOSPlatformAttribute("browser")]
     public static class ConsoleLoggerExtensions {
-        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
-        public static ILoggingBuilder AddConsoleFormatter<TFormatter, TOptions>(this ILoggingBuilder builder) where TFormatter : ConsoleFormatter where TOptions : ConsoleFormatterOptions;
+        [RequiresDynamicCodeAttribute("Binding TOptions to configuration values may require generating dynamic code at runtime.")]
+        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
+        public static ILoggingBuilder AddConsoleFormatter<TFormatter, TOptions>(this ILoggingBuilder builder) where TFormatter : ConsoleFormatter where TOptions : ConsoleFormatterOptions;
-        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
-        public static ILoggingBuilder AddConsoleFormatter<TFormatter, TOptions>(this ILoggingBuilder builder, Action<TOptions> configure) where TFormatter : ConsoleFormatter where TOptions : ConsoleFormatterOptions;
+        [RequiresDynamicCodeAttribute("Binding TOptions to configuration values may require generating dynamic code at runtime.")]
+        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
+        public static ILoggingBuilder AddConsoleFormatter<TFormatter, TOptions>(this ILoggingBuilder builder, Action<TOptions> configure) where TFormatter : ConsoleFormatter where TOptions : ConsoleFormatterOptions;
     }
     public class LoggerFactory : IDisposable, ILoggerFactory {
-        public static ILoggerFactory Create(Action<ILoggingBuilder> configure);
+        [RequiresDynamicCodeAttribute("LoggerFactory.Create uses Microsoft.Extensions.DependencyInjection, which may require generating code dynamically at runtime.")]
+        public static ILoggerFactory Create(Action<ILoggingBuilder> configure);
     }
 }
```

