# System.Security.Cryptography.X509Certificates

``` diff
 namespace System.Security.Cryptography.X509Certificates {
     [UnsupportedOSPlatformAttribute("browser")]
     public sealed class CertificateRequest {
+        public CertificateRequest(X500DistinguishedName subjectName, PublicKey publicKey, HashAlgorithmName hashAlgorithm, RSASignaturePadding? rsaSignaturePadding = null);
+        public Collection<AsnEncodedData> OtherRequestAttributes { get; }
+        public string CreateSigningRequestPem();
+        public string CreateSigningRequestPem(X509SignatureGenerator signatureGenerator);
+        public static CertificateRequest LoadSigningRequest(byte[] pkcs10, HashAlgorithmName signerHashAlgorithm, CertificateRequestLoadOptions options = CertificateRequestLoadOptions.Default, RSASignaturePadding? signerSignaturePadding = null);
+        public static CertificateRequest LoadSigningRequest(ReadOnlySpan<byte> pkcs10, HashAlgorithmName signerHashAlgorithm, out int bytesConsumed, CertificateRequestLoadOptions options = CertificateRequestLoadOptions.Default, RSASignaturePadding? signerSignaturePadding = null);
+        public static CertificateRequest LoadSigningRequestPem(ReadOnlySpan<char> pkcs10Pem, HashAlgorithmName signerHashAlgorithm, CertificateRequestLoadOptions options = CertificateRequestLoadOptions.Default, RSASignaturePadding? signerSignaturePadding = null);
+        public static CertificateRequest LoadSigningRequestPem(string pkcs10Pem, HashAlgorithmName signerHashAlgorithm, CertificateRequestLoadOptions options = CertificateRequestLoadOptions.Default, RSASignaturePadding? signerSignaturePadding = null);
     }
+    [FlagsAttribute]
+    public enum CertificateRequestLoadOptions {
+        Default = 0,
+        SkipSignatureValidation = 1,
+        UnsafeLoadCertificateExtensions = 2,
+    }
+    public sealed class CertificateRevocationListBuilder {
+        public CertificateRevocationListBuilder();
+        public void AddEntry(byte[] serialNumber, DateTimeOffset? revocationTime = default(DateTimeOffset?), X509RevocationReason? reason = default(X509RevocationReason?));
+        public void AddEntry(ReadOnlySpan<byte> serialNumber, DateTimeOffset? revocationTime = default(DateTimeOffset?), X509RevocationReason? reason = default(X509RevocationReason?));
+        public void AddEntry(X509Certificate2 certificate, DateTimeOffset? revocationTime = default(DateTimeOffset?), X509RevocationReason? reason = default(X509RevocationReason?));
+        public byte[] Build(X500DistinguishedName issuerName, X509SignatureGenerator generator, BigInteger crlNumber, DateTimeOffset nextUpdate, HashAlgorithmName hashAlgorithm, X509AuthorityKeyIdentifierExtension authorityKeyIdentifier, DateTimeOffset? thisUpdate = default(DateTimeOffset?));
+        public byte[] Build(X509Certificate2 issuerCertificate, BigInteger crlNumber, DateTimeOffset nextUpdate, HashAlgorithmName hashAlgorithm, RSASignaturePadding? rsaSignaturePadding = null, DateTimeOffset? thisUpdate = default(DateTimeOffset?));
+        public static X509Extension BuildCrlDistributionPointExtension(IEnumerable<string> uris, bool critical = false);
+        public static CertificateRevocationListBuilder Load(byte[] currentCrl, out BigInteger currentCrlNumber);
+        public static CertificateRevocationListBuilder Load(ReadOnlySpan<byte> currentCrl, out BigInteger currentCrlNumber, out int bytesConsumed);
+        public static CertificateRevocationListBuilder LoadPem(ReadOnlySpan<char> currentCrl, out BigInteger currentCrlNumber);
+        public static CertificateRevocationListBuilder LoadPem(string currentCrl, out BigInteger currentCrlNumber);
+        public bool RemoveEntry(byte[] serialNumber);
+        public bool RemoveEntry(ReadOnlySpan<byte> serialNumber);
+    }
     public sealed class X500DistinguishedName : AsnEncodedData {
+        public IEnumerable<X500RelativeDistinguishedName> EnumerateRelativeDistinguishedNames(bool reversed = true);
     }
+    public sealed class X500RelativeDistinguishedName {
+        public bool HasMultipleElements { get; }
+        public ReadOnlyMemory<byte> RawData { get; }
+        public Oid GetSingleElementType();
+        public string? GetSingleElementValue();
+    }
+    public sealed class X509AuthorityKeyIdentifierExtension : X509Extension {
+        public X509AuthorityKeyIdentifierExtension();
+        public X509AuthorityKeyIdentifierExtension(byte[] rawData, bool critical = false);
+        public X509AuthorityKeyIdentifierExtension(ReadOnlySpan<byte> rawData, bool critical = false);
+        public ReadOnlyMemory<byte>? KeyIdentifier { get; }
+        public X500DistinguishedName? NamedIssuer { get; }
+        public ReadOnlyMemory<byte>? RawIssuer { get; }
+        public ReadOnlyMemory<byte>? SerialNumber { get; }
+        public override void CopyFrom(AsnEncodedData asnEncodedData);
+        public static X509AuthorityKeyIdentifierExtension Create(byte[] keyIdentifier, X500DistinguishedName issuerName, byte[] serialNumber);
+        public static X509AuthorityKeyIdentifierExtension Create(ReadOnlySpan<byte> keyIdentifier, X500DistinguishedName issuerName, ReadOnlySpan<byte> serialNumber);
+        public static X509AuthorityKeyIdentifierExtension CreateFromCertificate(X509Certificate2 certificate, bool includeKeyIdentifier, bool includeIssuerAndSerial);
+        public static X509AuthorityKeyIdentifierExtension CreateFromIssuerNameAndSerialNumber(X500DistinguishedName issuerName, byte[] serialNumber);
+        public static X509AuthorityKeyIdentifierExtension CreateFromIssuerNameAndSerialNumber(X500DistinguishedName issuerName, ReadOnlySpan<byte> serialNumber);
+        public static X509AuthorityKeyIdentifierExtension CreateFromSubjectKeyIdentifier(byte[] subjectKeyIdentifier);
+        public static X509AuthorityKeyIdentifierExtension CreateFromSubjectKeyIdentifier(ReadOnlySpan<byte> subjectKeyIdentifier);
+        public static X509AuthorityKeyIdentifierExtension CreateFromSubjectKeyIdentifier(X509SubjectKeyIdentifierExtension subjectKeyIdentifier);
+    }
     public sealed class X509BasicConstraintsExtension : X509Extension {
+        public static X509BasicConstraintsExtension CreateForCertificateAuthority(int? pathLengthConstraint = default(int?));
+        public static X509BasicConstraintsExtension CreateForEndEntity(bool critical = false);
     }
     public class X509Certificate : IDeserializationCallback, IDisposable, ISerializable {
+        public ReadOnlyMemory<byte> SerialNumberBytes { get; }
     }
     public class X509Certificate2 : X509Certificate {
+        public bool MatchesHostname(string hostname, bool allowWildcards = true, bool allowCommonName = true);
     }
+    public enum X509RevocationReason {
+        AACompromise = 10,
+        AffiliationChanged = 3,
+        CACompromise = 2,
+        CertificateHold = 6,
+        CessationOfOperation = 5,
+        KeyCompromise = 1,
+        PrivilegeWithdrawn = 9,
+        RemoveFromCrl = 8,
+        Superseded = 4,
+        Unspecified = 0,
+        WeakAlgorithmOrKey = 11,
+    }
+    public sealed class X509SubjectAlternativeNameExtension : X509Extension {
+        public X509SubjectAlternativeNameExtension();
+        public X509SubjectAlternativeNameExtension(byte[] rawData, bool critical = false);
+        public X509SubjectAlternativeNameExtension(ReadOnlySpan<byte> rawData, bool critical = false);
+        public override void CopyFrom(AsnEncodedData asnEncodedData);
+        public IEnumerable<string> EnumerateDnsNames();
+        public IEnumerable<IPAddress> EnumerateIPAddresses();
+    }
     public sealed class X509SubjectKeyIdentifierExtension : X509Extension {
+        public ReadOnlyMemory<byte> SubjectKeyIdentifierBytes { get; }
     }
 }
```

