# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
     public sealed class EndpointFilterFactoryContext {
+        public EndpointFilterFactoryContext();
-        public EndpointFilterFactoryContext(MethodInfo methodInfo, IList<object> endpointMetadata, IServiceProvider applicationServices);
-        public IServiceProvider ApplicationServices { get; }
+        public IServiceProvider ApplicationServices { get; set; }
-        public IList<object> EndpointMetadata { get; }
-        public MethodInfo MethodInfo { get; }
+        public required MethodInfo MethodInfo { get; set; }
     }
     [UnconditionalSuppressMessageAttribute("Trimmer", "IL2026", Justification="RequestDelegateFactory.Create requires unreferenced code.")]
     [UnconditionalSuppressMessageAttribute("Trimmer", "IL2060", Justification="RequestDelegateFactory.Create requires unreferenced code.")]
     [UnconditionalSuppressMessageAttribute("Trimmer", "IL2072", Justification="RequestDelegateFactory.Create requires unreferenced code.")]
     [UnconditionalSuppressMessageAttribute("Trimmer", "IL2075", Justification="RequestDelegateFactory.Create requires unreferenced code.")]
     [UnconditionalSuppressMessageAttribute("Trimmer", "IL2077", Justification="RequestDelegateFactory.Create requires unreferenced code.")]
     public static class RequestDelegateFactory {
-        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
-        public static RequestDelegateResult Create(Delegate handler, RequestDelegateFactoryOptions? options = null);
+        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
+        public static RequestDelegateResult Create(Delegate handler, RequestDelegateFactoryOptions? options);
+        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
+        public static RequestDelegateResult Create(Delegate handler, RequestDelegateFactoryOptions? options = null, RequestDelegateMetadataResult? metadataResult = null);
-        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
-        public static RequestDelegateResult Create(MethodInfo methodInfo, Func<HttpContext, object>? targetFactory = null, RequestDelegateFactoryOptions? options = null);
+        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
+        public static RequestDelegateResult Create(MethodInfo methodInfo, Func<HttpContext, object>? targetFactory, RequestDelegateFactoryOptions? options);
+        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
+        public static RequestDelegateResult Create(MethodInfo methodInfo, Func<HttpContext, object>? targetFactory = null, RequestDelegateFactoryOptions? options = null, RequestDelegateMetadataResult? metadataResult = null);
+        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
+        public static RequestDelegateMetadataResult InferMetadata(MethodInfo methodInfo, RequestDelegateFactoryOptions? options = null);
     }
     public sealed class RequestDelegateFactoryOptions {
+        public EndpointBuilder EndpointBuilder { get; set; }
-        public IReadOnlyList<Func<EndpointFilterFactoryContext, EndpointFilterDelegate, EndpointFilterDelegate>>? EndpointFilterFactories { get; set; }
-        public IList<object>? EndpointMetadata { get; set; }
     }
+    public sealed class RequestDelegateMetadataResult {
+        public RequestDelegateMetadataResult();
+        public required IReadOnlyList<object> EndpointMetadata { get; set; }
+    }
 }
```

