# .NET Core SDK 1.1.0 Preview1-005077 with .NET Core 1.0.5 & 1.1.2

The .NET Core SDK is being updated to version 1.1.0 in Visual Studio 2017 15.3. The changes, which are listed in the [SDK release notes](https://github.com/dotnet/cli/releases/tag/v1.1.0-preview1-005077) are in support of Visual Studio 2017. Previously released Runtime-only installers and binaries can be found on the .NET Core [1.0.5](1.0.5-download.md) and [1.1.2](1.1.2-download.md) installer pages.

[Checksums](https://dotnetcli.blob.core.windows.net/dotnet/checksums/sdk-1.1.0-preview1-005077-SHA.txt) are available to verify all downloads.

|                         | SDK Installer                                                                                                        | SDK Binaries                                             |
| ----------------------- | :----------------------------------------------:                                                                     | :----------------------------------------------:         |
| Windows                 | [32-bit](https://download.microsoft.com/download/0/A/4/0A4563C2-B51F-49E5-BDAC-EE13566F1891/dotnet-dev-win-x86.1.1.0-preview1-005077.exe) / [64-bit](https://download.microsoft.com/download/0/A/4/0A4563C2-B51F-49E5-BDAC-EE13566F1891/dotnet-dev-win-x64.1.1.0-preview1-005077.exe)  | [32-bit](https://download.microsoft.com/download/3/5/C/35CD1308-BACB-4205-B998-3477F9EF5D0C/dotnet-dev-win-x86.1.1.0-preview1-005077.zip) / [64-bit](https://download.microsoft.com/download/3/5/C/35CD1308-BACB-4205-B998-3477F9EF5D0C/dotnet-dev-win-x64.1.1.0-preview1-005077.zip)
| macOS                   | [64-bit](https://download.microsoft.com/download/0/A/4/0A4563C2-B51F-49E5-BDAC-EE13566F1891/dotnet-dev-osx-x64.1.1.0-preview1-005077.pkg)                                                             | [64-bit](https://download.microsoft.com/download/3/5/C/35CD1308-BACB-4205-B998-3477F9EF5D0C/dotnet-dev-osx-x64.1.1.0-preview1-005077.tar.gz) |
| CentOS 7.1              | -                                                                                                                    | [64-bit](https://download.microsoft.com/download/3/5/C/35CD1308-BACB-4205-B998-3477F9EF5D0C/dotnet-dev-centos-x64.1.1.0-preview1-005077.tar.gz) |
| Debian 8                | -                                                                                                                    | [64-bit](https://download.microsoft.com/download/3/5/C/35CD1308-BACB-4205-B998-3477F9EF5D0C/dotnet-dev-debian-x64.1.1.0-preview1-005077.tar.gz) |
| Fedora 24               | -                                                                                                                    | [64-bit](https://download.microsoft.com/download/3/5/C/35CD1308-BACB-4205-B998-3477F9EF5D0C/dotnet-dev-fedora.24-x64.1.1.0-preview1-005077.tar.gz) |
| OpenSUSE 42.1           | -                                                                                                                    | [64-bit](https://download.microsoft.com/download/3/5/C/35CD1308-BACB-4205-B998-3477F9EF5D0C/dotnet-dev-opensuse.42.1-x64.1.1.0-preview1-005077.tar.gz) |
| Ubuntu | See installation steps below.                                                              |  |

## Installation from a binary archive

When using binary archives to install, we recommend the contents be extracted to `/opt/dotnet` and a symbolic link created for `dotnet`. If an earlier release of .NET Core is already installed, the directory and symbolic link may already exist. Ubuntu and Mint users should follow the instructions in the Ubuntu Installation section below.

```bash
sudo mkdir -p /opt/dotnet
sudo tar zxf [tar.gz filename] -C /opt/dotnet
sudo ln -s /opt/dotnet/dotnet /usr/local/bin
```

## Ubuntu installation

### Add the dotnet apt-get feed

The first step is to establish the source feed for the package manager. This is only needed if you have not previously set up the source or if you are installing for the first time.

#### Ubuntu 14.04 and Linux Mint 17

```bash
sudo sh -c 'echo "deb [arch=amd64] https://apt-mo.trafficmanager.net/repos/dotnet-release/ trusty main" > /etc/apt/sources.list.d/dotnetdev.list'
sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 417A0893
sudo apt-get update
```

#### Ubuntu 16.04 and Linux Mint 18

```bash
sudo sh -c 'echo "deb [arch=amd64] https://apt-mo.trafficmanager.net/repos/dotnet-release/ xenial main" > /etc/apt/sources.list.d/dotnetdev.list'
sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 417A0893
sudo apt-get update
```

#### Ubuntu 16.10

```bash
sudo sh -c 'echo "deb [arch=amd64] https://apt-mo.trafficmanager.net/repos/dotnet-release/ yakkety main" > /etc/apt/sources.list.d/dotnetdev.list'
sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 417A0893
sudo apt-get update
```

### Install .NET Core SDK

Before you start, uninstall any .NET Core SDK Previews that were previously installed. For example,

```
sudo apt-get remove dotnet-dev-1.1.0-preview1-[build number]]
```

To install .NET Core on Ubuntu or Linux Mint, use the following apt-get command.

```
sudo apt-get install dotnet-dev-1.1.0-preview1-005077
```