[![Stars](https://img.shields.io/github/stars/scverse/scanpy?style=flat&logo=GitHub&color=yellow)](https://github.com/scverse/scanpy/stargazers)
[![PyPI](https://img.shields.io/pypi/v/scanpy?logo=PyPI)](https://pypi.org/project/scanpy)
[![Downloads](https://static.pepy.tech/badge/scanpy)](https://pepy.tech/project/scanpy)
[![Conda](https://img.shields.io/conda/dn/conda-forge/scanpy?logo=Anaconda)](https://anaconda.org/conda-forge/scanpy)
[![Docs](https://readthedocs.com/projects/icb-scanpy/badge/?version=latest)](https://scanpy.readthedocs.io)
[![Build Status](https://dev.azure.com/scverse/scanpy/_apis/build/status/scverse.scanpy?branchName=main)](https://dev.azure.com/scverse/scanpy/_build)
[![Discourse topics](https://img.shields.io/discourse/posts?color=yellow&logo=discourse&server=https%3A%2F%2Fdiscourse.scverse.org)](https://discourse.scverse.org/)
[![Chat](https://img.shields.io/badge/zulip-join_chat-%2367b08f.svg)](https://scverse.zulipchat.com)
[![Powered by NumFOCUS](https://img.shields.io/badge/powered%20by-NumFOCUS-orange.svg?style=flat&colorA=E1523D&colorB=007D8A)](https://numfocus.org/)

# Scanpy – Single-Cell Analysis in Python

Scanpy is a scalable toolkit for analyzing single-cell gene expression data
built jointly with [anndata][].  It includes
preprocessing, visualization, clustering, trajectory inference and differential
expression testing.  The Python-based implementation efficiently deals with
datasets of more than one million cells.

Discuss usage on the scverse [Discourse][]. Read the [documentation][].
If you'd like to contribute by opening an issue or creating a pull request, please take a look at our [contribution guide][].

[anndata]: https://anndata.readthedocs.io
[discourse]: https://discourse.scverse.org/
[documentation]: https://scanpy.readthedocs.io

[//]: # (numfocus-fiscal-sponsor-attribution)

scanpy is part of the scverse project ([website](https://scverse.org), [governance](https://scverse.org/about/roles)) and is fiscally sponsored by [NumFOCUS](https://numfocus.org/).
If you like scverse and want to support our mission, please consider making a [donation](https://numfocus.org/donate-to-scverse) to support our efforts.

<div align="center">
<a href="https://numfocus.org/project/scverse">
  <img
    src="https://raw.githubusercontent.com/numfocus/templates/master/images/numfocus-logo.png"
    width="200"
  >
</a>
</div>


## Citation

If you use `scanpy` in your work, please cite the `scanpy` publication as follows:

> **SCANPY: large-scale single-cell gene expression data analysis**
>
> F. Alexander Wolf, Philipp Angerer, Fabian J. Theis
>
> _Genome Biology_ 2018 Feb 06. doi: [10.1186/s13059-017-1382-0](https://doi.org/10.1186/s13059-017-1382-0).

You can cite the scverse publication as follows:

> **The scverse project provides a computational ecosystem for single-cell omics data analysis**
>
> Isaac Virshup, Danila Bredikhin, Lukas Heumos, Giovanni Palla, Gregor Sturm, Adam Gayoso, Ilia Kats, Mikaela Koutrouli, Scverse Community, Bonnie Berger, Dana Pe’er, Aviv Regev, Sarah A. Teichmann, Francesca Finotello, F. Alexander Wolf, Nir Yosef, Oliver Stegle & Fabian J. Theis
>
> _Nat Biotechnol._ 2023 Apr 10. doi: [10.1038/s41587-023-01733-8](https://doi.org/10.1038/s41587-023-01733-8).


[contribution guide]: CONTRIBUTING.md
