(v1.5.0)=
### 1.5.0 {small}`2020-05-15`

The `1.5.0` release adds a lot of new functionality, much of which takes advantage of {mod}`anndata` updates `0.7.0 - 0.7.2`. Highlights of this release include support for spatial data, dedicated handling of graphs in AnnData, sparse PCA, an interface with scvi, and others.

#### Spatial data support

- Basic analysis {doc}`/tutorials/spatial/basic-analysis` and integration with single cell data {doc}`/tutorials/spatial/integration-scanorama` {smaller}`G Palla`
- {func}`~scanpy.read_visium` read 10x Visium data {pr}`1034` {smaller}`G Palla, P Angerer, I Virshup`
- {func}`~scanpy.datasets.visium_sge` load Visium data directly from 10x Genomics {pr}`1013` {smaller}`M Mirkazemi, G Palla, P Angerer`
- {func}`~scanpy.pl.spatial` plot spatial data {pr}`1012` {smaller}`G Palla, P Angerer`

#### New functionality

- Many functions, like {func}`~scanpy.pp.neighbors` and {func}`~scanpy.tl.umap`, now store cell-by-cell graphs in {attr}`~anndata.AnnData.obsp` {pr}`1118` {smaller}`S Rybakov`
- {func}`~scanpy.pp.scale` and {func}`~scanpy.pp.log1p` can be used on any element in {attr}`~anndata.AnnData.layers` or {attr}`~anndata.AnnData.obsm` {pr}`1173` {smaller}`I Virshup`

#### External tools

- `scanpy.external.pp.scvi` for preprocessing with scVI {pr}`1085` {smaller}`G Xing`
- Guide for using `Scanpy in R` {pr}`1186` {smaller}`L Zappia`

#### Performance

- {func}`~scanpy.pp.pca` now uses efficient implicit centering for sparse matrices. This can lead to signifigantly improved performance for large datasets {pr}`1066` {smaller}`A Tarashansky`
- {func}`~scanpy.tl.score_genes` now has an efficient implementation for sparse matrices with missing values {pr}`1196` {smaller}`redst4r`.

```{warning}
The new {func}`~scanpy.pp.pca` implementation can result in slightly different results for sparse matrices. See the pr ({pr}`1066`) and documentation for more info.
```

#### Code design

- {func}`~scanpy.pl.stacked_violin` can now be used as a subplot {pr}`1084` {smaller}`P Angerer`
- {func}`~scanpy.tl.score_genes` has improved logging {pr}`1119` {smaller}`G Eraslan`
- {func}`~scanpy.pp.scale` now saves mean and standard deviation in the {attr}`~anndata.AnnData.var` {pr}`1173` {smaller}`A Wolf`
- {func}`~scanpy.external.tl.harmony_timeseries` {pr}`1091` {smaller}`A Mousa`

#### Bug fixes

- {func}`~scanpy.pp.combat` now works when `obs_names` aren't unique. {pr}`1215` {smaller}`I Virshup`
- {func}`~scanpy.pp.scale` can now be used on dense arrays without centering {pr}`1160` {smaller}`simonwm`
- {func}`~scanpy.pp.regress_out` now works when some features are constant {pr}`1194` {smaller}`simonwm`
- {func}`~scanpy.pp.normalize_total` errored if the passed object was a view {pr}`1200` {smaller}`I Virshup`
- {func}`~scanpy.pp.neighbors` sometimes ignored the `n_pcs` param {pr}`1124` {smaller}`V Bergen`
- {func}`~scanpy.datasets.ebi_expression_atlas` which contained some out-of-date URLs {pr}`1102` {smaller}`I Virshup`
- {func}`~scanpy.tl.ingest` for UMAP `0.4` {pr}`1165` {smaller}`S Rybakov`
- {func}`~scanpy.tl.louvain` for Louvain `0.6` {pr}`1197` {smaller}`I Virshup`
- {func}`~scanpy.pp.highly_variable_genes` which could lead to incorrect results when the `batch_key` argument was used {pr}`1180` {smaller}`G Eraslan`
- {func}`~scanpy.tl.ingest` where an inconsistent number of neighbors was used {pr}`1111` {smaller}`S Rybakov`
