// Copyright (c) 2017 Computer Vision Center (CVC) at the Universitat Autonoma
// de Barcelona (UAB).
//
// This work is licensed under the terms of the MIT license.
// For a copy, see <https://opensource.org/licenses/MIT>.

#include "Carla.h"
#include "TrafficSignBase.h"

ATrafficSignBase::ATrafficSignBase(const FObjectInitializer &ObjectInitializer)
  : Super(ObjectInitializer) {
  PrimaryActorTick.bCanEverTick = false;

  RootComponent =
      ObjectInitializer.CreateDefaultSubobject<USceneComponent>(this, TEXT("SceneRootComponent"));
  RootComponent->SetMobility(EComponentMobility::Static);

  TrafficSignAgentComponent =
      CreateDefaultSubobject<UTrafficSignAgentComponent>(TEXT("TrafficSignAgentComponent"));
  TrafficSignAgentComponent->SetupAttachment(RootComponent);
  TrafficSignAgentComponent->SetMobility(EComponentMobility::Static);
}
