/*
Copyright 2018 The Rook Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeCephFilesystemSubVolumeGroups implements CephFilesystemSubVolumeGroupInterface
type FakeCephFilesystemSubVolumeGroups struct {
	Fake *FakeCephV1
	ns   string
}

var cephfilesystemsubvolumegroupsResource = v1.SchemeGroupVersion.WithResource("cephfilesystemsubvolumegroups")

var cephfilesystemsubvolumegroupsKind = v1.SchemeGroupVersion.WithKind("CephFilesystemSubVolumeGroup")

// Get takes name of the cephFilesystemSubVolumeGroup, and returns the corresponding cephFilesystemSubVolumeGroup object, and an error if there is any.
func (c *FakeCephFilesystemSubVolumeGroups) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.CephFilesystemSubVolumeGroup, err error) {
	emptyResult := &v1.CephFilesystemSubVolumeGroup{}
	obj, err := c.Fake.
		Invokes(testing.NewGetActionWithOptions(cephfilesystemsubvolumegroupsResource, c.ns, name, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.CephFilesystemSubVolumeGroup), err
}

// List takes label and field selectors, and returns the list of CephFilesystemSubVolumeGroups that match those selectors.
func (c *FakeCephFilesystemSubVolumeGroups) List(ctx context.Context, opts metav1.ListOptions) (result *v1.CephFilesystemSubVolumeGroupList, err error) {
	emptyResult := &v1.CephFilesystemSubVolumeGroupList{}
	obj, err := c.Fake.
		Invokes(testing.NewListActionWithOptions(cephfilesystemsubvolumegroupsResource, cephfilesystemsubvolumegroupsKind, c.ns, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.CephFilesystemSubVolumeGroupList{ListMeta: obj.(*v1.CephFilesystemSubVolumeGroupList).ListMeta}
	for _, item := range obj.(*v1.CephFilesystemSubVolumeGroupList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested cephFilesystemSubVolumeGroups.
func (c *FakeCephFilesystemSubVolumeGroups) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchActionWithOptions(cephfilesystemsubvolumegroupsResource, c.ns, opts))

}

// Create takes the representation of a cephFilesystemSubVolumeGroup and creates it.  Returns the server's representation of the cephFilesystemSubVolumeGroup, and an error, if there is any.
func (c *FakeCephFilesystemSubVolumeGroups) Create(ctx context.Context, cephFilesystemSubVolumeGroup *v1.CephFilesystemSubVolumeGroup, opts metav1.CreateOptions) (result *v1.CephFilesystemSubVolumeGroup, err error) {
	emptyResult := &v1.CephFilesystemSubVolumeGroup{}
	obj, err := c.Fake.
		Invokes(testing.NewCreateActionWithOptions(cephfilesystemsubvolumegroupsResource, c.ns, cephFilesystemSubVolumeGroup, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.CephFilesystemSubVolumeGroup), err
}

// Update takes the representation of a cephFilesystemSubVolumeGroup and updates it. Returns the server's representation of the cephFilesystemSubVolumeGroup, and an error, if there is any.
func (c *FakeCephFilesystemSubVolumeGroups) Update(ctx context.Context, cephFilesystemSubVolumeGroup *v1.CephFilesystemSubVolumeGroup, opts metav1.UpdateOptions) (result *v1.CephFilesystemSubVolumeGroup, err error) {
	emptyResult := &v1.CephFilesystemSubVolumeGroup{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateActionWithOptions(cephfilesystemsubvolumegroupsResource, c.ns, cephFilesystemSubVolumeGroup, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.CephFilesystemSubVolumeGroup), err
}

// Delete takes name of the cephFilesystemSubVolumeGroup and deletes it. Returns an error if one occurs.
func (c *FakeCephFilesystemSubVolumeGroups) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(cephfilesystemsubvolumegroupsResource, c.ns, name, opts), &v1.CephFilesystemSubVolumeGroup{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCephFilesystemSubVolumeGroups) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewDeleteCollectionActionWithOptions(cephfilesystemsubvolumegroupsResource, c.ns, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v1.CephFilesystemSubVolumeGroupList{})
	return err
}

// Patch applies the patch and returns the patched cephFilesystemSubVolumeGroup.
func (c *FakeCephFilesystemSubVolumeGroups) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.CephFilesystemSubVolumeGroup, err error) {
	emptyResult := &v1.CephFilesystemSubVolumeGroup{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(cephfilesystemsubvolumegroupsResource, c.ns, name, pt, data, opts, subresources...), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.CephFilesystemSubVolumeGroup), err
}
