/*
Copyright 2018 The Rook Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeCephNFSes implements CephNFSInterface
type FakeCephNFSes struct {
	Fake *FakeCephV1
	ns   string
}

var cephnfsesResource = v1.SchemeGroupVersion.WithResource("cephnfses")

var cephnfsesKind = v1.SchemeGroupVersion.WithKind("CephNFS")

// Get takes name of the cephNFS, and returns the corresponding cephNFS object, and an error if there is any.
func (c *FakeCephNFSes) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.CephNFS, err error) {
	emptyResult := &v1.CephNFS{}
	obj, err := c.Fake.
		Invokes(testing.NewGetActionWithOptions(cephnfsesResource, c.ns, name, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.CephNFS), err
}

// List takes label and field selectors, and returns the list of CephNFSes that match those selectors.
func (c *FakeCephNFSes) List(ctx context.Context, opts metav1.ListOptions) (result *v1.CephNFSList, err error) {
	emptyResult := &v1.CephNFSList{}
	obj, err := c.Fake.
		Invokes(testing.NewListActionWithOptions(cephnfsesResource, cephnfsesKind, c.ns, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.CephNFSList{ListMeta: obj.(*v1.CephNFSList).ListMeta}
	for _, item := range obj.(*v1.CephNFSList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested cephNFSes.
func (c *FakeCephNFSes) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchActionWithOptions(cephnfsesResource, c.ns, opts))

}

// Create takes the representation of a cephNFS and creates it.  Returns the server's representation of the cephNFS, and an error, if there is any.
func (c *FakeCephNFSes) Create(ctx context.Context, cephNFS *v1.CephNFS, opts metav1.CreateOptions) (result *v1.CephNFS, err error) {
	emptyResult := &v1.CephNFS{}
	obj, err := c.Fake.
		Invokes(testing.NewCreateActionWithOptions(cephnfsesResource, c.ns, cephNFS, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.CephNFS), err
}

// Update takes the representation of a cephNFS and updates it. Returns the server's representation of the cephNFS, and an error, if there is any.
func (c *FakeCephNFSes) Update(ctx context.Context, cephNFS *v1.CephNFS, opts metav1.UpdateOptions) (result *v1.CephNFS, err error) {
	emptyResult := &v1.CephNFS{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateActionWithOptions(cephnfsesResource, c.ns, cephNFS, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.CephNFS), err
}

// Delete takes name of the cephNFS and deletes it. Returns an error if one occurs.
func (c *FakeCephNFSes) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(cephnfsesResource, c.ns, name, opts), &v1.CephNFS{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCephNFSes) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewDeleteCollectionActionWithOptions(cephnfsesResource, c.ns, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v1.CephNFSList{})
	return err
}

// Patch applies the patch and returns the patched cephNFS.
func (c *FakeCephNFSes) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.CephNFS, err error) {
	emptyResult := &v1.CephNFS{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(cephnfsesResource, c.ns, name, pt, data, opts, subresources...), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.CephNFS), err
}
