/*
Copyright 2018 The Rook Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// CephBucketTopicLister helps list CephBucketTopics.
// All objects returned here must be treated as read-only.
type CephBucketTopicLister interface {
	// List lists all CephBucketTopics in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephBucketTopic, err error)
	// CephBucketTopics returns an object that can list and get CephBucketTopics.
	CephBucketTopics(namespace string) CephBucketTopicNamespaceLister
	CephBucketTopicListerExpansion
}

// cephBucketTopicLister implements the CephBucketTopicLister interface.
type cephBucketTopicLister struct {
	listers.ResourceIndexer[*v1.CephBucketTopic]
}

// NewCephBucketTopicLister returns a new CephBucketTopicLister.
func NewCephBucketTopicLister(indexer cache.Indexer) CephBucketTopicLister {
	return &cephBucketTopicLister{listers.New[*v1.CephBucketTopic](indexer, v1.Resource("cephbuckettopic"))}
}

// CephBucketTopics returns an object that can list and get CephBucketTopics.
func (s *cephBucketTopicLister) CephBucketTopics(namespace string) CephBucketTopicNamespaceLister {
	return cephBucketTopicNamespaceLister{listers.NewNamespaced[*v1.CephBucketTopic](s.ResourceIndexer, namespace)}
}

// CephBucketTopicNamespaceLister helps list and get CephBucketTopics.
// All objects returned here must be treated as read-only.
type CephBucketTopicNamespaceLister interface {
	// List lists all CephBucketTopics in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephBucketTopic, err error)
	// Get retrieves the CephBucketTopic from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.CephBucketTopic, error)
	CephBucketTopicNamespaceListerExpansion
}

// cephBucketTopicNamespaceLister implements the CephBucketTopicNamespaceLister
// interface.
type cephBucketTopicNamespaceLister struct {
	listers.ResourceIndexer[*v1.CephBucketTopic]
}
