/*
Copyright 2018 The Rook Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// CephClusterLister helps list CephClusters.
// All objects returned here must be treated as read-only.
type CephClusterLister interface {
	// List lists all CephClusters in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephCluster, err error)
	// CephClusters returns an object that can list and get CephClusters.
	CephClusters(namespace string) CephClusterNamespaceLister
	CephClusterListerExpansion
}

// cephClusterLister implements the CephClusterLister interface.
type cephClusterLister struct {
	listers.ResourceIndexer[*v1.CephCluster]
}

// NewCephClusterLister returns a new CephClusterLister.
func NewCephClusterLister(indexer cache.Indexer) CephClusterLister {
	return &cephClusterLister{listers.New[*v1.CephCluster](indexer, v1.Resource("cephcluster"))}
}

// CephClusters returns an object that can list and get CephClusters.
func (s *cephClusterLister) CephClusters(namespace string) CephClusterNamespaceLister {
	return cephClusterNamespaceLister{listers.NewNamespaced[*v1.CephCluster](s.ResourceIndexer, namespace)}
}

// CephClusterNamespaceLister helps list and get CephClusters.
// All objects returned here must be treated as read-only.
type CephClusterNamespaceLister interface {
	// List lists all CephClusters in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephCluster, err error)
	// Get retrieves the CephCluster from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.CephCluster, error)
	CephClusterNamespaceListerExpansion
}

// cephClusterNamespaceLister implements the CephClusterNamespaceLister
// interface.
type cephClusterNamespaceLister struct {
	listers.ResourceIndexer[*v1.CephCluster]
}
