/*
Copyright 2018 The Rook Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// CephFilesystemMirrorLister helps list CephFilesystemMirrors.
// All objects returned here must be treated as read-only.
type CephFilesystemMirrorLister interface {
	// List lists all CephFilesystemMirrors in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephFilesystemMirror, err error)
	// CephFilesystemMirrors returns an object that can list and get CephFilesystemMirrors.
	CephFilesystemMirrors(namespace string) CephFilesystemMirrorNamespaceLister
	CephFilesystemMirrorListerExpansion
}

// cephFilesystemMirrorLister implements the CephFilesystemMirrorLister interface.
type cephFilesystemMirrorLister struct {
	listers.ResourceIndexer[*v1.CephFilesystemMirror]
}

// NewCephFilesystemMirrorLister returns a new CephFilesystemMirrorLister.
func NewCephFilesystemMirrorLister(indexer cache.Indexer) CephFilesystemMirrorLister {
	return &cephFilesystemMirrorLister{listers.New[*v1.CephFilesystemMirror](indexer, v1.Resource("cephfilesystemmirror"))}
}

// CephFilesystemMirrors returns an object that can list and get CephFilesystemMirrors.
func (s *cephFilesystemMirrorLister) CephFilesystemMirrors(namespace string) CephFilesystemMirrorNamespaceLister {
	return cephFilesystemMirrorNamespaceLister{listers.NewNamespaced[*v1.CephFilesystemMirror](s.ResourceIndexer, namespace)}
}

// CephFilesystemMirrorNamespaceLister helps list and get CephFilesystemMirrors.
// All objects returned here must be treated as read-only.
type CephFilesystemMirrorNamespaceLister interface {
	// List lists all CephFilesystemMirrors in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephFilesystemMirror, err error)
	// Get retrieves the CephFilesystemMirror from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.CephFilesystemMirror, error)
	CephFilesystemMirrorNamespaceListerExpansion
}

// cephFilesystemMirrorNamespaceLister implements the CephFilesystemMirrorNamespaceLister
// interface.
type cephFilesystemMirrorNamespaceLister struct {
	listers.ResourceIndexer[*v1.CephFilesystemMirror]
}
