/*
Copyright 2018 The Rook Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// CephNFSLister helps list CephNFSes.
// All objects returned here must be treated as read-only.
type CephNFSLister interface {
	// List lists all CephNFSes in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephNFS, err error)
	// CephNFSes returns an object that can list and get CephNFSes.
	CephNFSes(namespace string) CephNFSNamespaceLister
	CephNFSListerExpansion
}

// cephNFSLister implements the CephNFSLister interface.
type cephNFSLister struct {
	listers.ResourceIndexer[*v1.CephNFS]
}

// NewCephNFSLister returns a new CephNFSLister.
func NewCephNFSLister(indexer cache.Indexer) CephNFSLister {
	return &cephNFSLister{listers.New[*v1.CephNFS](indexer, v1.Resource("cephnfs"))}
}

// CephNFSes returns an object that can list and get CephNFSes.
func (s *cephNFSLister) CephNFSes(namespace string) CephNFSNamespaceLister {
	return cephNFSNamespaceLister{listers.NewNamespaced[*v1.CephNFS](s.ResourceIndexer, namespace)}
}

// CephNFSNamespaceLister helps list and get CephNFSes.
// All objects returned here must be treated as read-only.
type CephNFSNamespaceLister interface {
	// List lists all CephNFSes in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephNFS, err error)
	// Get retrieves the CephNFS from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.CephNFS, error)
	CephNFSNamespaceListerExpansion
}

// cephNFSNamespaceLister implements the CephNFSNamespaceLister
// interface.
type cephNFSNamespaceLister struct {
	listers.ResourceIndexer[*v1.CephNFS]
}
