package io.quarkus.micrometer.runtime.config;

import java.util.Optional;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;

/**
 * Build / static runtime config for Kafka Binders
 */
@ConfigGroup
public class KafkaConfig implements MicrometerConfig.CapabilityEnabled {
    /**
     * Kafka metrics support.
     * <p>
     * Support for Kafka metrics will be enabled if Micrometer support is enabled,
     * the Kafka Consumer or Producer interface is on the classpath
     * and either this value is true, or this value is unset and
     * {@code quarkus.micrometer.binder-enabled-default} is true.
     */
    @ConfigItem
    public Optional<Boolean> enabled;

    @Override
    public Optional<Boolean> getEnabled() {
        return enabled;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName()
                + "{enabled=" + enabled
                + '}';
    }
}
