/*
 * Decompiled with CFR 0.152.
 */
package com.jomofisher.bootstrap;

import com.jomofisher.bootstrap.WebUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class Bootstrap {
    private PrintStream out = System.out;
    private File downloadFolder = null;
    private String entryPoint = null;
    private List<String> dependencies = new ArrayList<String>();
    private List<File> localJars = new ArrayList<File>();
    private String manifest = null;

    Bootstrap(File downloadFolder, PrintStream out) {
        this.out = out;
        this.downloadFolder = downloadFolder;
    }

    private static File getDownloadsFolder() {
        File userFolder = new File(System.getProperty("user.home"));
        return new File(userFolder, ".cdep/bootstrap/downloads");
    }

    public static void main(String[] args) throws Exception {
        new Bootstrap(Bootstrap.getDownloadsFolder(), System.out).go(args);
    }

    void go(String[] args) throws IOException, URISyntaxException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (!this.handleVersion(args)) {
            return;
        }
        if (!this.handleMonkeyParse(args[0])) {
            return;
        }
        if (!this.handleDownload()) {
            return;
        }
        URL[] urls = new URL[this.localJars.size()];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = this.localJars.get(i).toURI().toURL();
        }
        URLClassLoader classLoader = new URLClassLoader(urls);
        Class<?> clazz = classLoader.loadClass(this.entryPoint);
        Method method = clazz.getMethod("main", String[].class);
        String[] newArgs = new String[args.length - 1];
        for (int i = 0; i < newArgs.length; ++i) {
            newArgs[i] = args[i + 1];
        }
        try {
            method.invoke(null, new Object[]{newArgs});
        }
        catch (NoClassDefFoundError e) {
            this.out.printf(String.format("Possible bootstrap problem. Try deleting %s", Bootstrap.getDownloadsFolder()), new Object[0]);
        }
    }

    private boolean handleDownload() throws IOException {
        for (String dependency : this.dependencies) {
            File file = new File(dependency);
            if (file.isFile()) {
                this.localJars.add(file);
                continue;
            }
            String name = dependency.substring(dependency.lastIndexOf(47));
            File download = new File(this.downloadFolder, String.format("%s", this.manifest.hashCode()));
            download.mkdirs();
            download = new File(download, name);
            if (!download.exists()) {
                this.out.print(String.format("Downloading %s\n", dependency));
                WebUtils.copyUrlToLocalFile(new URL(dependency), download);
            }
            this.localJars.add(download);
        }
        return true;
    }

    private boolean handleMonkeyParse(String manifestUrl) throws IOException {
        this.out.printf("Manifest %s\n", manifestUrl);
        this.manifest = WebUtils.getUrlAsString(manifestUrl);
        String[] lines = this.manifest.split("\\r?\\n");
        String section = null;
        for (String line : lines) {
            if ((line = line.trim()).startsWith("entry:")) {
                this.entryPoint = line.substring(6).trim();
                continue;
            }
            if (line.endsWith(":")) {
                section = line.substring(0, line.lastIndexOf(58));
                continue;
            }
            if (!line.startsWith("- ") || !"dependencies".equals(section)) continue;
            this.dependencies.add(line.substring(2).trim());
        }
        if (this.entryPoint == null) {
            throw new RuntimeException(String.format("Bootstrap manifest %s is missing 'entry:'", manifestUrl));
        }
        if (this.dependencies.size() == 0) {
            throw new RuntimeException(String.format("Bootstrap manifest %s is missing 'dependencies:'", manifestUrl));
        }
        return true;
    }

    private boolean handleVersion(String[] args) {
        if (args.length != 1 || !args[0].equals("--version")) {
            return true;
        }
        this.out.printf("bootstrap [%s]\n", "0.0.16");
        return false;
    }
}

