/*
 * Decompiled with CFR 0.152.
 */
package io.cdep.bootstrap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

public class WebUtils {
    public static String getUrlAsString(String url) throws IOException {
        String inputLine;
        File file = new File(url);
        if (file.isFile()) {
            byte[] encoded = Files.readAllBytes(Paths.get(url, new String[0]));
            return new String(encoded, StandardCharsets.UTF_8);
        }
        URL urlObj = new URL(url);
        URLConnection con = urlObj.openConnection();
        con.setDoOutput(true);
        con.connect();
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuilder response = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine + newLine);
        }
        in.close();
        return response.toString();
    }

    public static void pingUrl(URL url) throws IOException {
        URLConnection con = url.openConnection();
        con.connect();
        con.getInputStream().read();
    }

    public static void copyUrlToLocalFile(URL url, File localFile) throws IOException {
        int n;
        URLConnection con = url.openConnection();
        con.connect();
        InputStream input = con.getInputStream();
        byte[] buffer = new byte[4096];
        FileOutputStream output = new FileOutputStream(localFile);
        while ((n = input.read(buffer)) != -1) {
            ((OutputStream)output).write(buffer, 0, n);
        }
        ((OutputStream)output).close();
    }
}

