---
title: Azure Service Bus Tutorial
name: Azure Service Bus
thirdParty: true
alias:
  - Azure Service Bus
image: /media/platforms/azure.png
tags:
  - quickstart
---
${include('./_thirdPartyApi')}

### Additional information

Here's a sample call to the delegation endpoint to get the SAS:

```text
POST https://${account.namespace}/delegation
Content-Type: 'application/json'
{
  "client_id":   "${account.clientId}",
  "grant_type":  "urn:ietf:params:oauth:grant-type:jwt-bearer",
  "id_token":    "{YOUR_ID_TOKEN}",
  "target":      "${account.clientId}",
  "api_type":    "azure_sb",
  "scope":       "openid"
}
```

* The `client_id` value identifies the requesting app (e.g. your website) and `{YOUR_ID_TOKEN}` identifies the user you are requesting this on behalf-of. (Notice that the `id_token` is signed with the `client_id` corresponding `clientSecret`).
* The `target` parameter identifies this API endpoint in Auth0 (often the same as `{CLIENT ID}`. This is the `client_id` of the app where this add-on has been enabled.
* `api_type` must be `azure_sb`.
* `scope` must be `openid`.

The result of calling the delegation endpoint will be something like:

```json
{
  "azure_sb_sas": "SharedAccessSignature sig=k8bNfT81R8L...LztXvY%3D&se=14098336&skn=PolicyName&sr=http%3A%2F%2Fnamespace.servicebus.windows.net%2Fmy_queue"
}
```

![](https://docs.google.com/drawings/d/1aTHLCUPT4fCOXgX6fvUpxJdzd_rH_VzayBkLwLkwOBk/pub?w=784&amp;h=437)
