---
title: Nginx API Tutorial
name: Nginx API
alias:
  - nginx
  - openresty
languages:
  - Lua
image: /media/platforms/nginx.png
tags:
  - quickstart
snippets:
  dependencies: server-apis/nginx/dependencies
  setup: server-apis/nginx/setup
  use: server-apis/nginx/use
---

## Nginx API Tutorial

**Please follow the steps below to secure your existing API with an Nginx reverse-proxy that's configured to process JWT's generated by your Auth0 account.**

### 1. Install the `nginx-jwt` script into your Nginx server

The [`nginx-jwt`](https://github.com/auth0/nginx-jwt) script is a Lua script that is designed to run on Nginx servers that have the [HttpLuaModule](http://wiki.nginx.org/HttpLuaModule) installed. But ultimately its dependencies require components available in the [OpenResty](http://openresty.org/) distribution of Nginx. Therefore, it is recommended that you use **OpenResty** as your Nginx server, and these instructions make that assumption.

1. Download the latest archive package from [releases](https://github.com/auth0/nginx-jwt/releases).
1. Extract the archive and deploy its contents to a directory on your Nginx server.
1. Specify this directory's path using ngx_lua's [lua_package_path](https://github.com/openresty/lua-nginx-module#lua_package_path) directive:  

${snippet(meta.snippets.dependencies)}

### 2. Configure `nginx-jwt` with your Auth0 account

1. Export the `JWT_SECRET` environment variable on the Nginx host, setting it equal to your Auth0 Client Secret (`${account.clientSecret}`).
1. Export the `JWT_SECRET_IS_BASE64_ENCODED` environment variable on the Nginx host, setting it equal to `true`.
1. Expose both environment variables to the Nginx server:

${snippet(meta.snippets.setup)}

### 3. Secure your API

Now, secure one or more locations that point to your backing service endpoints by using the [access_by_lua](https://github.com/openresty/lua-nginx-module#access_by_lua) directive to call the `nginx-jwt` script's [`auth()`](https://github.com/auth0/nginx-jwt#auth) function before executing any [proxy_* directives](http://nginx.org/en/docs/http/ngx_http_proxy_module.html):

${snippet(meta.snippets.use)}

Click [here](https://github.com/auth0/nginx-jwt#usage) for more usage examples.

### 4. You're done!

Now you have both your FrontEnd and Backend configured to use Auth0. Congrats, you're awesome!
