<?php
/**
 * Zend Framework
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://framework.zend.com/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@zend.com so we can send you a copy immediately.
 *
 * @category   Zend
 * @package    Zend_Controller
 * @subpackage Zend_Controller_Plugin
 * @copyright  Copyright (c) 2005-2011 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 */

/**
 * @namespace
 */
namespace Zend\Controller\Plugin;

/**
 * Plugin to digest PUT request body and make params available just like POST
 *
 * @uses       \Zend\Controller\Plugin\AbstractPlugin
 * @uses       \Zend\Controller\Request\Http
 * @package    Zend_Controller
 * @subpackage Zend_Controller_Plugin
 * @copyright  Copyright (c) 2005-2011 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 */
class PutHandler extends AbstractPlugin
{
    /**
     * Before dispatching, digest PUT request body and set params
     *
     * @param \Zend\Controller\Request\AbstractRequest $request
     */
    public function preDispatch(\Zend\Controller\Request\AbstractRequest $request)
    {
        if (!$request instanceof \Zend\Controller\Request\Http) {
            return;
        }

        if ($this->_request->isPut()) {
            $putParams = array();
            parse_str($this->_request->getRawBody(), $putParams);
            $request->setParams($putParams);
        }
    }
}
