<?php
/**
 * Zend Framework
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://framework.zend.com/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@zend.com so we can send you a copy immediately.
 *
 * @category   Zend
 * @package    Zend_Reflection
 * @copyright  Copyright (c) 2005-2011 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 */

/**
 * @namespace
 */
namespace Zend\Reflection\Docblock\Tag;
use Zend\Reflection,
    Zend\Reflection\Exception;

/**
 * @uses       \Zend\Reflection\Exception
 * @uses       \Zend\Reflection\ReflectionDocblockTag
 * @category   Zend
 * @package    Zend_Reflection
 * @copyright  Copyright (c) 2005-2011 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 */
class ReturnTag extends Reflection\ReflectionDocblockTag
{
    /**
     * @var string
     */
    protected $_type = null;

    /**
     * Constructor
     *
     * @param  string $tagDocblockLine
     * @return void
     */
    public function __construct($tagDocblockLine)
    {
        if (!preg_match('#^@(\w+)\s+([\w|\\\]+)(?:\s+(.*))?#', $tagDocblockLine, $matches)) {
            throw new Exception\InvalidArgumentException('Provided docblock line is does not contain a valid tag');
        }

        if ($matches[1] != 'return') {
            throw new Exception\InvalidArgumentException('Provided docblock line is does not contain a valid @return tag');
        }

        $this->_name = 'return';
        $this->_type = $matches[2];
        if (isset($matches[3])) {
            $this->_description = $matches[3];
        }
    }

    /**
     * Get return variable type
     *
     * @return string
     */
    public function getType()
    {
        return $this->_type;
    }
}
