<?php
/**
 * Zend Framework
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://framework.zend.com/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@zend.com so we can send you a copy immediately.
 *
 * @category   Zend
 * @package    Zend_Controller
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2005-2011 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 */

/**
 * @namespace
 */
namespace ZendTest\Controller\Request;
use Zend\Controller\Request;

/**
 * Test class for Zend_Controller_Request_Apache404.
 * Generated by PHPUnit_Util_Skeleton on 2007-06-25 at 08:20:40.
 *
 * @category   Zend
 * @package    Zend_Controller
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2005-2011 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 * @group      Zend_Controller
 * @group      Zend_Controller_Request
 */
class Apache404Test extends \PHPUnit_Framework_TestCase
{
    /**
     * Copy of $_SERVER
     * @var array
     */
    protected $_server;

    public function setUp()
    {
        $this->_server = $_SERVER;
    }

    public function tearDown()
    {
        $_SERVER = $this->_server;
    }

    public function testRedirectUrlSelectedOverRequestUri()
    {
        $_SERVER['REDIRECT_URL'] = '/foo/bar';
        $_SERVER['REQUEST_URI']  = '/baz/bat';

        $request = new Request\Apache404();
        $requestUri = $request->getRequestUri();
        $this->assertEquals('/foo/bar', $requestUri);
    }

    /**
     * @group ZF-3057
     */
    public function testRedirectQueryStringShouldBeParsedIntoGetVars()
    {
        $_SERVER['REDIRECT_URL']         = '/foo/bar';
        $_SERVER['REDIRECT_QUERYSTRING'] = 'baz=bat&bat=delta';
        $_SERVER['REQUEST_URI']          = '/baz/bat';

        $request = new Request\Apache404();
        $requestUri = $request->getRequestUri();
        $this->assertEquals('/foo/bar', $requestUri);
        $this->assertSame(array('baz' => 'bat', 'bat' => 'delta'), $request->getQuery());
    }
}

