<?php
/**
 * Zend Framework
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://framework.zend.com/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@zend.com so we can send you a copy immediately.
 *
 * @category   Zend
 * @package    Zend_Markup
 * @subpackage Renderer_Html
 * @copyright  Copyright (c) 2005-2011 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 */

/**
 * @namespace
 */
namespace ZendTest\Markup\TestAsset\Renderer\Html;

use Zend\Markup\Renderer\AbstractRenderer;

/**
 * Tag interface
 *
 * @category   Zend
 * @package    Zend_Markup
 * @subpackage Renderer_Html
 * @copyright  Copyright (c) 2005-2011 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 */
class Bar implements \Zend\Markup\Renderer\Markup
{
    public function setEncoding($encoding = 'UTF-8')
    {
    }
   
    public function setRenderer(AbstractRenderer $renderer)
    {
    }

    /**
     * Convert the token
     *
     * @param Zend_Markup_Token $token
     * @param string $text
     *
     * @return string
     */
    public function __invoke(\Zend\Markup\Token $token, $text)
    {
        $bar = $token->getAttribute('bar');

        if (!empty($bar)) {
            $bar = '=' . $bar;
        }

        return "[foo{$bar}]" . $text . '[/foo]';
    }

}
