## Rails 3.2.7 (unreleased)

* Since Rails 3.2, use layout false to render no layout
* Use strict_args_position! if available from Thor

## Rails 3.2.6 (Jun 12, 2012)

*   No changes.

## Rails 3.2.4 (May 31, 2012) ##

*   Add hook for resource route's generator. *Santiago Pastorino*


## Rails 3.2.3 (unreleased) ##

*   No changes.


## Rails 3.2.2 (March 1, 2012) ##

*   No changes.


## Rails 3.2.1 (January 26, 2012) ##

*   Documentation fixes.

*   Migration generation understands decimal{1.2} and decimal{1-2}, in
    addition to decimal{1,2}. *José Valim*


## Rails 3.2.0 (January 20, 2012) ##

*   Rails 2.3-style plugins in vendor/plugins are deprecated and will be removed in Rails 4.0. Move them out of vendor/plugins and bundle them in your Gemfile, or fold them in to your app as lib/myplugin/* and config/initializers/myplugin.rb.  *Santiago Pastorino*

*   Guides are available as a single .mobi for the Kindle and free Kindle readers apps. *Michael Pearson & Xavier Noria*

*   Allow scaffold/model/migration generators to accept a "index" and "uniq" modifiers, as in: "tracking_id:integer:uniq" in order to generate (unique) indexes. Some types also accept custom options, for instance, you can specify the precision and scale for decimals as "price:decimal{7,2}". *Dmitrii Samoilov*

*   Added `config.exceptions_app` to set the exceptions application invoked by the ShowException middleware when an exception happens. Defaults to `ActionDispatch::PublicExceptions.new(Rails.public_path)`. *José Valim*

*   Speed up development by only reloading classes if dependencies files changed. This can be turned off by setting `config.reload_classes_only_on_change` to false. *José Valim*

*   New applications get a flag `config.active_record.auto_explain_threshold_in_seconds` in the environments configuration files. With a value of 0.5 in development.rb, and commented out in production.rb. No mention in test.rb. *fxn*

*   Add DebugExceptions middleware which contains features extracted from ShowExceptions middleware *José Valim*

*   Display mounted engine's routes in `rake routes` *Piotr Sarnacki*

*   Allow to change the loading order of railties with `config.railties_order=` *Piotr Sarnacki*

    Example:
        config.railties_order = [Blog::Engine, :main_app, :all]

*   Scaffold returns 204 No Content for API requests without content. This makes scaffold work with jQuery out of the box *José Valim*

*   Update Rails::Rack::Logger middleware to apply any tags set in config.log_tags to the newly ActiveSupport::TaggedLogging Rails.logger. This makes it easy to tag log lines with debug information like subdomain and request id -- both very helpful in debugging multi-user production applications *DHH*

*   Default options to `rails new` can be set in ~/.railsrc *Guillermo Iguaran*

*   Add destroy alias to Rails engines *Guillermo Iguaran*

*   Add destroy alias for Rails command line. This allows the following: `rails d model post` *Andrey Ognevsky*

*   Attributes on scaffold and model generators default to string. This allows the following: "rails g scaffold Post title body:text author" *José Valim*

*   Remove old plugin generator (`rails generate plugin`) in favor of `rails plugin new` command *Guillermo Iguaran*

*   Remove old 'config.paths.app.controller' API in favor of 'config.paths["app/controller"]' API *Guillermo Iguaran*


## Rails 3.1.2 (November 18, 2011) ##

*   Engines: don't blow up if db/seeds.rb is missing.

    *Jeremy Kemper*

*   `rails new foo --skip-test-unit` should not add the `:test` task to the rake default task.
    *GH 2564*

    *José Valim*


## Rails 3.1.1 (October 7, 2011) ##

*   Add jquery-rails to Gemfile of plugins, test/dummy app needs it. Closes #3091. *Santiago Pastorino*

*   Add config.assets.initialize_on_precompile which, when set to false, forces
    `rake assets:precompile` to load the application but does not initialize it.

    To the app developer, this means configuration add in
    config/initializers/* will not be executed.

    Plugins developers need to special case their initializers that are
    meant to be run in the assets group by adding :group => :assets.


## Rails 3.1.0 (August 30, 2011) ##

*   The default database schema file is written as UTF-8. *Aaron Patterson*

*   Generated apps with --dev or --edge flags depend on git versions of
    sass-rails and coffee-rails. *Santiago Pastorino*

*   Rack::Sendfile middleware is used only if x_sendfile_header is present. *Santiago Pastorino*

*   Add JavaScript Runtime name to the Rails Info properties. *DHH*

*   Make pp enabled by default in Rails console. *Akira Matsuda*

*   Add alias `r` for rails runner. *Jordi Romero*

*   Make sprockets/railtie require explicit and add --skip-sprockets to app generator *José Valim*

*   Added Rails.groups that automatically handles Rails.env and ENV["RAILS_GROUPS"] *José Valim*

*   The new rake task assets:clean removes precompiled assets. *fxn*

*   Application and plugin generation run bundle install unless --skip-gemfile or --skip-bundle. *fxn*

*   Fixed database tasks for jdbc* adapters #jruby *Rashmi Yadav*

*   Template generation for jdbcpostgresql  #jruby *Vishnu Atrai*

*   Template generation for jdbcmysql and jdbcsqlite3 #jruby *Arun Agrawal*

*   The -j option of the application generator accepts an arbitrary string. If passed "foo",
    the gem "foo-rails" is added to the Gemfile, and the application JavaScript manifest
    requires "foo" and "foo_ujs". As of this writing "prototype-rails" and "jquery-rails"
    exist and provide those files via the asset pipeline. Default is "jquery". *fxn*

*   jQuery is no longer vendored, it is provided from now on by the jquery-rails gem. *fxn*

*   Prototype and Scriptaculous are no longer vendored, they are provided from now on
    by the prototype-rails gem. *fxn*

*   The scaffold controller will now produce SCSS file if Sass is available *Prem Sichanugrist*

*   The controller and resource generators will now automatically produce asset stubs (this can be turned off with --skip-assets). These stubs will use Coffee and Sass, if those libraries are available. *DHH*

*   jQuery is the new default JavaScript library. *fxn*

*   Changed scaffold, application, and mailer generator to create Ruby 1.9 style hash when running on Ruby 1.9 *Prem Sichanugrist*

    So instead of creating something like:

        redirect_to users_path, :notice => "User has been created"

    it will now be like this:

        redirect_to users_path, notice: "User has been created"

    You can also passing `--old-style-hash` to make Rails generate old style hash even you're on Ruby 1.9

*   Changed scaffold_controller generator to create format block for JSON instead of XML *Prem Sichanugrist*

*   Add using Turn with natural language test case names for test_help.rb when running with minitest (Ruby 1.9.2+) *DHH*

*   Direct logging of Active Record to STDOUT so it's shown inline with the results in the console *DHH*

*   Added `config.force_ssl` configuration which loads Rack::SSL middleware and force all requests to be under HTTPS protocol *DHH, Prem Sichanugrist, and Josh Peek*

*   Added `rails plugin new` command which generates rails plugin with gemspec, tests and dummy application for testing *Piotr Sarnacki*

*   Added -j parameter with jquery/prototype as options. Now you can create your apps with jQuery using `rails new myapp -j jquery`. The default is still Prototype. *siong1987*

*   Added Rack::Etag and Rack::ConditionalGet to the default middleware stack *José Valim*

*   Added Rack::Cache to the default middleware stack *Yehuda Katz and Carl Lerche*

*   Engine is now rack application *Piotr Sarnacki*

*   Added middleware stack to Engine *Piotr Sarnacki*

*   Engine can now load plugins *Piotr Sarnacki*

*   Engine can load its own environment file *Piotr Sarnacki*

*   Added helpers to call engines' route helpers from application and vice versa *Piotr Sarnacki*

*   Task for copying plugins' and engines' migrations to application's db/migrate directory *Piotr Sarnacki*

*   Changed ActionDispatch::Static to allow handling multiple directories *Piotr Sarnacki*

*   Added isolate_namespace() method to Engine, which sets Engine as isolated *Piotr Sarnacki*

*   Include all helpers from plugins and shared engines in application *Piotr Sarnacki*


## Rails 3.0.7 (April 18, 2011) ##

*   No changes.


*   Rails 3.0.6 (April 5, 2011)

*   No changes.


## Rails 3.0.5 (February 26, 2011) ##

*   No changes.


## Rails 3.0.4 (February 8, 2011) ##

*   No changes.


## Rails 3.0.3 (November 16, 2010) ##

*   No changes.


## Rails 3.0.2 (November 15, 2010) ##

*   No changes.


## Rails 3.0.1 (October 15, 2010) ##

*   No Changes, just a version bump.


## Rails 3.0.0 (August 29, 2010) ##

*   Application generation: --skip-testunit and --skip-activerecord become --skip-test-unit and --skip-active-record respectively. *fxn*

*   Added console to Rails::Railtie as a hook called just after console starts. *José Valim*

*   Rails no longer autoload code in lib for application. You need to explicitly require it. *José Valim*

*   Rails::LogSubscriber was renamed to ActiveSupport::LogSubscriber *José Valim*

*   config.load_(once_)paths in config/application.rb got renamed to config.autoload_(once_)paths. *fxn*

*   Abort generation/booting on Ruby 1.9.1. *fxn*

*   Made the rails command work even when you're in a subdirectory *Chad Fowler*

*   Removed Rails Metal [Yehuda Katz, José Valim].

*   Renamed config.cookie_secret to config.secret_token and pass it as env key. *José Valim*

*   Session store configuration has changed *Yehuda Katz, Carl Lerche*

        config.session_store :cookie_store, {:key => "..."}
        config.cookie_secret = "fdsfhisdghfidugnfdlg"

*   railtie_name and engine_name are deprecated. You can now add any object to
    the configuration object: config.your_plugin = {} *José Valim*

*   Added config.generators.templates to provide alternative paths for the generators
    to look for templates *José Valim*

*   Added "rake about" as a replacement for script/about *DHH*

*   Removed all the default commands in script/* and replaced them with script/rails and a rails command that'll act the same when run from within the app [DHH]. Example:

    ./script/generate scaffold post title:string  can now be called as  rails g scaffold post title:string

    Run rails --help inside an app for more help.

*   Removed config/initializers/new_rails_defaults.rb as all frameworks now follow the settings from it *DHH*

*   Set config.time_zone to UTC by default *DHH*

*   Added default .gitignore (this is just recognizing Git market share, don't throw a hissy if you use another SCM) *DHH*

*   Added cookies.permanent, cookies.signed, and cookies.permanent.signed accessor for common cookie actions [DHH]. Examples:

        cookies.permanent[:prefers_open_id] = true
        # => Set-Cookie: prefers_open_id=true; path=/; expires=Sun, 16-Dec-2029 03:24:16 GMT

        cookies.signed[:discount] = 45
        # => Set-Cookie: discount=BAhpMg==--2c1c6906c90a3bc4fd54a51ffb41dffa4bf6b5f7; path=/

        cookies.signed[:discount]
        # => 45 (if the cookie was changed, you'll get a InvalidSignature exception)

        cookies.permanent.signed[:remember_me] = current_user.id
        # => Set-Cookie: discount=BAhU--848956038e692d7046deab32b7131856ab20e14e; path=/; expires=Sun, 16-Dec-2029 03:24:16 GMT

    ...to use the signed cookies, you need to set a secret to ActionController::Base.cookie_verifier_secret (automatically done in config/initializers/cookie_verification_secret.rb for new Rails applications).

*   Added config/initializers/cookie_verification_secret.rb with an auto-generated secret for using ActionController::Base#cookies.signed *DHH*

*   Fixed that the debugger wouldn't go into IRB mode because of left-over ARGVs *DHH*

*   I18n support for plugins.  #2325 *Antonio Tapiador, Sven Fuchs*

*   Ruby 1.9: use UTF-8 for default internal and external encodings.  *Jeremy Kemper*

*   Added db/seeds.rb as a default file for storing seed data for the database. Can be loaded with rake db:seed (or created alongside the db with db:setup). (This is also known as the "Stop Putting Gawd Damn Seed Data In Your Migrations" feature) *DHH*


## 2.3.2 Final (March 15, 2009) ##

*   Remove outdated script/plugin options *Pratik Naik*

*   Allow metal to live in plugins #2045 *Matthew Rudy*

*   Added metal *Josh Peek*

*   Remove script/performance/request in favour of the performance integration tests. *Pratik Naik*

    To continue using script/performance/request, install the request_profiler plugin :

        script/plugin install git://github.com/rails/request_profiler.git

*   Add a rake task to apply a template to an existing application : rake rails:template LOCATION=~/template.rb *Pratik Naik*

*   Add "-m/--template" option to Rails generator to apply a template to the generated application. *Jeremy McAnally*

        This has been extracted from rg - http://github.com/jeremymcanally/rg

        Example:

            # template.rb

            # Install plugins from git or svn
            plugin "will-paginate", :git => "git://github.com/mislav/will_paginate.git"
            plugin "old-restful-auth", :svn => "http://svn.techno-weenie.net/projects/plugins/restful_authentication/"

            # Add gems to environment.rb
            gem "jeremymcanally-context"
            gem "bluecloth"

            # Vendor file. Data in a string or...
            vendor("borrowed.rb", <<CODE
              def helpful_method
                do_something_helpful_here
              end
            CODE

            # ...file data from block return value.
            # #initializer creates a new initializer file
            initializer("crypto.rb") do
              salt = "--#{Time.now}--#{rand}--#{srand(Time.now.to_i)}"

              "SPECIAL_SALT = '#{salt}'"
            end

        Usage:

          To use a template, provide a file path or URL:

          1. Using a local file :

            rails <application name> -m /path/to/my/template.rb

          2. Or directly from a URL :

            rails <application name> --template=http://gist.github.com/31208.txt

*   Extracted the process scripts (inspector, reaper, spawner) into the plugin irs_process_scripts *David Heinemeier Hansson*

*   Changed Rails.root to return a Pathname object (allows for Rails.root.join('app', 'controllers') => "#{RAILS_ROOT}/app/controllers") #1482 *Damian Janowski/?*

*   Added view path support for engines *David Heinemeier Hansson*

*   Added that config/routes.rb files in engine plugins are automatically loaded (and reloaded when they change in dev mode) *David Heinemeier Hansson*

*   Added app/[models|controllers|helpers] to the load path for plugins that has an app directory (go engines ;)) *David Heinemeier Hansson*

*   Add config.preload_frameworks to load all frameworks at startup. Default to false so Rails autoloads itself as it's used. Turn this on for Passenger and JRuby. Also turned on by config.threadsafe!  *Jeremy Kemper*

*   Add a rake task to generate dispatchers : rake rails:generate_dispatchers *Pratik Naik*

*   "rails <app>" will not generate public/dispatch.cgi/fcgi/rb files by default now. Please use "--with-dispatchers" option if you need them. *Yaroslav Markin, Pratik Naik*

*   Added rake rails:update:application_controller to renamed application.rb to application_controller.rb -- included in rake rails:update so upgrading to 2.3 will automatically trigger it #1439 *kastner*

*   Added Rails.backtrace_cleaner as an accessor for the Rails::BacktraceCleaner instance used by the framework to cut down on backtrace noise and config/initializers/backtrace_silencers.rb to add your own (or turn them all off) *David Heinemeier Hansson*

*   Switch from Test::Unit::TestCase to ActiveSupport::TestCase.  *Jeremy Kemper*

*   Added config.i18n settings gatherer to config/environment, auto-loading of all locales in config/locales/*.rb,yml, and config/locales/en.yml as a sample locale *David Heinemeier Hansson*

*   BACKWARDS INCOMPATIBLE: Renamed application.rb to application_controller.rb and removed all the special casing that was in place to support the former. You must do this rename in your own application when you upgrade to this version *David Heinemeier Hansson*


## 2.2.1 RC2 (November 14th, 2008) ##

*   Fixed plugin generator so that generated unit tests would subclass ActiveSupport::TestCase, also introduced a helper script to reduce the needed require statements #1137 *Mathias Meyer*

*   Update Prototype to 1.6.0.3 *sam*


## 2.2.0 RC1 (October 24th, 2008) ##

*   Fixed that sqlite would report "db/development.sqlite3 already exists" whether true or not on db:create #614 *Antonio Cangiano*

*   Added config.threadsafe! to toggle allow concurrency settings and disable the dependency loader *Josh Peek*

*   Turn cache_classes on by default *Josh Peek*

*   Added configurable eager load paths. Defaults to app/models, app/controllers, and app/helpers *Josh Peek*

*   Introduce simple internationalization support.  *Ruby i18n team*

*   Make script/plugin install <plugin> -r <revision> option work with git based plugins. #257. [Tim Pope Jakub Kuźma]. Example:

    script/plugin install git://github.com/mislav/will_paginate.git -r agnostic # Installs 'agnostic' branch
    script/plugin install git://github.com/dchelimsky/rspec.git -r 'tag 1.1.4'

*   Added Rails.initialized? flag *Josh Peek*

*   Make rake test:uncommitted work with Git. *Tim Pope*

*   Added Thin support to script/server.  #488 *Bob Klosinski*

*   Fix script/about in production mode.  #370 *Cheah Chu Yeow, Xavier Noria, David Krmpotic*

*   Add the gem load paths before the framework is loaded, so certain gems like RedCloth and BlueCloth can be frozen.

*   Fix discrepancies with loading rails/init.rb from gems.

*   Plugins check for the gem init path (rails/init.rb) before the standard plugin init path (init.rb)  *Jacek Becela*

*   Changed all generated tests to use the test/do declaration style *David Heinemeier Hansson*

*   Wrapped Rails.env in StringInquirer so you can do Rails.env.development? *David Heinemeier Hansson*

*   Fixed that RailsInfoController wasn't considering all requests local in development mode (Edgard Castro) *#310 state:resolved*


## 2.1.0 (May 31st, 2008) ##

*   script/dbconsole fires up the command-line database client.  #102 *Steve Purcell*

*   Fix bug where plugin init.rb files from frozen gem specs weren't being run.  (pjb3) *#122 state:resolved*

*   Made the location of the routes file configurable with config.routes_configuration_file (Scott Fleckenstein) *#88*

*   Rails Edge info returns the latest git commit hash *Francesc Esplugas*

*   Added Rails.public_path to control where HTML and assets are expected to be loaded from (defaults to Rails.root + "/public") #11581 *Nick Sieger*

*   rake time:zones:local finds correct base utc offset for zones in the Southern Hemisphere *Geoff Buesing*

*   Don't require rails/gem_builder during rails initialization, it's only needed for the gems:build task. *Rick Olson*

*   script/performance/profiler compatibility with the ruby-prof >= 0.5.0. Closes #9176. *Jonathan del Strother*

*   Flesh out rake gems:unpack to unpack all gems, and add rake gems:build for native extensions. #11513 *ddollar*

    rake gems:unpack             # unpacks all gems
    rake gems:unpack GEM=mygem   # unpacks only the gem 'mygem'

    rake gems:build              # builds all unpacked gems
    rake gems:build GEM=mygem    # builds only the gem 'mygem'

*   Add config.active_support for future configuration options.  Also, add more new Rails 3 config settings to new_rails_defaults.rb *Rick Olson*

*   Add Rails.logger, Rails.root, Rails.env and Rails.cache shortcuts for RAILS_* constants *Pratik Naik*

*   Allow files in plugins to be reloaded like the rest of the application.  *Rick Olson*

    Enables or disables plugin reloading.

        config.reload_plugins = true

    You can get around this setting per plugin.
    If #reload_plugins? == false (DEFAULT), add this to your plugin's init.rb to make it reloadable:

        Dependencies.load_once_paths.delete lib_path

    If #reload_plugins? == true, add this to your plugin's init.rb to only load it once:

        Dependencies.load_once_paths << lib_path

*   Small tweak to allow plugins to specify gem dependencies.  *Rick Olson*

    \# OLD open_id_authentication plugin init.rb
    require 'yadis'
    require 'openid'
    ActionController::Base.send :include, OpenIdAuthentication

    \# NEW
    config.gem "ruby-openid", :lib => "openid", :version => "1.1.4"
    config.gem "ruby-yadis",  :lib => "yadis",  :version => "0.3.4"

    config.after_initialize do
        ActionController::Base.send :include, OpenIdAuthentication
    end

*   Added config.gem for specifying which gems are required by the application, as well as rake tasks for installing and freezing gems. *Rick Olson*

    Rails::Initializer.run do |config|
        config.gem "bj"
        config.gem "hpricot", :version => '0.6', :source => "http://code.whytheluckystiff.net"
        config.gem "aws-s3", :lib => "aws/s3"
    end

    \# List required gems.
    rake gems

    \# Install all required gems:
    rake gems:install

    \# Unpack specified gem to vendor/gems/gem_name-x.x.x
    rake gems:unpack GEM=bj

*   Removed the default .htaccess configuration as there are so many good deployment options now (kept it as an example in README) *David Heinemeier Hansson*

*   config.time_zone accepts TZInfo::Timezone identifiers as well as Rails TimeZone identifiers *Geoff Buesing*

*   Rails::Initializer#initialize_time_zone raises an error if value assigned to config.time_zone is not recognized. Rake time zone tasks only require ActiveSupport instead of entire environment *Geoff Buesing*

*   Stop adding the antiquated test/mocks/* directories and only add them to the path if they're still there for legacy reasons *David Heinemeier Hansson*

*   Added that gems can now be plugins if they include rails/init.rb #11444 *John Barnette*

*   Added Plugin#about method to programmatically access the about.yml in a plugin #10979 *James Adam*

        plugin = Rails::Plugin.new(path_to_my_plugin)
        plugin.about["author"] # => "James Adam"
        plugin.about["url"] # => "http://interblah.net"

*   Improve documentation. *Ryan Bigg, Jan De Poorter, Cheah Chu Yeow, Xavier Shay, Jack Danger Canty, Emilio Tagua, Xavier Noria,  Sunny Ripert*

*   Added config.time_zone = 'UTC' in the default environment.rb *Geoff Buesing*

*   Added rake tasks time:zones:all, time:zones:us and time:zones:local for finding time zone names for config.time_zone option *Geoff Buesing*

*   Add config.time_zone for configuring the default Time.zone value.  #10982 *Geoff Buesing*

*   Added support for installing plugins hosted at git repositories #11294 *Jack Danger Canty*

*   Fixed that script/generate would not look for plugin generators in plugin_paths #11000 *glv*

*   Fixed database rake tasks to work with charset/collation and show proper error messages on failure. Closes #11301 *matt*

*   Added a -e/--export to script/plugin install, uses svn export. #10847 *jon@blankpad.net)*

*   Reshuffle load order so that routes and observers are initialized after plugins and app initializers.  Closes #10980 *Rick Olson*

*   Git support for script/generate.  #10690 *ssoroka*

*   Update scaffold to use labels instead of bold tags.  Closes #10757 *zach-inglis-lt3*

*   Resurrect WordNet synonym lookups.  #10710 *tom./, matt*

*   Added config.cache_store to environment options to control the default cache store (default is FileStore if tmp/cache is present, otherwise MemoryStore is used) *David Heinemeier Hansson*

*   Added that rails:update is run when you do rails:freeze:edge to ensure you also get the latest JS and config files #10565 *jeff*

*   SQLite: db:drop:all doesn't fail silently if the database is already open.  #10577 *Cheah Chu Yeow, mrichman*

*   Introduce native mongrel handler and push mutex into dispatcher.  *Jeremy Kemper*

*   Ruby 1.9 compatibility.  #1689, #10546 *Cheah Chu Yeow, frederico*


## 2.0.2 (December 16th, 2007) ##

*   Changed the default database from mysql to sqlite3, so now running "rails myapp" will have a config/database.yml that's setup for SQLite3 (which in OS X Leopard is installed by default, so is the gem, so everything Just Works with no database configuration at all). To get a Rails application preconfigured for MySQL, just run "rails -d mysql myapp" *David Heinemeier Hansson*

*   Turned on ActionView::Base.cache_template_loading by default in config/environments/production.rb to prevent file system stat calls for every template loading to see if it changed (this means that you have to restart the application to see template changes in production mode) *David Heinemeier Hansson*

*   Introduce `rake secret` to output a crytographically secure secret key for use with cookie sessions #10363 *revans*

*   Fixed that local database creation should consider 127.0.0.1 local #9026 *parcelbrat*

*   Fixed that functional tests generated for scaffolds should use fixture calls instead of hard-coded IDs #10435 *boone*

*   Added db:migrate:redo and db:migrate:reset for rerunning existing migrations #10431, #10432  *matt*

*   RAILS_GEM_VERSION may be double-quoted also.  #10443 *James Cox*

*   Update rails:freeze:gems to work with RubyGems 0.9.5.  *Jeremy Kemper*


## 2.0.1 (December 7th, 2007) ##

*   Fixed Active Record bug


## 2.0.0 (December 6th, 2007) ##

*   The test task stops with a warning if you have pending migrations.  #10377 *Josh Knowles*

*   Add warning to documentation about using transactional fixtures when the code under test uses transactions itself. Closes #7548 *Thijs van der Vossen*

*   Update Prototype to 1.6.0.1.  *sam*

*   Update script.aculo.us to 1.8.0.1.  *madrobby*

*   Added db:fixtures:identity as a way of locating what ID a foxy fixture was assigned #10332 *John Barnette*

*   Generated fixtures should not specify ids since theyre expected to be foxy fixtures #10330 *John Barnette*

*   Update to Prototype -r8232.  *sam*

*   Introduce SecretKeyGenerator for more secure session secrets than CGI::Session's pseudo-random id generator. Consider extracting to Active Support later.  #10286 *Hongli Lai (Phusion)*

*   RAILS_GEM_VERSION may be set to any valid gem version specifier.  #10057 *Chad Woolley, Cheah Chu Yeow*

*   Load config/preinitializer.rb, if present, before loading the environment.  #9943 *Chad Woolley*

*   FastCGI handler ignores unsupported signals like USR2 on Windows.  *Grzegorz Derebecki*

*   Only load ActionMailer::TestCase if ActionMailer is loaded.  Closes #10137 *defunkt*

*   Fixed that db:reset would use migrations instead of loading db/schema.rb *David Heinemeier Hansson*

*   Ensure the plugin loader only loads plugins once.  Closes #10102 *haruki_zaemon*

*   Refactor Plugin Loader.  Add plugin lib paths early, and add lots of tests.  Closes #9795 *James Adam*

*   Added --skip-timestamps to generators that produce models #10036 *Tim Pope*

*   Update Prototype to 1.6.0 and script.aculo.us to 1.8.0.  *sam, madrobby*

*   Added db:rollback to rollback the schema one version (or multiple as specified by STEP) *Jeffrey Allan Hardy*

*   Fix typo in test_helper. Closes #9925 *viktor tron*

*   Request profiler.  *Jeremy Kemper*

*   config/boot.rb correctly detects RAILS_GEM_VERSION.  #9834 *alexch, thewoolleyman*

*   Fixed incorrect migration number if script/generate executed outside of Rails root #7080 *Jeremy McAnally*

*   Update Prototype to 1.6.0_rc1 and script.aculo.us to 1.8.0 preview 0.  *sam, madrobby*

*   Generated fixtures use the actual primary key instead of id.  #4343 *Frederick Ros, Tarmo Tänav*

*   Extend the console +helper+ method to allow you to include custom helpers.  e.g:
    >> helper :posts
    >> helper.some_method_from_posts_helper(Post.find(1))

*   db:create works with remote databases whereas db:create:all only creates
    databases on localhost.  #9753 *Trevor Wennblom*

*   Removed calls to fixtures in generated tests as fixtures :all is now present by default in test_helper.rb *David Heinemeier Hansson*

*   Add --prefix option to script/server when using mongrel. *dacat*


## 2.0.0 Preview Release (September 29th, 2007) Includes duplicates of changes from 1.1.4 - 1.2.3 ##

*   Fixed that installing plugins from SVN repositories that use trunk/ will work #8188 *evan*

*   Moved the SourceAnnotationExtractor to a separate file in case libraries try to load the rails rake tasks twice. *Rick Olson*

*   Moved Dispatcher to ActionController::Dispatcher.  *Jeremy Kemper*

*   Changed the default logger from Ruby's own Logger with the clean_logger extensions to ActiveSupport::BufferedLogger for performance reasons [David Heinemeier Hansson]. (You can change it back with config.logger = Logger.new("/path/to/log", level).)

*   Added a default 422.html page to be rendered when ActiveRecord::RecordInvalid, ActiveRecord::RecordNotSaved, or ActionController::InvalidAuthenticityToken is raised *David Heinemeier Hansson*

*   Added --skip-fixture option to script/generate model #6862 *sandofsky*

*   Print Rails version when starting console #7440 *eyematz*

*   Fixed the placement of fixture files for nested models when generating through script/generate model #7547 *jkit*

*   Added TEMPLATE option to rake doc:app to set a custom output template #7737 *Jakob Skjerning*

*   Added VERBOSE option to rake db:migrate to turn off output #8204 *John Barnette*

*   Fixed that rake doc:app should use UTF-8 #8906 *farzy*

*   Fixes rake annotations to search erb and builder files as well #9150 *m.langenberg*

*   Removed web_service generator *Michael Koziarski*

*   Added the :all option to config.plugins that'll include the rest of the plugins not already explicitly named #9613 [Frederick Cheung]. Example:

        # Loads :classic_pagination before all the other plugins
        config.plugins = [ :classic_pagination, :all ]

*   Added symbols as a legal way of specifying plugins in config.plugins #9629 *tom*

*   Removed deprecated task names, like clear_logs, in favor of the new namespaced style *David Heinemeier Hansson*

*   Support multiple config.after_initialize blocks so plugins and apps can more easily cooperate.  #9582 *Zach Dennis*

*   Added db:drop:all to drop all databases declared in config/database.yml *David Heinemeier Hansson*

*   Use attribute pairs instead of the migration name to create add and remove column migrations.  Closes #9166 *Pratik Naik*

    For example:

    ruby script/generation migration AddSomeStuffToCustomers first_name:string last_name:string

    or

    ruby script/generation migration RemoveSomeStuffFromCustomers first_name:string last_name:string

*   Add ActiveResource to Rails::Info.  Closes #8741 *Chris Kampmeier*

*   use Gem.find_name instead of search when freezing gems.  Prevent false positives for other gems with rails in the name. Closes #8729 *wselman*

*   Automatically generate add/remove column commands in specially named migrations like AddLocationToEvent.  Closes #9006 *Ryan Davis*

*   Default to plural table name in Rails Generator if ActiveRecord is not present.  Closes #8963 *evan*

*   Added rake routes for listing all the defined routes in the system.  #8795 *Josh Peek*

*   db:create creates the database for the current environment if it's on localhost. db:create:all creates local databases for all environments.  #8783 *matt*

*   Generators: look for generators in all gems, not just those suffixed with _generator, in the gem's generators or rails_generators directory. Allow use of the rails_generators directory instead of the standard generators directory in plugins also.  #8730 *Dr Nic, topfunky*

*   MySQL, PostgreSQL: database.yml defaults to utf-8.  #8701 *matt*

*   Added db:version to get the current schema number *via Err The Blog*

*   Added --skip-migration option to scaffold and resource generators #8656 *Michael Glaesemann*

*   Fix that FCGIs would leave log files open when asked to shut down by USR2.  #3028 *Sebastian Kanthak, Josh Peek*

*   Fixed that dispatcher preparation callbacks only run once in production mode.  Mock Routes.reload so that dispatcher preparation callback tests run. *Rick Olson*

*   Fix syntax error in dispatcher than wrecked failsafe responses.  #8625 *mtitorenko*

*   Scaffolded validation errors set the appropriate HTTP status for XML responses.  #6946, #8622 *Manfred Stienstra, mmmultiworks*

*   Sexy migrations for the session_migration generator.  #8561 *Vladislav*

*   Console reload! runs to_prepare callbacks also.  #8393 *f.svehla*

*   Generated migrations include timestamps by default.  #8501 *Shane Vitarana*

*   Drop Action Web Service from rails:freeze:edge.  *Jeremy Kemper*

*   Add db:create, drop, reset, charset, and collation tasks.  #8448 *matt*

*   Scaffold generator depends on model generator instead of duplicating it.  #7222 *bscofield*

*   Scaffold generator tests.  #8443 *pelle*

*   Generated scaffold functional tests use assert_difference.  #8421 *Norbert Crombach*

*   Update to Prototype 1.5.1.  *Sam Stephenson*

*   Update to script.aculo.us 1.7.1_beta3.  *Thomas Fuchs*

*   Generators use *.html.erb view template naming.  #8278 *Tim Pope*

*   Updated resource_scaffold and model generators to use short-hand style migrations *David Heinemeier Hansson*

*   Updated initializer to only load #{RAILS_ENV}.rb once. Added deprecation warning for config.breakpoint_server. *Nicholas Seckar*

*   Removed breakpointer and Binding.of_caller in favor of relying on ruby-debug by Kent Sibilev since the breakpointer has been broken since Ruby 1.8.4 and will not be coming back *David Heinemeier Hansson*

    To use the new debugger, start your server with script/server --debugger and insert a call to  'debugger'
    (instead of 'breakpoint') where you want to jump into the debugger.

    BACKWARDS INCOMPATIBILITY NOTE: You must remove the default line 12 from config/environments/development.rb:

        config.breakpoint_server = true

    This configuration option is no longer available. Rails will fail to start in development mode as long as
    that's still present.

*   Resource scaffolding returns the created entity.to_xml.  *Jeremy Kemper*

*   Resource scaffolding responds to new.xml.  #8185 *Eric Mill*

*   Include Active Resource in rails:freeze:edge rake task.  *Thomas Fuchs*

*   Include Active Resource instead of Action Web Service [David Heinemeier Hansson] You can add AWS back with this in config/environment.rb:

        config.load_paths += %W( #{RAILS_ROOT}/vendor/rails/actionwebservice/lib )

    ...or just gem 'actionwebservice'

*   Give generate scaffold a more descriptive database message.  Closes #7316 *Jeremy McAnally*

*   Canonicalize RAILS_ROOT by using File.expand_path on Windows, which doesn't have to worry about symlinks, and Pathname#realpath elsewhere, which respects symlinks in relative paths but is incompatible with Windows.  #6755 *Jeremy Kemper, trevor*

*   Deprecation: remove components from controller paths.  *Jeremy Kemper*

*   Add environment variable RAILS_DEFAULT_DATABASE, which allows the builtin default of 'mysql' to be overridden. *Nicholas Seckar*

*   Windows: include MinGW in RUBY_PLATFORM check.  #2982 *okkez000@gmail.com, Kaspar Schiess*

*   Split out the basic plugin locator functionality into an abstract super class. Add a FileSystemLocator to do the job of checking the plugin_paths for plugins. Add plugin_locators configuration option which will iterate over the set of plugin locators and load each of the plugin loaders they return. Rename locater everywhere to locator. *Marcel Molina Jr.*

*   Split plugin location and loading out of the initializer and into a new Plugin namespace, which includes Plugin::Locater and Plugin::Loader. The loader class that is used can be customized using the config.plugin_loader option.  Those monkey patching the plugin loading subsystem take note, the internals changing here will likely break your modifications. The good news is that it should be substantially easier to hook into the plugin locating and loading process now.  *Marcel Molina Jr.*

*   Added assumption that all plugin creators desire to be sharing individuals and release their work under the MIT license *David Heinemeier Hansson*

*   Added source-annotations extractor tasks to rake [Jamis Buck]. This allows you to add FIXME, OPTIMIZE, and TODO comments to your source code that can then be extracted in concert with rake notes (shows all), rake notes:fixme, rake notes:optimize and rake notes:todo.

*   Added fixtures :all to test_helper.rb to assume that most people just want all their fixtures loaded all the time *David Heinemeier Hansson*

*   Added config/initializers where all ruby files within it are automatically loaded after the Rails configuration is done, so you don't have to litter the environment.rb file with a ton of mixed stuff *David Heinemeier Hansson*

*   For new apps, generate a random secret for the cookie-based session store.  *Jeremy Kemper*

*   Stop swallowing errors during rake test *Michael Koziarski*

*   Update Rails Initializer to use ActionController::Base#view_paths *Rick Olson*

*   Fix gem deprecation warnings, which also means depending on RubyGems 0.9.0+ *Chad Fowler*

*   Plugins may be symlinked in vendor/plugins.  #4245 *brandon, progrium@gmail.com*

*   Resource generator depends on the model generator rather than duplicating it.  #7269 *bscofield*

*   Add/Update usage documentation for script/destroy, resource generator and scaffold_resource generator.  Closes #7092, #7271, #7267.  *bscofield*

*   Update to script.aculo.us 1.7.0.  *Thomas Fuchs*

*   Update to Prototype 1.5.0. *Sam Stephenson*

*   Generator: use destination path for diff tempfiles.  #7015 *alfeld*

*   Fixed that webrick would strip leading newlines and hang connection #4156 *psross*

*   Ensure plugins are in the Dependencies.load_once_paths collection by default.  *Rick Olson*
    If you really want your plugins to reload, add this to the very top of init.rb:

        Dependencies.load_once_paths.delete(lib_path)

*   Allow config.to_prepare to work, make the dispatcher safe to 're require'. *Michael Koziarski, Nicholas Seckar*

*   Fix scaffold_resource generator so it respects the --pretend argument when creating the routes file.  Closes #6852 *fearoffish*

*   Fix Webrick Daemon dispatching bug regarding a bad current working directory.  Closes #4899 *Rick Olson*

*   Make config.plugins affect the load path and the dependencies system.  Allows you to control plugin loading order, and keep disabled plugins off the load path. *James Adam*

*   Don't generate a components directory in new Rails apps.  *Jeremy Kemper*

*   Fixed script/process/spawner to work properly with Mongrel including in -r (daemonize mode) *David Heinemeier Hansson*

*   Added one-letter aliases for the three default environments to script/console, so script/console p will load the production environment (t for test, d for development) *David Heinemeier Hansson*

*   Fixed that script/server running against Mongrel should tail the proper log regardless of the environment *David Heinemeier Hansson*

*   Update initializer to load Rails::VERSION as soon as possible. Closes #6698. *Nicholas Seckar*

*   Added ActiveRecord::Base.clear_active_connections! in development mode so the database connection is not carried over from request to request. Some databases won't reread the schema if that doesn't happen (I'm looking at you SQLite), so you have to restart the server after each migration (= no fun) *David Heinemeier Hansson*

*   Made RAILS_GEM_VERSION work for beta gems too, so specifying 1.1.6 will give you 1.1.6.4520 if available *David Heinemeier Hansson*

*   Update to Prototype and script.aculo.us [5579]. *Thomas Fuchs*

*   Made script/server work with -e and -d when using Mongrel *David Heinemeier Hansson*

*   Update to Prototype 1.5.0_rc2 [5550] which makes it work in Opera again *Thomas Fuchs*

*   Make sure that exceptions which are thrown outside of the user code try their best to be handeled in ApplicationController#rescue_action *Tobias Lütke*

*   Rails::VERSION::STRING should always be available without having to require 'rails/version'.  #6244 *fearoffish*

*   Update to Prototype 1.5.0_rc2. *Sam Stephenson*

*   Add grep-based fallback to reaper, to work in pidless setups *Jamis Buck*

*   Only wrap request processing with our USR1 signal handler so FastCGI can trap it and raise an exception while waiting for connections. Idle processes exit immediately rather than waiting for another request; active processes gracefully exit when the request is finished.  *Jeremy Kemper*

*   Alter prior change to use require_dependency instead of require_or_load. Causes ApplicationController to be reloaded again. Closes #6587. *Nicholas Seckar*

*   Rake: use absolute paths to load lib and vendor tasks so they may be run outside of RAILS_ROOT.  #6584 *jchris*

*   Remove temporary crutch to help ApplicationController be unloaded. Closes #6496. *Nicholas Seckar*

*   scaffold_resource generator uses _path named routes and head instead of render :nothing => true.  #6545 *Josh Susser*

*   Generator can show diff on file collision to help you decide whether to skip or overwrite.  #6364 *jeffw, Jeremy Kemper*

*   Generated directories are recursively svn added, like mkdir -p.  #6416 *NeilW*

*   resource and scaffold_resource generators add a restful route to config/routes.rb  *Jeremy Kemper*

*   Revert environment changes for autoload_paths. *Michael Koziarski*

*   Update to latest Prototype, which doesn't serialize disabled form elements, adds clone() to arrays, empty/non-string Element.update() and adds a fixes excessive error reporting in WebKit beta versions *Thomas Fuchs*

*   Clean up the output of rake stats,  de-emphasise components and apis, and remove the indents for tests *Michael Koziarski*

*   Added option to script/process/spawner of specifying the binding address #5133 *Dee Zsombor*

*   Update environment.rb comments to include config.autoload_paths. Closes #6478 *caio*

*   Update scaffold to use new form_tag block functionality.  Closes #6480. *Bob Silva*

*   Plugin generator: check for class collisions.  #4833 *vinbarnes@gmail.com*

*   Mailer generator: handle mailers in modules, set mime_version in unit test.  *Jeremy Kemper*

*   Set $KCODE to 'u' by default to enable the multibyte safe String#chars proxy. *Michael Koziarski*

*   Added config.plugins to control which plugins are loaded #6269 [Stefan Kaes]. By default, everything in vendor/plugins will be loaded, but if you specify config.plugins, only those will be loaded. Example:

        config.plugins = %w[ routing_navigator simply_helpful ]

*   Clean up html on included error pages. *Tim Lucas*

*   Fixed default 404.html and 500.htmls to remove extreme ugliness and include human language *David Heinemeier Hansson*

*   Update to latest Prototype and script.aculo.us trunk versions *Thomas Fuchs*

*   PostgreSQL: db:test:purge closes open database connections first.  #6236 *alex*

*   Fixed test:uncommitted on Windows (backslash issue) #4999 *paul@paulbutcher.com*

*   Fixed migration creation to work with namespaced models, so script/generate model Gallery::Image will use create_table :gallery_images #6327 *Bob Silva*

*   Fixed rename_table on SQLite tables with indexes defined #5942 *brandon@opensoul.org*

*   Added default timeout setting of 5 seconds to SQLite3 database.yml configurations *David Heinemeier Hansson*

*   Added generated attribute options to script/generate model, like the one found in scaffold_resource and resource [David Heinemeier Hansson]. Examples:

        ./script/generate model post title:string created_on:date body:text published:boolean

*   Added script/generate resource which works just like scaffold_resource, but creates empty placeholders instead of predefined *David Heinemeier Hansson*

*   script/runner can run files, pass on arguments, and be used as a shebang.  #6286 *Tuxie, dlpond*
        #!/usr/bin/env /path/to/my/app/script/runner
        # Example: just start using your models as if you are in script/console
        Product.find(:all).each { |product| product.check_inventory }

*   Look for rake tasks in plugin subdirs.  #6259 *obrie*

*   Added map.connect ':controller/:action/:id.:format' as a default route to config/routes.rb *David Heinemeier Hansson*

*   Updated prototype.js to 1.5.0_rc1 with latest fixes. *Rick Olson*

    - XPATH support
    - Make Form.getElements() return elements in the correct order
    - fix broken Form.serialize return

*   session_migration generator adds an index on updated_at.  #6207 *grg*

*   script/server creates the tmp/pids directory.  #6204 *jonathan*

*   Fix script/console --sandbox for internal transactions changes.  #5738 *Chris McGrath, charles.gerungan@gmail.com*

*   Remove the uncanny default of adding all app/models/*/ directories to the load path. This change will break application which expect the current behavior. As
    documented in initializer.rb, the workaround is:

    config.autoload_paths += Dir*RAILS_ROOT + '/app/models/*/'*

    References #6031. *Nicholas Seckar*

*   Update to script.aculo.us 1.6.3 *Thomas Fuchs*

*   Update to Prototype 1.5.0_rc1 *sam*

*   Formally Deprecate the old rake tasks. *Michael Koziarski*

*   Thoroughly test the FCGI dispatcher.  #5970 *Kevin Clark*

*   Remove Dir.chdir in the Webrick DispatchServlet#initialize method.  Fix bad path errors when trying to load config/routes.rb.  *Rick Olson*

*   Tighten rescue clauses.  #5985 *james@grayproductions.net*

*   Cleaning up tests. *Kevin Clark, Jeremy Kemper*

*   Add Dependencies.load_once_paths. *Nicholas Seckar*

*   Updated to script.aculo.us 1.6.2 *Thomas Fuchs*

*   Assign Routing.controller_paths; fix script/about and rails info controller. *Nicholas Seckar*

*   Don't warn dispatcher of Reloadable deprecations. *Nicholas Seckar*

*   Rearrange application resetting and preparation, fix bug with leaking subclasses hash in ActiveRecord::Base *Rick Olson*

    ActiveRecord::Base.reset_subclasses is called before Dependencies are cleared and classes removed.
    ActiveRecord::Base.instantiate_observers is called during a Dispatcher preparation callback.

*   Add missing mock directories from the autoload_paths configuration.  *Rick Olson*

*   Nested controller scaffolding also nests the generated layout. *iain d broadfoot*

*   Add "require 'dispatcher'" to webrick server in the continuing quest to squash webrick weirdness. *Nicholas Seckar*

*   Add autoload_paths support to Initializer. *Nicholas Seckar*

*   Fix Dispatcher.reset_application! so that AR subclasses are removed and Observers re-initialized *after* Reloadable classes are removed. Closes #5743.  *Rick Olson*

*   Clarify usage of script/plugin source. Closes #5344. *James Adam*

*   Add Dispatcher.to_prepare and config.to_prepare to provide a pre-request hook. *Nicholas Seckar*

*   Tweak the Rails load order so observers are loaded after plugins, and reloaded in development mode. Closed #5279.  *Rick Olson*

*   Added that you can change the web server port in config/lighttpd.conf from script/server --port/-p #5465 *mats@imediatec.co.uk*

*   script/performance/profiler compatibility with the new ruby-prof, including an option to choose the results printer.  #5679 *Shugo Maeda*

*   Fixed the failsafe response so it uses either the current recognized controller or ApplicationController.  *Rick Olson*

*   Make sure script/reaper only reaps dispatcher pids by default, and not the spawner's pid. *Jamis Buck*

*   Fix script/plugin about so it uses about.yml and not meta.yml.  *James Adam*

*   Dispatcher processes rescued actions with the same controller that processed the request. #4625 *sd@notso.net*

*   rails -d frontbase to create a new project with a frontbase database.yml. #4945 *mlaster@metavillage.com*

*   Ensure the logger is initialized. #5629 *mike@clarkware.com*

*   Added Mongrel-spawning capabilities to script/process/spawner. Mongrel will be the default choice if installed, otherwise FCGI is tried [David Heinemeier Hansson]. Examples:

        spawner               # starts instances on 8000, 8001, and 8002 using Mongrel if available
        spawner fcgi          # starts instances on 8000, 8001, and 8002 using FCGI
        spawner mongrel -i 5  # starts instances on 8000, 8001, 8002, 8003, and 8004 using Mongrel
        spawner -p 9100 -i 10 # starts 10 instances counting from 9100 to 9109 using Mongrel if available
        spawner -p 9100 -r 5  # starts 3 instances counting from 9100 to 9102 and attempts start them every 5 seconds

    Also note that script/process/reaper is Mongrel capable. So the combination of spawner and reaper is a built-in alternative to something like mongrel_cluster.

*   Update scaffolding functional tests to use :id => people(:first) instead of :id => 1. #5612 *evan@protest.net*

*   db:test:clone should remove existing tables before reloading the schema. #5607 *sveit@tradeharbor.com*

*   Fixed migration generation for class names like ACLController #5197 *brad@madriska.com*

*   Added show_source_list and show_call_stack to breakpoints to make it easier to get context #5476 [takiuchi@drecom.co.jp]. Examples:

        irb(#<TopController:0x40822a68>):002:0> show_source_list
        0001  class TopController < ApplicationController
        0002    def show
        0003->    breakpoint
        0004    end
        0005
        0006    def index
        0007    end
        0008
        => "/path/to/rails/root/app/controllers/top_controller.rb"

        irb(#<TopController:0x40822a68>):004:0> show_call_stack 3
        vendor/rails/railties/lib/breakpoint.rb:536:in `breakpoint'
        vendor/rails/railties/lib/breakpoint.rb:536:in `breakpoint'
        app/controllers/top_controller.rb:3:in `show'
        => "/path/to/rails/root/app/controllers/top_controller.rb:3"

*   Generate scaffold layout in subdirectory appropriate to its module nesting. #5511 *nils@alumni.rice.edu*

*   Mongrel: script/server tails the rails log like it does with lighttpd. Prefer mongrel over lighttpd. #5541 *mike@clarkware.com*

*   Don't assume Active Record is available. #5497 *bob@sporkmonger.com*

*   Mongrel: script/server works on Win32. #5499 *jeremydurham@gmail.com*

*   Remove opts.on { |options[:option_name] } style hash assignment. Closes #4440. *Nick Sieger*

*   Mongrel support for script/server.  #5475 *jeremydurham@gmail.com*

*   Fix script/plugin so it doesn't barf on invalid URLs *Rick Olson*

*   Fix plugin install bug at dir with space. (closes #5359) *Yoshimasa NIWA*

*   Fix bug with 'script/plugin install' so it reports unknown plugin names correctly.  *Rick Olson*

*   Added uninstall.rb hook to plugin handling, such that plugins have a way of removing assets and other artifacts on removal #5003 *takiuchi@drecom.co.jp*

*   Create temporary dirs relative to RAILS_ROOT when running script/server #5014 *elliot@townx.org*

*   Minor tweak to dispatcher to use recognize instead of recognize!, as per the new routes. *Jamis Buck*

*   Make "script/plugin install" work with svn+ssh URLs. *Sam Stephenson*

*   Added lib/ to the directories that will get application docs generated *David Heinemeier Hansson*

*   Add observer generator. Closes #5167. *François Beausoleil*

*   Session migration generator obeys pluralize_table_names. #5145 *James Adam*

*   rake test:recent understands subdirectories. #2925 *jerrett@bravenet.com*

*   The app generator detects the XAMPP package's MySQL socket location. #3832 *elliot@townx.org*

*   The app generator sets a session key in application.rb so apps running on the same host may distinguish their cookies. #2967 *rcoder, rails-bug@owl.me.uk*

*   Distinguish the spawners for different processes *David Heinemeier Hansson*

*   Added -n/--process to script/process/spawner name the process pid (default is dispatch) *David Heinemeier Hansson*

*   Namespaced OrderedHash so the Rails implementation does not clash with any others. (fixes #4911) *Julian Tarkhanov*

*   Replace Ruby's deprecated append_features in favor of included. *Marcel Molina Jr.*

*   Added script/process/inspector to do simple process status information on Rails dispatchers keeping pid files in tmp/pids *David Heinemeier Hansson*

*   Added pid file usage to script/process/spawner and script/process/reaper along with a directive in default config/lighttpd.conf file to record the pid. They will all save their pid file in tmp/pids *David Heinemeier Hansson*


## 1.2.3 (March 12th, 2007) ##

*   Ruby 1.8.6 compatibility

*   Windows: include MinGW in RUBY_PLATFORM check.  #2982 *okkez000@gmail.com, Kaspar Schiess*

*   Stop swallowing errors during rake test *Michael Koziarski*


## 1.2.2 (February 5th, 2007) ##

*   Fix gem deprecation warnings, which also means depending on RubyGems 0.9.0+ *Chad Fowler*

*   Require the dispatcher for Rails::Configuration#to_prepare.  *Rick Olson*


## 1.2.1 (January 16th, 2007) ##

*   Updated to Active Record 1.15.1, Action Pack 1.13.1, Action Mailer 1.3.1, Action Web Service 1.2.1


## 1.2.0 (January 16th, 2007) ##

*   Update to Prototype 1.5.0. *Sam Stephenson*

*   Generator: use destination path for diff tempfiles.  #7015 *alfeld*

*   Fixed that webrick would strip leading newlines and hang connection #4156 *psross*

*   Ensure plugins are in the Dependencies.load_once_paths collection by default.  *Rick Olson*
    If you really want your plugins to reload, add this to the very top of init.rb:

        Dependencies.load_once_paths.delete(lib_path)

*   Fix scaffold_resource generator so it respects the --pretend argument when creating the routes file.  Closes #6852 *fearoffish*

*   Fix Webrick Daemon dispatching bug regarding a bad current working directory.  Closes #4899 *Rick Olson*

*   Make config.plugins affect the load path and the dependencies system.  Allows you to control plugin loading order, and keep disabled plugins off the load path. *James Adam*

*   Don't generate a components directory in new Rails apps.  *Jeremy Kemper*

*   Fixed script/process/spawner to work properly with Mongrel including in -r (daemonize mode) *David Heinemeier Hansson*

*   Deprecated the name route "root" as it'll be used as a shortcut for map.connect '' in Rails 2.0 *David Heinemeier Hansson*

*   Fixed that script/server running against Mongrel should tail the proper log regardless of the environment *David Heinemeier Hansson*

*   Update initializer to load Rails::VERSION as soon as possible. Closes #6698. *Nicholas Seckar*

*   Added ActiveRecord::Base.clear_active_connections! in development mode so the database connection is not carried over from request to request. Some databases won't reread the schema if that doesn't happen (I'm looking at you SQLite), so you have to restart the server after each migration (= no fun) *David Heinemeier Hansson*

*   Made RAILS_GEM_VERSION work for beta gems too, so specifying 1.1.6 will give you 1.1.6.4520 if available *David Heinemeier Hansson*

*   Update to Prototype and script.aculo.us [5579]. *Sam Stephenson, Thomas Fuchs*

*   Made script/server work with -e and -d when using Mongrel *David Heinemeier Hansson*

*   Make sure that exceptions which are thrown outside of the user code try their best to be handeled in ApplicationController#rescue_action *Tobias Lütke*

*   Rails::VERSION::STRING should always be available without having to require 'rails/version'.  #6244 *fearoffish*

*   Add grep-based fallback to reaper, to work in pidless setups *Jamis Buck*

*   Only wrap request processing with our USR1 signal handler so FastCGI can trap it and raise an exception while waiting for connections. Idle processes exit immediately rather than waiting for another request; active processes gracefully exit when the request is finished.  *Jeremy Kemper*

*   Alter prior change to use require_dependency instead of require_or_load. Causes ApplicationController to be reloaded again. Closes #6587. *Nicholas Seckar*

*   Rake: use absolute paths to load lib and vendor tasks so they may be run outside of RAILS_ROOT.  #6584 *jchris*

*   scaffold_resource generator uses _path named routes and head instead of render :nothing => true.  #6545 *Josh Susser*

*   Generator can show diff on file collision to help you decide whether to skip or overwrite.  #6364 *jeffw, Jeremy Kemper*

*   Generated directories are recursively svn added, like mkdir -p.  #6416 *NeilW*

*   resource and scaffold_resource generators add a restful route to config/routes.rb  *Jeremy Kemper*

*   Revert environment changes for autoload_paths. *Michael Koziarski*

*   Clean up the output of rake stats,  de-emphasise components and apis, and remove the indents for tests *Michael Koziarski*

*   Added option to script/process/spawner of specifying the binding address #5133 *Dee Zsombor*

*   Update environment.rb comments to include config.autoload_paths. Closes #6478 *caio*

*   Update scaffold to use new form_tag block functionality.  Closes #6480. *Bob Silva*

*   Plugin generator: check for class collisions.  #4833 *vinbarnes@gmail.com*

*   Mailer generator: handle mailers in modules, set mime_version in unit test.  *Jeremy Kemper*

*   Set $KCODE to 'u' by default to enable the multibyte safe String#chars proxy. *Michael Koziarski*

*   Added config.plugins to control which plugins are loaded #6269 [Stefan Kaes]. By default, everything in vendor/plugins will be loaded, but if you specify config.plugins, only those will be loaded. Example:

        config.plugins = %w[ routing_navigator simply_helpful ]

*   Clean up html on included error pages. *Tim Lucas*

*   Fixed default 404.html and 500.htmls to remove extreme ugliness and include human language *David Heinemeier Hansson*

*   Update to latest Prototype and script.aculo.us trunk versions *Thomas Fuchs*

*   PostgreSQL: db:test:purge closes open database connections first.  #6236 *alex*

*   Fixed test:uncommitted on Windows (backslash issue) #4999 *paul@paulbutcher.com*

*   Fixed migration creation to work with namespaced models, so script/generate model Gallery::Image will use create_table :gallery_images #6327 *Bob Silva*

*   Fixed rename_table on SQLite tables with indexes defined #5942 *brandon@opensoul.org*

*   Added default timeout setting of 5 seconds to SQLite3 database.yml configurations *David Heinemeier Hansson*

*   Added generated attribute options to script/generate model, like the one found in scaffold_resource and resource [David Heinemeier Hansson]. Examples:

        ./script/generate model post title:string created_on:date body:text published:boolean

*   Added script/generate resource which works just like scaffold_resource, but creates empty placeholders instead of predefined *David Heinemeier Hansson*

*   script/runner can run files, pass on arguments, and be used as a shebang.  #6286 *Tuxie, dlpond*
        #!/usr/bin/env /path/to/my/app/script/runner
        # Example: just start using your models as if you are in script/console
        Product.find(:all).each { |product| product.check_inventory }

*   Look for rake tasks in plugin subdirs.  #6259 *obrie*

*   Added map.connect ':controller/:action/:id.:format' as a default route to config/routes.rb *David Heinemeier Hansson*

*   session_migration generator adds an index on updated_at.  #6207 *grg*

*   script/server creates the tmp/pids directory.  #6204 *jonathan*

*   Fix script/console --sandbox for internal transactions changes.  #5738 *Chris McGrath, charles.gerungan@gmail.com*

*   Remove the uncanny default of adding all app/models/*/ directories to the load path. This change will break application which expect the current behavior. As
    documented in initializer.rb, the workaround is:

    config.autoload_paths += Dir*RAILS_ROOT + '/app/models/*/'*

    References #6031. *Nicholas Seckar*

*   Update to script.aculo.us 1.6.3 *Thomas Fuchs*

*   Formally Deprecate the old rake tasks. *Michael Koziarski*

*   Thoroughly test the FCGI dispatcher.  #5970 *Kevin Clark*

*   Remove Dir.chdir in the Webrick DispatchServlet#initialize method.  Fix bad path errors when trying to load config/routes.rb.  *Rick Olson*

*   Tighten rescue clauses.  #5985 *james@grayproductions.net*

*   Cleaning up tests. *Kevin Clark, Jeremy Kemper*

*   Add Dependencies.load_once_paths. *Nicholas Seckar*

*   Assign Routing.controller_paths; fix script/about and rails info controller. *Nicholas Seckar*

*   Don't warn dispatcher of Reloadable deprecations. *Nicholas Seckar*

*   Rearrange application resetting and preparation, fix bug with leaking subclasses hash in ActiveRecord::Base *Rick Olson*

    ActiveRecord::Base.reset_subclasses is called before Dependencies are cleared and classes removed.
    ActiveRecord::Base.instantiate_observers is called during a Dispatcher preparation callback.

*   Add missing mock directories from the autoload_paths configuration.  *Rick Olson*

*   Nested controller scaffolding also nests the generated layout. *iain d broadfoot*

*   Add "require 'dispatcher'" to webrick server in the continuing quest to squash webrick weirdness. *Nicholas Seckar*

*   Add autoload_paths support to Initializer. *Nicholas Seckar*

*   Fix Dispatcher.reset_application! so that AR subclasses are removed and Observers re-initialized *after* Reloadable classes are removed. Closes #5743.  *Rick Olson*

*   Clarify usage of script/plugin source. Closes #5344. *James Adam*

*   Add Dispatcher.to_prepare and config.to_prepare to provide a pre-request hook. *Nicholas Seckar*

*   Tweak the Rails load order so observers are loaded after plugins, and reloaded in development mode. Closed #5279.  *Rick Olson*

*   Added that you can change the web server port in config/lighttpd.conf from script/server --port/-p #5465 *mats@imediatec.co.uk*

*   script/performance/profiler compatibility with the new ruby-prof, including an option to choose the results printer.  #5679 *Shugo Maeda*

*   Fixed the failsafe response so it uses either the current recognized controller or ApplicationController.  *Rick Olson*

*   Make sure script/reaper only reaps dispatcher pids by default, and not the spawner's pid. *Jamis Buck*

*   Fix script/plugin about so it uses about.yml and not meta.yml.  *James Adam*

*   Dispatcher processes rescued actions with the same controller that processed the request. #4625 *sd@notso.net*

*   rails -d frontbase to create a new project with a frontbase database.yml. #4945 *mlaster@metavillage.com*

*   Ensure the logger is initialized. #5629 *mike@clarkware.com*

*   Added Mongrel-spawning capabilities to script/process/spawner. Mongrel will be the default choice if installed, otherwise FCGI is tried [David Heinemeier Hansson]. Examples:

        spawner               # starts instances on 8000, 8001, and 8002 using Mongrel if available
        spawner fcgi          # starts instances on 8000, 8001, and 8002 using FCGI
        spawner mongrel -i 5  # starts instances on 8000, 8001, 8002, 8003, and 8004 using Mongrel
        spawner -p 9100 -i 10 # starts 10 instances counting from 9100 to 9109 using Mongrel if available
        spawner -p 9100 -r 5  # starts 3 instances counting from 9100 to 9102 and attempts start them every 5 seconds

    Also note that script/process/reaper is Mongrel capable. So the combination of spawner and reaper is a built-in alternative to something like mongrel_cluster.

*   Update scaffolding functional tests to use :id => people(:first) instead of :id => 1. #5612 *evan@protest.net*

*   db:test:clone should remove existing tables before reloading the schema. #5607 *sveit@tradeharbor.com*

*   Fixed migration generation for class names like ACLController #5197 *brad@madriska.com*

*   Added show_source_list and show_call_stack to breakpoints to make it easier to get context #5476 [takiuchi@drecom.co.jp]. Examples:

        irb(#<TopController:0x40822a68>):002:0> show_source_list
        0001  class TopController < ApplicationController
        0002    def show
        0003->    breakpoint
        0004    end
        0005
        0006    def index
        0007    end
        0008
        => "/path/to/rails/root/app/controllers/top_controller.rb"

        irb(#<TopController:0x40822a68>):004:0> show_call_stack 3
        vendor/rails/railties/lib/breakpoint.rb:536:in `breakpoint'
        vendor/rails/railties/lib/breakpoint.rb:536:in `breakpoint'
        app/controllers/top_controller.rb:3:in `show'
        => "/path/to/rails/root/app/controllers/top_controller.rb:3"

*   Generate scaffold layout in subdirectory appropriate to its module nesting. #5511 *nils@alumni.rice.edu*

*   Mongrel: script/server tails the rails log like it does with lighttpd. Prefer mongrel over lighttpd. #5541 *mike@clarkware.com*

*   Don't assume Active Record is available. #5497 *bob@sporkmonger.com*

*   Mongrel: script/server works on Win32. #5499 *jeremydurham@gmail.com*

*   Remove opts.on { |options[:option_name] } style hash assignment. Closes #4440. *Nick Sieger*

*   Mongrel support for script/server.  #5475 *jeremydurham@gmail.com*

*   Fix script/plugin so it doesn't barf on invalid URLs *Rick Olson*

*   Fix plugin install bug at dir with space. (closes #5359) *Yoshimasa NIWA*

*   Fix bug with 'script/plugin install' so it reports unknown plugin names correctly.  *Rick Olson*

*   Added uninstall.rb hook to plugin handling, such that plugins have a way of removing assets and other artifacts on removal #5003 *takiuchi@drecom.co.jp*

*   Create temporary dirs relative to RAILS_ROOT when running script/server #5014 *elliot@townx.org*

*   Minor tweak to dispatcher to use recognize instead of recognize!, as per the new routes. *Jamis Buck*

*   Make "script/plugin install" work with svn+ssh URLs. *Sam Stephenson*

*   Added lib/ to the directories that will get application docs generated *David Heinemeier Hansson*

*   Add observer generator. Closes #5167. *François Beausoleil*

*   Session migration generator obeys pluralize_table_names. #5145 *James Adam*

*   rake test:recent understands subdirectories. #2925 *jerrett@bravenet.com*

*   The app generator detects the XAMPP package's MySQL socket location. #3832 *elliot@townx.org*

*   The app generator sets a session key in application.rb so apps running on the same host may distinguish their cookies. #2967 *rcoder, rails-bug@owl.me.uk*

*   Distinguish the spawners for different processes *David Heinemeier Hansson*

*   Added -n/--process to script/process/spawner name the process pid (default is dispatch) *David Heinemeier Hansson*

*   Namespaced OrderedHash so the Rails implementation does not clash with any others. (fixes #4911) *Julian Tarkhanov*

*   Replace Ruby's deprecated append_features in favor of included. *Marcel Molina Jr.*

*   Added script/process/inspector to do simple process status information on Rails dispatchers keeping pid files in tmp/pids *David Heinemeier Hansson*

*   Added pid file usage to script/process/spawner and script/process/reaper along with a directive in default config/lighttpd.conf file to record the pid. They will all save their pid file in tmp/pids *David Heinemeier Hansson*


## 1.1.6 (August 10th, 2006) ##

*   Additional security patch


## 1.1.5 (August 8th, 2006) ##

*   Mention in docs that config.frameworks doesn't work when getting Rails via Gems.  #4857 *Alisdair McDiarmid*

*   Change the scaffolding layout to use yield rather than @content_for_layout. *Marcel Molina Jr.*

*   Includes critical security patch


## 1.1.4 (June 29th, 2006) ##

*   Remove use of opts.on { |options[:name] } style hash assignment. References #4440. *headius@headius.com*

*   Updated to Action Pack 1.12.3, ActionWebService 1.1.4, ActionMailer 1.2.3


## 1.1.3 (June 27th, 2006) ##

*   Updated to Active Record 1.14.3, Action Pack 1.12.2, ActionWebService 1.1.3, ActionMailer 1.2.2


## 1.1.2 (April 9th, 2006) ##

*   Mention in docs that config.frameworks doesn't work when getting Rails via Gems. Closes #4857. *Alisdair McDiarmid*

*   Change the scaffolding layout to use yield rather than @content_for_layout. *Marcel Molina Jr.*

*   Added rake rails:update:configs to update config/boot.rb from the latest (also included in rake rails:update) *David Heinemeier Hansson*

*   Fixed that boot.rb would set RAILS_GEM_VERSION twice, not respect an uncommented RAILS_GEM_VERSION line, and not use require_gem *David Heinemeier Hansson*


## 1.1.1 (April 6th, 2006) ##

*   Enhances plugin#discover allowing it to discover svn:// like URIs (closes #4565) *ruben.nine@gmail.com*

*   Update to Prototype 1.5.0_rc0 *Sam Stephenson*

*   Fixed that the -r/--ruby path option of the rails command was not being respected #4549 *ryan.raaum@gmail.com*

*   Added that Dispatcher exceptions should not be shown to the user unless a default log has not been configured. Instead show public/500.html *David Heinemeier Hansson*

*   Fixed that rake clone_structure_to_test should quit on pgsql if the dump is unsuccesful #4585 *augustz@augustz.com*

*   Fixed that rails --version should have the return code of 0 (success) #4560 *blair@orcaware.com*

*   Install alias so Rails::InfoController is accessible at /rails_info. Closes #4546. *Nicholas Seckar*

*   Fixed that spawner should daemonize if running in repeat mode *David Heinemeier Hansson*

*   Added TAG option for rake rails:freeze:edge, so you can say rake rails:freeze:edge TAG=rel_1-1-0 to lock to the 1.1.0 release *David Heinemeier Hansson*

*   Applied Prototype $() performance patches (#4465, #4477) and updated script.aculo.us *Sam Stephenson, Thomas Fuchs*

*   Use --simple-prompt instead of --prompt-mode simple for console compatibility with Windows/Ruby 1.8.2 #4532 *starr@starrnhorne.com*

*   Make Rails::VERSION implicitly loadable #4491. *Nicholas Seckar*

*   Fixed rake rails:freeze:gems #4518 *benji@silverinsanity.com*

*   Added -f/--freeze option to rails command for freezing the application to the Rails version it was generated with *David Heinemeier Hansson*

*   Added gem binding of apps generated through the rails command to the gems of they were generated with *Nicholas Seckar*

*   Added expiration settings for JavaScript, CSS, HTML, and images to default lighttpd.conf *David Heinemeier Hansson*

*   Added gzip compression for JavaScript, CSS, and HTML to default lighttpd.conf *David Heinemeier Hansson*

*   Avoid passing escapeHTML non-string in Rails' info controller *Nicholas Seckar*


## 1.1.0 (March 27th, 2006) ##

*   Allow db:fixtures:load to load a subset of the applications fixtures. *Chad Fowler*

    ex.

     rake db:fixtures:load FIXTURES=customers,plans

*   Update to Prototype 1.5.0_pre1 *Sam Stephenson*

*   Update to script.aculo.us 1.6 *Thomas Fuchs*

*   Add an integration_test generator *Jamis Buck*

*   Make all ActionView helpers available in the console from the helper method for debugging purposes. n.b.: Only an 80% solution. Some stuff won't work, most will. *Marcel Molina Jr.*

    ex.

        >> puts helper.options_for_select([%w(a 1), %w(b 2), %w(c 3)])
        <option value="1">a</option>
        <option value="2">b</option>
        <option value="3">c</option>
        => nil

*   Replaced old session rake tasks with db:sessions:create to generate a migration, and db:sessions:clear to remove sessions. *Rick Olson*

*   Reject Ruby 1.8.3 when loading Rails; extract version checking code. *Chad Fowler*

*   Remove explicit loading of RailsInfo and RailsInfoController. *Nicholas Seckar*

*   Move RailsInfo and RailsInfoController to Rails::Info and Rails::InfoController. *Nicholas Seckar*

*   Extend load path with Railties' builtin directory to make adding support code easy. *Nicholas Seckar*

*   Fix the rails_info controller by explicitly loading it, and marking it as not reloadable. *Nicholas Seckar*

*   Fixed rails:freeze:gems for Windows #3274 *paul@paulbutcher.com*

*   Added 'port open?' check to the spawner when running in repeat mode so we don't needlessly boot the dispatcher if the port is already in use anyway #4089 *guy.naor@famundo.com*

*   Add verification to generated scaffolds,  don't allow get for unsafe actions *Michael Koziarski*

*   Don't replace application.js in public/javascripts if it already exists *Cody Fauser*

*   Change test:uncommitted to delay execution of `svn status` by using internal Rake API's. *Nicholas Seckar*

*   Use require_library_or_gem to load rake in commands/server.rb.  Closes #4205.  *rob.rasmussen@gmail.com*

*   Use the Rake API instead of shelling out to create the tmp directory in commands/server.rb. *Chad Fowler*

*   Added a backtrace to the evil WSOD (White Screen of Death).  Closes #4073. TODO: Clearer exceptions *Rick Olson*

*   Added tracking of database and framework versions in script/about #4088 *charles.gerungan@gmail.com/Rick Olson*

*   Added public/javascripts/application.js as a sample since it'll automatically be included in javascript_include_tag :defaults *David Heinemeier Hansson*

*   Added socket cleanup for lighttpd, both before and after *David Heinemeier Hansson*

*   Added automatic creation of tmp/ when running script/server *David Heinemeier Hansson*

*   Added silence_stream that'll work on both STDERR or STDOUT or any other stream and deprecated silence_stderr in the process *David Heinemeier Hansson*

*   Added reload! method to script/console to reload all models and others that include Reloadable without quitting the console #4056 *esad@esse.at*

*   Added that rake rails:freeze:edge will now just export all the contents of the frameworks instead of just lib, so stuff like rails:update:scripts, rails:update:javascripts, and script/server on lighttpd still just works #4047 *David Heinemeier Hansson*

*   Added fix for upload problems with lighttpd from Safari/IE to config/lighttpd.conf #3999 *Thijs van der Vossen*

*   Added test:uncommitted to test changes since last checkin to Subversion #4035 *technomancy@gmail.com*

*   Help script/about print the correct svn revision when in a non-English locale.  #4026 *babie7a0@ybb.ne.jp*

*   Add 'app' accessor to script/console as an instance of Integration::Session *Jamis Buck*

*   Generator::Base#usage takes an optional message argument which defaults to Generator::Base#usage_message. *Jeremy Kemper*

*   Remove the extraneous AR::Base.threaded_connections setting from the webrick server. *Jeremy Kemper*

*   Add integration test support to app generation and testing *Jamis Buck*

*   Added namespaces to all tasks, so for example load_fixtures is now db:fixtures:load. All the old task names are still valid, they just point to the new namespaced names. "rake -T" will only show the namespaced ones, though *David Heinemeier Hansson*

*   CHANGED DEFAULT: ActiveRecord::Base.schema_format is now :ruby by default instead of :sql. This means that we'll assume you want to live in the world of db/schema.rb where the grass is green and the girls are pretty. If your schema contains un-dumpable elements, such as constraints or database-specific column types, you just got an invitation to either 1) patch the dumper to include foreign key support, 2) stop being db specific, or 3) just change the default in config/environment.rb to config.active_record.schema_format = :sql -- we even include an example for that on new Rails skeletons now. Brought to you by the federation of opinionated framework builders! *David Heinemeier Hansson*

*   Added -r/--repeat option to script/process/spawner that offers the same loop protection as the spinner did. This deprecates the script/process/spinner, so it's no longer included in the default Rails skeleton, but still available for backwards compatibility #3461 *ror@andreas-s.net*

*   Added collision option to template generation in generators #3329 [anna@wota.jp]. Examples:

        m.template "stuff.config" , "config/stuff.config" , :collision => :skip
        m.template "auto-stamping", "config/generator.log", :collision => :force

*   Added more information to script/plugin's doings to ease debugging #3755 *Rick Olson*

*   Changed the default configuration for lighttpd to use tmp/sockets instead of log/ for the FastCGI sockets *David Heinemeier Hansson*

*   Added a default configuration of the FileStore for fragment caching if tmp/cache is available, which makes action/fragment caching ready to use out of the box with no additional configuration *David Heinemeier Hansson*

*   Changed the default session configuration to place sessions in tmp/sessions, if that directory is available, instead of /tmp (this essentially means a goodbye to 9/10 White Screen of Death errors and should have web hosting firms around the world cheering) *David Heinemeier Hansson*

*   Added tmp/sessions, tmp/cache, and tmp/sockets as default directories in the Rails skeleton *David Heinemeier Hansson*

*   Added that script/generate model will now automatically create a migration file for the model created. This can be turned off by calling the generator with --skip-migration *David Heinemeier Hansson*

*   Added -d/--database option to the rails command, so you can do "rails --database=sqlite2 myapp" to start a new application preconfigured to use SQLite2 as the database. Removed the configuration examples from SQLite and PostgreSQL from the default MySQL configuration *David Heinemeier Hansson*

*   Allow script/server -c /path/to/lighttpd.conf *Jeremy Kemper*

*   Remove hardcoded path to reaper script in script/server *Jeremy Kemper*

*   Update script.aculo.us to V1.5.3 *Thomas Fuchs*

*   Added SIGTRAP signal handler to RailsFCGIHandler that'll force the process into a breakpoint after the next request. This breakpoint can then be caught with script/breakpointer and give you access to the Ruby image inside that process. Useful for debugging memory leaks among other things *David Heinemeier Hansson*

*   Changed default lighttpd.conf to use CWD from lighttpd 1.4.10 that allows the same configuration to be used for both detach and not. Also ensured that auto-repeaping of FCGIs only happens when lighttpd is not detached. *David Heinemeier Hansson*

*   Added Configuration#after_initialize for registering a block which gets called after the framework is fully initialized.  Useful for things like per-environment configuration of plugins. *Michael Koziarski*

*   Added check for RAILS_FRAMEWORK_ROOT constant that allows the Rails framework to be found in a different place than vendor/rails. Should be set in boot.rb. *David Heinemeier Hansson*

*   Fixed that static requests could unlock the mutex guarding dynamic requests in the WEBrick servlet #3433 *tom@craz8.com*

*   Fixed documentation tasks to work with Rake 0.7.0 #3563 *kazuhiko@fdiary.net*

*   Update to Prototype 1.5.0_pre0 *Sam Stephenson*

*   Sort the list of plugins so we load in a consistent order *Rick Olson*

*   Show usage when script/plugin is called without arguments *tom@craz8.com*

*   Corrected problems with plugin loader where plugins set 'name' incorrectly #3297 *anna@wota.jp*

*   Make migration generator only report on exact duplicate names, not partial dupliate names. #3442 *jeremy@planetargon.com Marcel Molina Jr.*

*   Fix typo in mailer generator USAGE. #3458 *chriztian.steinmeier@gmail.com*

*   Ignore version mismatch between pg_dump and the database server. #3457 *Simon Stapleton*

*   Reap FCGI processes after lighttpd exits. *Sam Stephenson*

*   Honor ActiveRecord::Base.pluralize_table_names when creating and destroying session store table. #3204. *rails@bencurtis.com, Marcel Molina Jr.*

## 1.0.0 (December 13th, 2005) ##

*   Update instructions on how to find and install generators. #3172. *Chad Fowler*

*   Generator looks in vendor/generators also.  *Chad Fowler*

*   Generator copies files in binary mode.  #3156 *minimudboy@gmail.com*

*   Add builtin/ to the gemspec. Closes #3047. *Nicholas Seckar, Sam Stephenson*

*   Add install.rb file to plugin generation which is loaded, if it exists, when you install a plugin. *Marcel Molina Jr.*

*   Run initialize_logger in script/lighttpd to ensure the log file exists before tailing it. *Sam Stephenson*

*   Make load_fixtures include csv fixtures. #3053. *me@mdaines.com*

*   Fix freeze_gems so that the latest rails version is dumped by default. *Nicholas Seckar*

*   script/plugin: handle root paths and plugin names which contain spaces.  #2995 *justin@aspect.net*

*   Model generator: correct relative path to test_helper in unit test.  *Jeremy Kemper*

*   Make the db_schema_dump task honor the SCHEMA environment variable if present the way db_schema_import does. #2931. *Blair Zajac*

*   Have the lighttpd server script report the actual ip to which the server is bound. #2903. *Adam*

*   Add plugin library directories to the load path after the lib directory so that libraries in the lib directory get precedence. #2910. *James Adam*

*   Make help for the console command more explicit about how to specify the desired environment in which to run the console. #2911. *anonymous*

*   PostgreSQL: the purge_test_database Rake task shouldn't explicitly specify the template0 template when creating a fresh test database.  #2964 *Dreamer3*

*   Introducing the session_migration generator.  Creates an add_session_table migration.  Allows generator to specify migrations directory.  #2958, #2960 *Rick Olson*

*   script/console uses RAILS_ENV environment variable if present.  #2932 [Blair Zajac <blair@orcaware.com>

*   Windows: eliminate the socket option in database.yml.  #2924 *Wayne Vucenic <waynev@gmail.com>*

*   Eliminate nil from newly generated logfiles.  #2927 *Blair Zajac <blair@orcaware.com>*

*   Rename Version constant to VERSION. #2802 *Marcel Molina Jr.*

*   Eliminate Subversion dependencies in scripts/plugin.  Correct install options.  Introduce --force option to reinstall a plugin.  Remove useless --long option for list.  Use --quiet to quiet the download output and --revision to update to a specific svn revision.  #2842 *Chad Fowler, Rick Olson*

*   SQLite: the clone_structure_to_test and purge_test_database Rake tasks should always use the test environment.  #2846 *Rick Olson*

*   Make sure that legacy db tasks also reference :database for SQLite #2830 *kazuhiko@fdiary.net*

*   Pass __FILE__ when evaluating plugins' init.rb.  #2817 *James Adam*

*   Better svn status matching for generators.  #2814 *François Beausoleil <francois.beausoleil@gmail.com>, Blair Zajac <blair@orcaware.com>*

*   Don't reload routes until plugins have been loaded so they have a chance to extend the routing capabilities *David Heinemeier Hansson*

*   Don't detach or fork for script/server tailing *Nicholas Seckar*

*   Changed all script/* to use #!/usr/bin/env ruby instead of hard-coded Ruby path. public/dispatcher.* still uses the hard-coded path  for compatibility with web servers that don't have Ruby in path *David Heinemeier Hansson*

*   Force RAILS_ENV to be "test" when running tests, so that ENV["RAILS_ENV"] = "production" in config/environment.rb doesn't wreck havok [David Heinemeier Hansson] #2660

*   Correct versioning in :freeze_gems Rake task.  #2778 *Jakob Skjerning, Jeremy Kemper*

*   Added an omnipresent RailsInfoController with a properties action that delivers an HTML rendering of Rails::Info (but only when local_request? is true). Added a new default index.html which fetches this with Ajax. *Sam Stephenson*


## 0.14.3 (RC4) (November 7th, 2005) ##

##  Add 'add_new_scripts' rake task for adding new rails scripts to script/ Jamis Buck ##

*   Remove bogus hyphen from script/process/reaper calls to 'ps'.  #2767 *anonymous*

*   Copy lighttpd.conf when it is first needed, instead of on app creation *Jamis Buck*

*   Use require_library_or_gem 'fcgi' in script/server *Sam Stephenson*

*   Added default lighttpd config in config/lighttpd.conf and added a default runner for lighttpd in script/server (works like script/server, but using lighttpd and FastCGI). It will use lighttpd if available, otherwise WEBrick. You can force either or using 'script/server lighttpd' or 'script/server webrick' *David Heinemeier Hansson*

*   New configuration option config.plugin_paths which may be a single path like the default 'vendor/plugins' or an array of paths: ['vendor/plugins', 'lib/plugins'].  *Jeremy Kemper*

*   Plugins are discovered in nested paths, so you can organize your plugins directory as you like.  *Jeremy Kemper*

*   Refactor load_plugin from load_plugins.  #2757 *alex.r.moon@gmail.com*

*   Make use of silence_stderr in script/lighttpd, script/plugin, and Rails::Info *Sam Stephenson*

*   Enable HTTP installation of plugins when svn isn't avaialable. Closes #2661. *Chad Fowler*

*   Added script/about to display formatted Rails::Info output *Sam Stephenson*

*   Added Rails::Info to catalog assorted information about a Rails application's environment *Sam Stephenson*

*   Tail the logfile when running script/server lighttpd in the foreground *Sam Stephenson*

*   Try to guess the port number from config/lighttpd.conf in script/server lighttpd *Sam Stephenson*

*   Don't reap spawn-fcgi.  #2727 *matthew@walker.wattle.id.au*

*   Reaper knows how to find processes even if the dispatch path is very long.  #2711 *matthew@walker.wattle.id.au*

*   Make fcgi handler respond to TERM signals with an explicit exit *Jamis Buck*

*   Added demonstration of fixture use to the test case generated by the model generator *David Heinemeier Hansson*

*   If specified, pass PostgreSQL client character encoding to createdb.  #2703 *Kazuhiko <kazuhiko@fdiary.net>*

*   Catch CGI multipart parse errors.  Wrap dispatcher internals in a failsafe response handler.  *Jeremy Kemper*

*   The freeze_gems Rake task accepts the VERSION environment variable to decide which version of Rails to pull into vendor/rails.  *Chad Fowler, Jeremy Kemper*

*   Removed script.aculo.us.js, builder.js and slider.js (preperation for move of scriptaculous extensions to plugins, core scriptaculous will remain in Railties) *Thomas Fuchs*

*   The freeze_edge Rake task does smarter svn detection and can export a specific revision by passing the REVISION environment variable.  For example: rake freeze_edge REVISION=1234.  #2663 *Rick Olson*

*   Comment database.yml and include PostgreSQL and SQLite examples.  *Jeremy Kemper*

*   Improve script/plugin on Windows.  #2646 *Chad Fowler*

*   The *_plugindoc Rake tasks look deeper into the plugins' lib directories.  #2652 *bellis@deepthought.org*

*   The PostgreSQL :db_structure_dump Rake task limits its dump to the schema search path in database.yml.  *Anatol Pomozov <anatol.pomozov@gmail.com>*

*   Add task to generate rdoc for all installed plugins. *Marcel Molina Jr.*

*   Update script.aculo.us to V1.5_rc4 *Thomas Fuchs*

*   Add default Mac + DarwinPorts MySQL socket locations to the app generator.  *Jeremy Kemper*

*   Migrations may be destroyed: script/destroy migration foo.  #2635 *Charles M. Gerungan <charles.gerungan@gmail.com>, Jamis Buck, Jeremy Kemper*

*   Added that plugins can carry generators and that generator stub files can be created along with new plugins using script/generate plugin <name> --with-generator *David Heinemeier Hansson*

*   Removed app/apis as a default empty dir since its automatically created when using script/generate web_service *David Heinemeier Hansson*

*   Added script/plugin to manage plugins (install, remove, list, etc) *Ryan Tomayko*

*   Added test_plugins task: Run the plugin tests in vendor/plugins/**/test (or specify with PLUGIN=name) *David Heinemeier Hansson*

*   Added plugin generator to create a stub structure for a new plugin in vendor/plugins (see "script/generate plugin" for help) *David Heinemeier Hansson*

*   Fixed scaffold generator when started with only 1 parameter #2609 *self@mattmower.com*

*   rake should run functional tests even if the unit tests have failures *Jim Weirich*

*   Back off cleanpath to be symlink friendly. Closes #2533 *Nicholas Seckar*

*   Load rake task files in alphabetical order so you can build dependencies and count on them #2554 *Blair Zajac*


## 0.14.2 (RC3) (October 26th, 2005) ##

*   Constants set in the development/test/production environment file are set in Object

*   Scaffold generator pays attention to the controller name.  #2562 *self@mattmower.com*

*   Include tasks from vendor/plugins/*/tasks in the Rakefile #2545 *Rick Olson*


## 0.14.1 (RC2) (October 19th, 2005) ##

*   Don't clean RAILS_ROOT on windows

*   Remove trailing '/' from RAILS_ROOT *Nicholas Seckar*

*   Upgraded to Active Record 1.12.1 and Action Pack 1.10.1


## 0.14.0 (RC1) (October 16th, 2005) ##

*   Moved generator folder from RAILS_ROOT/generators to RAILS_ROOT/lib/generators *Tobias Lütke*

*   Fix rake dev and related commands *Nicholas Seckar*

*   The rails command tries to deduce your MySQL socket by running `mysql_config
    --socket`.  If it fails, default to /path/to/your/mysql.sock

*   Made the rails command use the application name for database names in the tailored database.yml file. Example: "rails ~/projects/blog" will use "blog_development" instead of "rails_development". *Florian Weber*

*   Added Rails framework freezing tasks: freeze_gems (freeze to current gems), freeze_edge (freeze to Rails SVN trunk), unfreeze_rails (float with newest gems on system)

*   Added update_javascripts task which will fetch all the latest js files from your current rails install. Use after updating rails. *Tobias Lütke*

*   Added cleaning of RAILS_ROOT to useless elements such as '../non-dot-dot/'. Provides cleaner backtraces and error messages. *Nicholas Seckar*

*   Made the instantiated/transactional fixtures settings be controlled through Rails::Initializer. Transactional and non-instantiated fixtures are default from now on. *Florian Weber*

*   Support using different database adapters for development and test with ActiveRecord::Base.schema_format = :ruby *Sam Stephenson*

*   Make webrick work with session(:off)

*   Add --version, -v option to the Rails command. Closes #1840. *stancell*

*   Update Prototype to V1.4.0_pre11, script.aculo.us to V1.5_rc3 [2504] and fix the rails generator to include the new .js files *Thomas Fuchs*

*   Make the generator skip a file if it already exists and is identical to the new file.

*   Add experimental plugin support #2335

*   Made Rakefile aware of new .js files in script.aculo.us *Thomas Fuchs*

*   Make table_name and controller_name in generators honor AR::Base.pluralize_table_names. #1216 #2213 *kazuhiko@fdiary.net*

*   Clearly label functional and unit tests in rake stats output.  #2297 *lasse.koskela@gmail.com*

*   Make the migration generator only check files ending in *.rb when calculating the next file name #2317 *Chad Fowler*

*   Added prevention of duplicate migrations from the generator #2240 *François Beausoleil*

*   Add db_schema_dump and db_schema_import rake tasks to work with the new ActiveRecord::SchemaDumper (for dumping a schema to and reading a schema from a ruby file).

*   Reformed all the config/environments/* files to conform to the new Rails::Configuration approach. Fully backwards compatible.

*   Added create_sessions_table, drop_sessions_table, and purge_sessions_table as rake tasks for databases that supports migrations (MySQL, PostgreSQL, SQLite) to get a table for use with CGI::Session::ActiveRecordStore

*   Added dump of schema version to the db_structure_dump task for databases that support migrations #1835 *Rick Olson*

*   Fixed script/profiler for Ruby 1.8.2 #1863 *Rick Olson*

*   Fixed clone_structure_to_test task for SQLite #1864 *jon@burningbush.us*

*   Added -m/--mime-types option to the WEBrick server, so you can specify a Apache-style mime.types file to load #2059 *ask@develooper.com*

*   Added -c/--svn option to the generator that'll add new files and remove destroyed files using svn add/revert/remove as appropriate #2064 *Kevin Clark*

*   Added -c/--charset option to WEBrick server, so you can specify a default charset (which without changes is UTF-8) #2084 *wejn@box.cz*

*   Make the default stats task extendable by modifying the STATS_DIRECTORIES constant

*   Allow the selected environment to define RAILS_DEFAULT_LOGGER, and have Rails::Initializer use it if it exists.

*   Moved all the shared tasks from Rakefile into Rails, so that the Rakefile is empty and doesn't require updating.

*   Added Rails::Initializer and Rails::Configuration to abstract all of the common setup out of config/environment.rb (uses config/boot.rb to bootstrap the initializer and paths)

*   Fixed the scaffold generator to fail right away if the database isn't accessible instead of in mid-air #1169 *Chad Fowler*

*   Corrected project-local generator location in scripts.rb #2010 *Michael Schuerig*

*   Don't require the environment just to clear the logs #2093 *Scott Barron*

*   Make the default rakefile read *.rake files from config/tasks (for easy extension of the rakefile by e.g. generators)

*   Only load breakpoint in development mode and when BREAKPOINT_SERVER_PORT is defined.

*   Allow the --toggle-spin switch on process/reaper to be negated

*   Replace render_partial with render :partial in scaffold generator *Nicholas Seckar*

*   Added -w flag to ps in process/reaper #1934 *Scott Barron*

*   Allow ERb in the database.yml file (just like with fixtures), so you can pull out the database configuration in environment variables #1822 *Duane Johnson*

*   Added convenience controls for FCGI processes (especially when managed remotely): spinner, spawner, and reaper. They reside in script/process. More details can be had by calling them with -h/--help.

*   Added load_fixtures task to the Rakefile, which will load all the fixtures into the database for the current environment #1791 *Marcel Molina Jr.*

*   Added an empty robots.txt to public/, so that web servers asking for it won't trigger a dynamic call, like favicon.ico #1738 *Michael Schubert*

*   Dropped the 'immediate close-down' of FCGI processes since it didn't work consistently and produced bad responses when it didn't. So now a TERM ensures exit after the next request (just as if the process is handling a request when it receives the signal). This means that you'll have to 'nudge' all FCGI processes with a request in order to ensure that they have all reloaded. This can be done by something like ./script/process/repear --nudge 'http://www.myapp.com' --instances 10, which will load the myapp site 10 times (and thus hit all of the 10 FCGI processes once, enough to shut down).


## 0.13.1 (11 July, 2005) ##

*   Look for app-specific generators in RAILS_ROOT/generators rather than the clunky old RAILS_ROOT/script/generators.  Nobody really uses this feature except for the unit tests, so it's a negligible-impact change.  If you want to work with third-party generators, drop them in ~/.rails/generators or simply install gems.

*   Fixed that each request with the WEBrick adapter would open a new database connection #1685 *Sam Stephenson*

*   Added support for SQL Server in the database rake tasks #1652 [Ken Barker] Note: osql and scptxfr may need to be installed on your development environment. This involves getting the .exes and a .rll (scptxfr) from a production SQL Server (not developer level SQL Server). Add their location to your Environment PATH and you are all set.

*   Added a VERSION parameter to the migrate task that allows you to do "rake migrate VERSION=34" to migrate to the 34th version traveling up or down depending on the current version

*   Extend Ruby version check to include RUBY_RELEASE_DATE >= '2005-12-25', the final Ruby 1.8.2 release #1674 *court3nay*

*   Improved documentation for environment config files #1625 *court3nay*


## 0.13.0 (6 July, 2005) ##

*   Changed the default logging level in config/environment.rb to INFO for production (so SQL statements won't be logged)

*   Added migration generator: ./script/generate migration add_system_settings

*   Added "migrate" as rake task to execute all the pending migrations from db/migrate

*   Fixed that model generator would make fixtures plural, even if ActiveRecord::Base.pluralize_table_names was false #1185 *Marcel Molina Jr.*

*   Added a DOCTYPE of HTML transitional to the HTML files generated by Rails #1124 *Michael Koziarski*

*   SIGTERM also gracefully exits dispatch.fcgi.  Ignore SIGUSR1 on Windows.

*   Add the option to manually manage garbage collection in the FastCGI dispatcher.  Set the number of requests between GC runs in your public/dispatch.fcgi *Stefan Kaes*

*   Allow dynamic application reloading for dispatch.fcgi processes by sending a SIGHUP. If the process is currently handling a request, the request will be allowed to complete first. This allows production fcgi's to be reloaded without having to restart them.

*   RailsFCGIHandler (dispatch.fcgi) no longer tries to explicitly flush $stdout (CgiProcess#out always calls flush)

*   Fixed rakefile actions against PostgreSQL when the password is all numeric #1462 *Michael Schubert*

*   ActionMailer::Base subclasses are reloaded with the other rails components #1262

*   Made the WEBrick adapter not use a mutex around action performance if ActionController::Base.allow_concurrency is true (default is false)

*   Fixed that mailer generator generated fixtures/plural while units expected fixtures/singular #1457 *Scott Barron*

*   Added a 'whiny nil' that's aim to ensure that when users pass nil to methods where that isn't appropriate, instead of NoMethodError? and the name of some method used by the framework users will see a message explaining what type of object was expected. Only active in test and development environments by default #1209 *Michael Koziarski*

*   Fixed the test_helper.rb to be safe for requiring controllers from multiple spots, like app/controllers/article_controller.rb and app/controllers/admin/article_controller.rb, without reloading the environment twice #1390 *Nicholas Seckar*

*   Fixed Webrick to escape + characters in URL's the same way that lighttpd and apache do #1397 *Nicholas Seckar*

*   Added -e/--environment option to script/runner #1408 *François Beausoleil*

*   Modernize the scaffold generator to use the simplified render and test methods and to change style from @params["id"] to params[:id].  #1367

*   Added graceful exit from pressing CTRL-C during the run of the rails command #1150 *Caleb Tennis*

*   Allow graceful exits for dispatch.fcgi processes by sending a SIGUSR1. If the process is currently handling a request, the request will be allowed to complete and then will terminate itself. If a request is not being handled, the process is terminated immediately (via #exit). This basically works like restart graceful on Apache. *Jamis Buck*

*   Made dispatch.fcgi more robust by catching fluke errors and retrying unless its a permanent condition. *Jamis Buck*

*   Added console --profile for profiling an IRB session #1154 *Jeremy Kemper*

*   Changed console_sandbox into console --sandbox #1154 *Jeremy Kemper*


## 0.12.1 (20th April, 2005) ##

*   Upgraded to Active Record 1.10.1, Action Pack 1.8.1, Action Mailer 0.9.1, Action Web Service 0.7.1


## 0.12.0 (19th April, 2005) ##

*   Fixed that purge_test_database would use database settings from the development environment when recreating the test database #1122 *rails@cogentdude.com*

*   Added script/benchmarker to easily benchmark one or more statement a number of times from within the environment. Examples:

        # runs the one statement 10 times
        script/benchmarker 10 'Person.expensive_method(10)'

        # pits the two statements against each other with 50 runs each
        script/benchmarker 50 'Person.expensive_method(10)' 'Person.cheap_method(10)'

*   Added script/profiler to easily profile a single statement from within the environment. Examples:

        script/profiler 'Person.expensive_method(10)'
        script/profiler 'Person.expensive_method(10)' 10 # runs the statement 10 times

*   Added Rake target clear_logs that'll truncate all the *.log files in log/ to zero #1079 *Lucas Carlson*

*   Added lazy typing for generate, such that ./script/generate cn == ./script/generate controller and the likes #1051 *k@v2studio.com*

*   Fixed that ownership is brought over in pg_dump during tests for PostgreSQL #1060 *pburleson*

*   Upgraded to Active Record 1.10.0, Action Pack 1.8.0, Action Mailer 0.9.0, Action Web Service 0.7.0, Active Support 1.0.4


## 0.11.1 (27th March, 2005) ##

*   Fixed the dispatch.fcgi use of a logger

*   Upgraded to Active Record 1.9.1, Action Pack 1.7.0, Action Mailer 0.8.1, Action Web Service 0.6.2, Active Support 1.0.3


## 0.11.0 (22th March, 2005) ##

*   Removed SCRIPT_NAME from the WEBrick environment to prevent conflicts with PATH_INFO #896 *Nicholas Seckar*

*   Removed ?$1 from the dispatch.f/cgi redirect line to get rid of 'complete/path/from/request.html' => nil being in the @params now that the ENV["REQUEST_URI"] is used to determine the path #895 *dblack/Nicholas Seckar*

*   Added additional error handling to the FastCGI dispatcher to catch even errors taking down the entire process

*   Improved the generated scaffold code a lot to take advantage of recent Rails developments #882 *Tobias Lütke*

*   Combined the script/environment.rb used for gems and regular files version. If vendor/rails/* has all the frameworks, then files version is used, otherwise gems #878 *Nicholas Seckar*

*   Changed .htaccess to allow dispatch.* to be called from a sub-directory as part of the push with Action Pack to make Rails work on non-vhost setups #826 *Nicholas Seckar/Tobias Lütke*

*   Added script/runner which can be used to run code inside the environment by eval'ing the first parameter. Examples:

        ./script/runner 'ReminderService.deliver'
        ./script/runner 'Mailer.receive(STDIN.read)'

    This makes it easier to do CRON and postfix scripts without actually making a script just to trigger 1 line of code.

*   Fixed webrick_server cookie handling to allow multiple cookes to be set at once #800, #813 *dave@cherryville.org*

*   Fixed the Rakefile's interaction with postgresql to:

        1. Use PGPASSWORD and PGHOST in the environment to fix prompting for
           passwords when connecting to a remote db and local socket connections.
        2. Add a '-x' flag to pg_dump which stops it dumping privileges #807 [rasputnik]
        3. Quote the user name and use template0 when dumping so the functions doesn't get dumped too #855 [pburleson]
        4. Use the port if available #875 [madrobby]

*   Upgraded to Active Record 1.9.0, Action Pack 1.6.0, Action Mailer 0.8.0, Action Web Service 0.6.1, Active Support 1.0.2


## 0.10.1 (7th March, 2005) ##

*   Fixed rake stats to ignore editor backup files like model.rb~ #791 *Sebastian Kanthak*

*   Added exception shallowing if the DRb server can't be started (not worth making a fuss about to distract new users) #779 *Tobias Lütke*

*   Added an empty favicon.ico file to the public directory of new applications (so the logs are not spammed by its absence)

*   Fixed that scaffold generator new template should use local variable instead of instance variable #778 *Dan Peterson*

*   Allow unit tests to run on a remote server for PostgreSQL #781 *adamm@galacticasoftware.com*

*   Added web_service generator (run ./script/generate web_service for help) #776 *Leon Bredt*

*   Added app/apis and components to code statistics report #729 *Scott Barron*

*   Fixed WEBrick server to use ABSOLUTE_RAILS_ROOT instead of working_directory #687 *Nicholas Seckar*

*   Fixed rails_generator to be usable without RubyGems #686 *Cristi BALAN*

*   Fixed -h/--help for generate and destroy generators #331

*   Added begin/rescue around the FCGI dispatcher so no uncaught exceptions can bubble up to kill the process (logs to log/fastcgi.crash.log)

*   Fixed that association#count would produce invalid sql when called sequentialy #659 *kanis@comcard.de*

*   Fixed test/mocks/testing to the correct test/mocks/test #740

*   Added early failure if the Ruby version isn't 1.8.2 or above #735

*   Removed the obsolete -i/--index option from the WEBrick servlet #743

*   Upgraded to Active Record 1.8.0, Action Pack 1.5.1, Action Mailer 0.7.1, Action Web Service 0.6.0, Active Support 1.0.1


## 0.10.0 (24th February, 2005) ##

*   Changed default IP binding for WEBrick from 127.0.0.1 to 0.0.0.0 so that the server is accessible both locally and remotely #696 *Marcel Molina Jr.*

*   Fixed that script/server -d was broken so daemon mode couldn't be used #687 *Nicholas Seckar*

*   Upgraded to breakpoint 92 which fixes:

        * overload IRB.parse_opts(), fixes #443
          => breakpoints in tests work even when running them via rake
        * untaint handlers, might fix an issue discussed on the Rails ML
        * added verbose mode to breakpoint_client
        * less noise caused by breakpoint_client by default
        * ignored TerminateLineInput exception in signal handler
          => quiet exit on Ctrl-C

*   Added support for independent components residing in /components. Example:

        Controller: components/list/items_controller.rb
        (holds a List::ItemsController class with uses_component_template_root called)

        Model     : components/list/item.rb
        (namespace is still shared, so an Item model in app/models will take precedence)

        Views     : components/list/items/show.rhtml


*   Added --sandbox option to script/console that'll roll back all changes made to the database when you quit #672 *Jeremy Kemper*

*   Added 'recent' as a rake target that'll run tests for files that changed in the last 10 minutes #612 *Jeremy Kemper*

*   Changed script/console to default to development environment and drop --no-inspect #650 *Jeremy Kemper*

*   Added that the 'fixture :posts' syntax can be used for has_and_belongs_to_many fixtures where a model doesn't exist #572 *Jeremy Kemper*

*   Added that running test_units and test_functional now performs the clone_structure_to_test as well #566 *rasputnik*

*   Added new generator framework that informs about its doings on generation and enables updating and destruction of generated artifacts. See the new script/destroy and script/update for more details #487 *Jeremy Kemper*

*   Added Action Web Service as a new add-on framework for Action Pack *Leon Bredt*

*   Added Active Support as an independent utility and standard library extension bundle

*   Upgraded to Active Record 1.7.0, Action Pack 1.5.0, Action Mailer 0.7.0


## 0.9.5 (January 25th, 2005) ##

*   Fixed dependency reloading by switching to a remove_const approach where all Active Records, Active Record Observers, and Action Controllers are reloading by undefining their classes. This enables you to remove methods in all three types and see the change reflected immediately and it fixes #539. This also means that only those three types of classes will benefit from the const_missing and reloading approach. If you want other classes (like some in lib/) to reload, you must use require_dependency to do it.

*   Added Florian Gross' latest version of Breakpointer and friends that fixes a variaty of bugs #441 *Florian Gross*

*   Fixed skeleton Rakefile to work with sqlite3 out of the box #521 *rasputnik*

*   Fixed that script/breakpointer didn't get the Ruby path rewritten as the other scripts #523 *brandt@kurowski.net*

*   Fixed handling of syntax errors in models that had already been succesfully required once in the current interpreter

*   Fixed that models that weren't referenced in associations weren't being reloaded in the development mode by reinstating the reload

*   Fixed that generate scaffold would produce bad functional tests

*   Fixed that FCGI can also display SyntaxErrors

*   Upgraded to Active Record 1.6.0, Action Pack 1.4.0


## 0.9.4.1 (January 18th, 2005) ##

*   Added 5-second timeout to WordNet alternatives on creating reserved-word models #501 *Marcel Molina Jr.*

*   Fixed binding of caller #496 *Alexey*

*   Upgraded to Active Record 1.5.1, Action Pack 1.3.1, Action Mailer 0.6.1


## 0.9.4 (January 17th, 2005) ##

*   Added that ApplicationController will catch a ControllerNotFound exception if someone attempts to access a url pointing to an unexisting controller *Tobias Lütke*

*   Flipped code-to-test ratio around to be more readable #468 *Scott Baron*

*   Fixed log file permissions to be 666 instead of 777 (so they're not executable) #471 *Lucas Carlson*

*   Fixed that auto reloading would some times not work or would reload the models twice #475 *Tobias Lütke*

*   Added rewrite rules to deal with caching to public/.htaccess

*   Added the option to specify a controller name to "generate scaffold" and made the default controller name the plural form of the model.

*   Added that rake clone_structure_to_test, db_structure_dump, and purge_test_database tasks now pick up the source database to use from
    RAILS_ENV instead of just forcing development #424 *Tobias Lütke*

*   Fixed script/console to work with Windows (that requires the use of irb.bat) #418 *Chris McGrath*

*   Fixed WEBrick servlet slowdown over time by restricting the load path reloading to mod_ruby

*   Removed Fancy Indexing as a default option on the WEBrick servlet as it made it harder to use various caching schemes

*   Upgraded to Active Record 1.5, Action Pack 1.3, Action Mailer 0.6


## 0.9.3 (January 4th, 2005) ##

*   Added support for SQLite in the auto-dumping/importing of schemas for development -> test #416

*   Added automated rewriting of the shebang lines on installs through the gem rails command #379 *Manfred Stienstra*

*   Added ActionMailer::Base.deliver_method = :test to the test environment so that mail objects are available in ActionMailer::Base.deliveries
    for functional testing.

*   Added protection for creating a model through the generators with a name of an existing class, like Thread or Date.
    It'll even offer you a synonym using wordnet.princeton.edu as a look-up. No, I'm not kidding :) *Florian Gross*

*   Fixed dependency management to happen in a unified fashion for Active Record and Action Pack using the new Dependencies module. This means that
    the environment options needs to change from:

        Before in development.rb:
          ActionController::Base.reload_dependencies = true  
          ActiveRecord::Base.reload_associations     = true

        Now in development.rb:
          Dependencies.mechanism = :load

        Before in production.rb and test.rb:
          ActionController::Base.reload_dependencies = false
          ActiveRecord::Base.reload_associations     = false

        Now in production.rb and test.rb:
          Dependencies.mechanism = :require

*   Fixed problems with dependency caching and controller hierarchies on Ruby 1.8.2 in development mode #351

*   Fixed that generated action_mailers doesnt need to require the action_mailer since thats already done in the environment #382 *Lucas Carlson*

*   Upgraded to Action Pack 1.2.0 and Active Record 1.4.0


## 0.9.2 ##

*   Fixed CTRL-C exists from the Breakpointer to be a clean affair without error dumping *Kent Sibilev*

*   Fixed "rake stats" to work with sub-directories in models and controllers and to report the code to test ration *Scott Baron*

*   Added that Active Record associations are now reloaded instead of cleared to work with the new const_missing hook in Active Record.

*   Added graceful handling of an inaccessible log file by redirecting output to STDERR with a warning #330 *rainmkr*

*   Added support for a -h/--help parameter in the generator #331 *Ulysses*

*   Fixed that File.expand_path in config/environment.rb would fail when dealing with symlinked public directories *mjobin*

*   Upgraded to Action Pack 1.1.0 and Active Record 1.3.0


## 0.9.1 ##

*   Upgraded to Action Pack 1.0.1 for important bug fix

*   Updated gem dependencies


## 0.9.0 ##

*   Renamed public/dispatch.servlet to script/server -- it wasn't really dispatching anyway as its delegating calls to public/dispatch.rb

*   Renamed AbstractApplicationController and abstract_application.rb to ApplicationController and application.rb, so that it will be possible
    for the framework to automatically pick up on app/views/layouts/application.rhtml and app/helpers/application.rb

*   Added script/console that makes it even easier to start an IRB session for interacting with the domain model. Run with no-args to
    see help.

*   Added breakpoint support through the script/breakpointer client. This means that you can break out of execution at any point in
    the code, investigate and change the model, AND then resume execution! Example:

        class WeblogController < ActionController::Base
          def index
            @posts = Post.find_all
            breakpoint "Breaking out from the list"
          end
        end

    So the controller will accept the action, run the first line, then present you with a IRB prompt in the breakpointer window.
    Here you can do things like:

    Executing breakpoint "Breaking out from the list" at .../webrick_server.rb:16 in 'breakpoint'

        >> @posts.inspect
        => "[#<Post:0x14a6be8 @attributes={\"title\"=>nil, \"body\"=>nil, \"id\"=>\"1\"}>,
             #<Post:0x14a6620 @attributes={\"title\"=>\"Rails you know!\", \"body\"=>\"Only ten..\", \"id\"=>\"2\"}>]"
        >> @posts.first.title = "hello from a breakpoint"
        => "hello from a breakpoint"

    ...and even better is that you can examine how your runtime objects actually work:

        >> f = @posts.first
        => #<Post:0x13630c4 @attributes={"title"=>nil, "body"=>nil, "id"=>"1"}>
        >> f.
        Display all 152 possibilities? (y or n)

    Finally, when you're ready to resume execution, you press CTRL-D

*   Changed environments to be configurable through an environment variable. By default, the environment is "development", but you
    can change that and set your own by configuring the Apache vhost with a string like (mod_env must be available on the server):

        SetEnv RAILS_ENV production

    ...if you're using WEBrick, you can pick the environment to use with the command-line parameters -e/--environment, like this:

        ruby public/dispatcher.servlet -e production

*   Added a new default environment called "development", which leaves the production environment to be tuned exclusively for that.

*   Added a start_server in the root of the Rails application to make it even easier to get started

*   Fixed public/.htaccess to use RewriteBase and share the same rewrite rules for all the dispatch methods

*   Fixed webrick_server to handle requests in a serialized manner (the Rails reloading infrastructure is not thread-safe)

*   Added support for controllers in directories. So you can have:

        app/controllers/account_controller.rb        # URL: /account/
        app/controllers/admin/account_controller.rb  # URL: /admin/account/

    NOTE: You need to update your public/.htaccess with the new rules to pick it up

*   Added reloading for associations and dependencies under cached environments like FastCGI and mod_ruby. This makes it possible to use
    those environments for development. This is turned on by default, but can be turned off with
    ActiveRecord::Base.reload_associations = false and ActionController::Base.reload_dependencies = false in production environments.

*   Added support for sub-directories in app/models. So now you can have something like Basecamp with:

        app/models/accounting
        app/models/project
        app/models/participants
        app/models/settings

    It's poor man's namespacing, but only for file-system organization. You still require files just like before.
    Nothing changes inside the files themselves.


*   Fixed a few references in the tests generated by new_mailer *Jeremy Kemper*

*   Added support for mocks in testing with test/mocks

*   Cleaned up the environments a bit and added global constant RAILS_ROOT


## 0.8.5 (9) ##

*   Made dev-util available to all tests, so you can insert breakpoints in any test case to get an IRB prompt at that point [Jeremy Kemper]:

        def test_complex_stuff
          @david.projects << @new_project
          breakpoint "Let's have a closer look at @david"
        end

    You need to install dev-utils yourself for this to work ("gem install dev-util").

*   Added shared generator behavior so future upgrades should be possible without manually copying over files *Jeremy Kemper*

*   Added the new helper style to both controller and helper templates *Jeremy Kemper*

*   Added new_crud generator for creating a model and controller at the same time with explicit scaffolding *Jeremy Kemper*

*   Added configuration of Test::Unit::TestCase.fixture_path to test_helper to concide with the new AR fixtures style

*   Fixed that new_model was generating singular table/fixture names

*   Upgraded to Action Mailer 0.4.0

*   Upgraded to Action Pack 0.9.5

*   Upgraded to Active Record 1.1.0


## 0.8.0 (15) ##

*   Removed custom_table_name option for new_model now that the Inflector is as powerful as it is

*   Changed the default rake action to just do testing and separate API generation and coding statistics into a "doc" task.

*   Fixed WEBrick dispatcher to handle missing slashes in the URLs gracefully *alexey*

*   Added user option for all postgresql tool calls in the rakefile *elvstone*

*   Fixed problem with running "ruby public/dispatch.servlet" instead of "cd public; ruby dispatch.servlet" *alexey*

*   Fixed WEBrick server so that it no longer hardcodes the ruby interpreter used to "ruby" but will get the one used based
    on the Ruby runtime configuration. *Marcel Molina Jr.*

*   Fixed Dispatcher so it'll route requests to magic_beans to MagicBeansController/magic_beans_controller.rb *Caio Chassot*

*   "new_controller MagicBeans" and "new_model SubscriptionPayments" will now both behave properly as they use the new Inflector.

*   Fixed problem with MySQL foreign key constraint checks in Rake :clone_production_structure_to_test target *Andreas Schwarz*

*   Changed WEBrick server to by default be auto-reloading, which is slower but makes source changes instant.
    Class compilation cache can be turned on with "-c" or "--cache-classes".

*   Added "-b/--binding" option to WEBrick dispatcher to bind the server to a specific IP address (default: 127.0.0.1) *Kevin Temp*

*   dispatch.fcgi now DOESN'T set FCGI_PURE_RUBY as it was slowing things down for now reason *Andreas Schwarz*

*   Added new_mailer generator to work with Action Mailer

*   Included new framework: Action Mailer 0.3

*   Upgraded to Action Pack 0.9.0

*   Upgraded to Active Record 1.0.0


## 0.7.0 ##

*   Added an optional second argument to the new_model script that allows the programmer to specify the table name,
    which will used to generate a custom table_name method in the model and will also be used in the creation of fixtures.
    *Kevin Radloff*

*   script/new_model now turns AccountHolder into account_holder instead of accountholder *Kevin Radloff*

*   Fixed the faulty handleing of static files with WEBrick *Andreas Schwarz*

*   Unified function_test_helper and unit_test_helper into test_helper

*   Fixed bug with the automated production => test database dropping on PostgreSQL *dhawkins*

*   create_fixtures in both the functional and unit test helper now turns off the log during fixture generation
    and can generate more than one fixture at a time. Which makes it possible for assignments like:

        @people, @projects, @project_access, @companies, @accounts =
          create_fixtures "people", "projects", "project_access", "companies", "accounts"

*   Upgraded to Action Pack 0.8.5 (locally-scoped variables, partials, advanced send_file)

*   Upgraded to Active Record 0.9.5 (better table_name guessing, cloning, find_all_in_collection)


## 0.6.5 ##

*   No longer specifies a template for rdoc, so it'll use whatever is default (you can change it in the rakefile)

*   The new_model generator will now use the same rules for plural wordings as Active Record
    (so Category will give categories, not categorys) *Kevin Radloff*

*   dispatch.fcgi now sets FCGI_PURE_RUBY to true to ensure that it's the Ruby version that's loaded *danp*

*   Made the GEM work with Windows

*   Fixed bug where mod_ruby would "forget" the load paths added when switching between controllers

*   PostgreSQL are now supported for the automated production => test database dropping *Kevin Radloff*

*   Errors thrown by the dispatcher are now properly handled in FCGI.

*   Upgraded to Action Pack 0.8.0 (lots and lots and lots of fixes)

*   Upgraded to Active Record 0.9.4 (a bunch of fixes)


## 0.6.0 ##

*   Added AbstractionApplicationController as a superclass for all controllers generated. This class can be used
    to carry filters and methods that are to be shared by all. It has an accompanying ApplicationHelper that all
    controllers will also automatically have available.

*   Added environments that can be included from any script to get the full Active Record and Action Controller
    context running. This can be used by maintenance scripts or to interact with the model through IRB. Example:

        require 'config/environments/production'

        for account in Account.find_all
          account.recalculate_interests
        end

    A short migration script for an account model that had it's interest calculation strategy changed.

*   Accessing the index of a controller with "/weblog" will now redirect to "/weblog/" (only on Apache, not WEBrick)

*   Simplified the default Apache config so even remote requests are served off CGI as a default.
    You'll now have to do something specific to activate mod_ruby and FCGI (like using the force urls).
    This should make it easier for new comers that start on an external server.

*   Added more of the necessary Apache options to .htaccess to make it easier to setup

*   Upgraded to Action Pack 0.7.9 (lots of fixes)

*   Upgraded to Active Record 0.9.3 (lots of fixes)


## 0.5.7 ##

*   Fixed bug in the WEBrick dispatcher that prevented it from getting parameters from the URL
    (through GET requests or otherwise)

*   Added lib in root as a place to store app specific libraries

*   Added lib and vendor to load_path, so anything store within can be loaded directly.
    Hence lib/redcloth.rb can be loaded with require "redcloth"

*   Upgraded to Action Pack 0.7.8 (lots of fixes)

*   Upgraded to Active Record 0.9.2 (minor upgrade)


## 0.5.6 ##

*   Upgraded to Action Pack 0.7.7 (multipart form fix)

*   Updated the generated template stubs to valid XHTML files

*   Ensure that controllers generated are capitalized, so "new_controller TodoLists"
    gives the same as "new_controller Todolists" and "new_controller todolists".


## 0.5.5 ##

*   Works on Windows out of the box! (Dropped symlinks)

*   Added webrick dispatcher: Try "ruby public/dispatch.servlet --help" *Florian Gross*

*   Report errors about initialization to browser (instead of attempting to use uninitialized logger)

*   Upgraded to Action Pack 0.7.6

*   Upgraded to Active Record 0.9.1

*   Added distinct 500.html instead of reusing 404.html

*   Added MIT license


## 0.5.0 ##

*   First public release
