package knf.kuma.videoservers;

import android.content.Context;

import org.jsoup.Jsoup;

import androidx.annotation.Nullable;
import knf.kuma.commons.BypassUtil;
import knf.kuma.commons.PatternUtil;

import static knf.kuma.videoservers.VideoServer.Names.FIRE;

public class FireServer extends Server {
    FireServer(Context context, String baseLink) {
        super(context, baseLink);
    }

    @Override
    public boolean isValid() {
        return baseLink.contains("efire.php");
    }

    @Override
    public String getName() {
        return FIRE;
    }

    @Nullable
    @Override
    public VideoServer getVideoServer() {
        try {
            String frame = PatternUtil.extractLink(baseLink);
            String media_func = Jsoup.connect(frame).cookies(BypassUtil.getMapCookie(context)).userAgent(BypassUtil.userAgent).get().select("script").last().outerHtml();
            String download = Jsoup.connect(PatternUtil.extractMediaLink(media_func)).get().select("a[href~=http://download.*]").first().attr("href");
            return new VideoServer(FIRE, new Option(getName(), null, download));
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}