# ADC ドライバ

<!---
  original document: 0.10.52:docs/adc_driver.md
  git diff 0.10.52 HEAD -- docs/adc_driver.md | cat
-->

QMK は対応している MCU のアナログ・デジタルコンバータ（ADC) を使用し、特定のピンの電圧を計測することができます。この機能はデジタル出力の[ロータリーエンコーダ](ja/feature_encoders.md)などではなく、アナログ計測が必要な可変抵抗器を使用したボリュームコントロールや Bluetooth キーボードのバッテリー残量表示などの実装に役立ちます。

このドライバは現在 AVR と一部の ARM デバイスをサポートしています。返される値は 0V と VCC (通常 AVR の場合は 5V または 3.3V、ARM の場合は 3.3V)の間でマッピングされた 10ビットの整数 (0-1023) ですが、ARM の場合、もしもより精度が必要であれば `#define` を使うと操作をより柔軟に制御できます。

## 使い方

このドライバを使うには、`rules.mk` に以下を追加します:

```make
SRC += analog.c
```

そして、コードの先頭に以下の include を置きます:

```c
#include "analog.h"
```

## チャンネル

### AVR

|Channel|AT90USB64/128|ATmega16/32U4|ATmega32A|ATmega328/P|
|-------|-------------|-------------|---------|-----------|
|0      |`F0`         |`F0`         |`A0`     |`C0`       |
|1      |`F1`         |`F1`         |`A1`     |`C1`       |
|2      |`F2`         |             |`A2`     |`C2`       |
|3      |`F3`         |             |`A3`     |`C3`       |
|4      |`F4`         |`F4`         |`A4`     |`C4`       |
|5      |`F5`         |`F5`         |`A5`     |`C5`       |
|6      |`F6`         |`F6`         |`A6`     |*          |
|7      |`F7`         |`F7`         |`A7`     |*          |
|8      |             |`D4`         |         |           |
|9      |             |`D6`         |         |           |
|10     |             |`D7`         |         |           |
|11     |             |`B4`         |         |           |
|12     |             |`B5`         |         |           |
|13     |             |`B6`         |         |           |

<sup>\* ATmega328/P には余分な2つの ADC チャンネルがありますが、DIP ピンアウトには存在せず、GPIO ピンとは共有されません。これらに直接アクセスするために、`adc_read()` を使えます。

### ARM

これらのピンの一部は同じチャンネルを使って ADC 上でダブルアップされることに注意してください。これは、これらのピンがどちらかの ADC に使われる可能性があるからです。

また、F0 と F3 は異なるナンバリングスキーマを使うことに注意してください。F0 には1つの ADC があり、チャンネルは0から始まるインデックスですが、F3 には4つの ADC があり、チャンネルは1から始まるインデックスです。これは、F0 が ADC の `ADCv1` 実装を使用するのに対し、F3 が `ADCv3` 実装を使用するためです。

|ADC|Channel|STM32F0xx|STM32F3xx|
|---|-------|---------|---------|
|1  |0      |`A0`     |         |
|1  |1      |`A1`     |`A0`     |
|1  |2      |`A2`     |`A1`     |
|1  |3      |`A3`     |`A2`     |
|1  |4      |`A4`     |`A3`     |
|1  |5      |`A5`     |`F4`     |
|1  |6      |`A6`     |`C0`     |
|1  |7      |`A7`     |`C1`     |
|1  |8      |`B0`     |`C2`     |
|1  |9      |`B1`     |`C3`     |
|1  |10     |`C0`     |`F2`     |
|1  |11     |`C1`     |         |
|1  |12     |`C2`     |         |
|1  |13     |`C3`     |         |
|1  |14     |`C4`     |         |
|1  |15     |`C5`     |         |
|1  |16     |         |         |
|2  |1      |         |`A4`     |
|2  |2      |         |`A5`     |
|2  |3      |         |`A6`     |
|2  |4      |         |`A7`     |
|2  |5      |         |`C4`     |
|2  |6      |         |`C0`     |
|2  |7      |         |`C1`     |
|2  |8      |         |`C2`     |
|2  |9      |         |`C3`     |
|2  |10     |         |`F2`     |
|2  |11     |         |`C5`     |
|2  |12     |         |`B2`     |
|2  |13     |         |         |
|2  |14     |         |         |
|2  |15     |         |         |
|2  |16     |         |         |
|3  |1      |         |`B1`     |
|3  |2      |         |`E9`     |
|3  |3      |         |`E13`    |
|3  |4      |         |         |
|3  |5      |         |         |
|3  |6      |         |`E8`     |
|3  |7      |         |`D10`    |
|3  |8      |         |`D11`    |
|3  |9      |         |`D12`    |
|3  |10     |         |`D13`    |
|3  |11     |         |`D14`    |
|3  |12     |         |`B0`     |
|3  |13     |         |`E7`     |
|3  |14     |         |`E10`    |
|3  |15     |         |`E11`    |
|3  |16     |         |`E12`    |
|4  |1      |         |`E14`    |
|4  |2      |         |`B12`    |
|4  |3      |         |`B13`    |
|4  |4      |         |`B14`    |
|4  |5      |         |`B15`    |
|4  |6      |         |`E8`     |
|4  |7      |         |`D10`    |
|4  |8      |         |`D11`    |
|4  |9      |         |`D12`    |
|4  |10     |         |`D13`    |
|4  |11     |         |`D14`    |
|4  |12     |         |`D8`     |
|4  |13     |         |`D9`     |
|4  |14     |         |         |
|4  |15     |         |         |
|4  |16     |         |         |

## 関数

### AVR

|関数                        |説明                                                                                                                                |
|----------------------------|------------------------------------------------------------------------------------------------------------------------------------|
|`analogReference(mode)`     |アナログの電圧リファレンスソースを設定する。`ADC_REF_EXTERNAL`、`ADC_REF_POWER`、`ADC_REF_INTERNAL` のいずれかでなければなりません。|
|`analogReadPin(pin)`        |指定されたピンから値を読み取ります。例えば、ATmega32U4 の ADC6 の場合 `F6`。                                                        |
|`pinToMux(pin)`             |指定されたピンを mux 値に変換します。サポートされていないピンが指定された場合、"0V (GND)" の mux 値を返します。                     |
|`adc_read(mux)`             |指定された mux に従って ADC から値を読み取ります。詳細は、MCU のデータシートを見てください。                                        |

### ARM

|関数                        |説明                                                                                                                                                                                                                                                                                    |
|----------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
|`analogReadPin(pin)`        |指定されたピンから値を読み取ります。STM32F0 では チャンネル 0 の `A0`、STM32F3 ではチャンネル 1 の ADC1。ピンを複数の ADC に使える場合は、この関数のために番号の小さい ADC が選択されることに注意してください。例えば、`C0` は、ADC2 にも使える場合、ADC1 のチャンネル 6 になります。 |
|`analogReadPinAdc(pin, adc)`|指定されたピンと ADC から値を読み取ります。例えば、`C0, 1` は、ADC1 ではなく ADC2 のチャンネル 6 から読み取ります。この関数では、ADC はインデックス 0 から始まることに注意してください。                                                                                              |
|`pinToMux(pin)`             |指定されたピンをチャンネルと ADC の組み合わせに変換します。サポートされていないピンが指定された場合、"0V (GND)" の mux 値を返します。                                                                                                                                                   |
|`adc_read(mux)`             |指定されたピンと ADC の組み合わせに応じて ADC から値を読み取ります。詳細は、MCU のデータシートを見てください。                                                                                                                                                                          |

## 設定

## ARM

ADC の ARM 実装には、独自のキーボードとキーマップでオーバーライドして動作方法を変更できる幾つかの追加オプションがあります。利用可能なオプションの詳細については、特定のマイクロコントローラについて ChibiOS の対応する `hal_adc_lld.h` を調べてください。

|`#define`            |型    |既定値               |説明                                                                                                                                                                                           |
|---------------------|------|---------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
|`ADC_CIRCULAR_BUFFER`|`bool`|`false`              |`true` の場合、この実装は循環バッファを使います。                                                                                                                                              |
|`ADC_NUM_CHANNELS`   |`int` |`1`                  |ADC 動作の一部としてスキャンされるチャンネル数を設定します。現在の実装は `1` のみをサポートします。                                                                                            |
|`ADC_BUFFER_DEPTH`   |`int` |`2`                  |各結果の深さを設定します。デフォルトでは12ビットの結果しか取得できないため、これを2バイトに設定して1つの値を含めることができます。8ビット以下の結果を選択した場合は、これを 1 に設定できます。 |
|`ADC_SAMPLING_RATE`  |`int` |`ADC_SMPR_SMP_1P5`   |ADC のサンプリングレートを設定します。デフォルトでは、最も速い設定に設定されています。                                                                                                         |
|`ADC_RESOLUTION`     |`int` |`ADC_CFGR1_RES_12BIT`|結果の分解能。デフォルトでは12ビットを選択しますが、12、10、8、6ビットを選択できます。                                                                                                         |
