# breaking changes/互換性を破る変更: プルリクエストにフラグが付けられた

<!---
  grep --no-filename "^[ ]*git diff" docs/ja/*.md | sh
  original document: 0.9.0:docs/breaking_changes_instructions.md
  git diff 0.9.0 HEAD -- docs/breaking_changes_instructions.md | cat
-->

QMK のメンバーがあなたのプルリクエストに返信し、あなたの提出したものは Breaking change (互換性を破る変更) であると述べている場合があります。メンバーの判断では、あなたが提案した変更は QMK やその利用者にとってより大きな影響を持つと考えられます。

プルリクエストにフラグが立てられる原因となるものには、以下のようなものがあります:

- **ユーザーのキーマップに対する編集**
  ユーザーが自分のキーマップを QMK に提出した後、しばらくしてさらに更新してプルリクエストを開いたところ、それが `qmk/qmk_firmware` リポジトリで編集されていたためにマージできなかったことに気づくことがあるかもしれません。すべてのユーザーが Git や GitHub を使いこなせるわけではないので、ユーザー自身で問題を修正できないことに気づくかもしれません。
- **期待される動作の変更**
  QMK の動作を変更すると、既存の QMK 機能への変更を組み込んだ新しいファームウェアをフラッシュした場合、ユーザはハードウェアまたは QMK が壊れていると考え、希望する動作を復元する手段がないことに気付くことがあります。
- **ユーザーのアクションを必要とする変更**
  変更には、ツールチェインを更新したり、Git で何らかのアクションを取るなど、ユーザーがアクションを行う必要がある場合もあります。
- **精査が必要な変更**
  時には、投稿がプロジェクトとしての QMK に影響を与えることもあります。これは、著作権やライセンスの問題、コーディング規約、大規模な機能のオーバーホール、コミュニティによるより広範なテストを必要とする「リスクの高い」変更、あるいは全く別のものである可能性があります。
- **エンドユーザーとのコミュニケーションを必要とする変更**
  これには、将来の非推奨化への警告、時代遅れの慣習、その他伝えなければならないが上記のカテゴリのどれかに当てはまらないものが含まれます。

## 何をすればいいのか?

提出したものが Breaking change だと判断された場合、手続きをスムーズに進めるためにできることがいくつかあります。

### PR を分割することを検討する

あなたがコアコードを投稿していて、それが Breaking change プロセスを経る必要がある唯一の理由が、あなたの変更に合わせてキーマップを更新していることである場合、古いキーマップが機能し続けるような方法であなたの機能を投稿できるかどうかを検討してください。
そののち、Breaking change プロセスを経て古いコードを削除する別の PR を提出してください。

### ChangeLog エントリの提供

Breaking change プロセスを経て提出する際には、変更ログのエントリを含めることを我々は要請します。
エントリーは、あなたのプルリクエストが行う変更の短い要約としてください &ndash; [ここの各セクションは changelog として開始されました](ja/ChangeLog/20190830.md "n.b. This should link to the 2019 Aug 30 Breaking Changes doc - @noroadsleft")。

変更ログは `docs/ChangeLog/YYYYMMDD/PR####.md` に置いてください。
ここで、`YYYYMMDD` は QMK の breaking change ブランチ &ndash; 通常は `develop` という名称 &ndash; が `master` ブランチにマージされる日付、`####` はプルリクエストの番号です。

ユーザー側でのアクションを必要とする場合、あなたの変更ログは、どのようなアクションを取らなければならないかをユーザーに指示するか、そのようなアクションを指示する場所にリンクする必要があります。

### 変更点を文書化する

提出物の目的を理解し、それが必要とする可能性のある意味合いやアクションを理解することで、レビュープロセスをより簡単にすることができます。この目的のためには変更履歴で十分かもしれませんが、より広範囲の変更を行う場合には、変更履歴には不向きな詳細レベルが必要になるかもしれません。

あなたのプルリクエストにコメントしたり、質問やコメント、変更要求に対応したりすることは、非常にありがたいことです。

### 助けを求める

あなたの提出物にフラグが立ったことで、あなたはびっくりしてしまったかもしれません。もし、あなた自身が脅されたり、圧倒されたりしていると感じたら、私たちに知らせてください。プルリクエストにコメントするか、[Discord で QMK チームに連絡を取ってください](https://discord.gg/Uq7gcHh)。
