# QMK Configurator: ステップ・バイ・ステップ

<!---
  grep --no-filename "^[ ]*git diff" docs/ja/*.md | sh
  original document: 0.9.0:docs/configurator_step_by_step.md
  git diff 0.9.0 HEAD -- docs/configurator_step_by_step.md | cat
-->

このページでは、QMK Configurator でファームウェアを構築する手順を説明します。

## ステップ 1: キーボードを選ぶ

ドロップダウンボックスをクリックして、キーマップを作成するキーボードを選択します。

?> **キーボードに複数のバージョンがある場合は、正しいバージョンを選択してください。**

大事なことなのでもう一度言います。

!> **正しいバージョンを選択してください!**

キーボードが QMK を搭載していると宣伝されていてもリストにない場合は、開発者がまだ作業中か、私たちがまだマージするきっかけがなかった可能性があります。
アクティブな [プルリクエスト](https://github.com/qmk/qmk_firmware/pulls?q=is%3Aopen+is%3Apr+label%3Akeyboard) がない場合、[qmk_firmware](https://github.com/qmk/qmk_firmware/issues)で報告して、その特定のキーボードのサポートをリクエストします。
製作者自身の GitHub アカウントにある QMK 搭載キーボードもあります。
それも再確認してください。

## ステップ2: キーボードのレイアウトを選択する

作成したいと思うキーマップに最も近いレイアウトを選択します。一部のキーボードには、まだ十分なレイアウトや正しいレイアウトが定義されていません。これらは将来サポートされる予定です。

## ステップ3: キーマップの名前を決める

お好みの名前をキーマップにつけます。

?> コンパイル時に問題が発生した場合は、もしかすると QMK ファームウェアリポジトリに既に同じ名前が存在しているのかもしれません。名前を変更してみてください。

## ステップ4: キーマップを定義する

キーコードの入力は、3つの方法のいずれかで行います。

1. ドラッグ・アンド・ドロップ
2. レイアウト上の空の場所をクリックして、希望するキーコードをクリックします
3. レイアウト上の空の場所をクリックして、キーボードの物理キーを押します

?> マウスをキーの上に置くと、そのキーコードの機能の短い説明文が出ます。より詳細な説明については以下を見てください:

* [基本的なキーコードリファレンス](ja/keycodes_basic.md)
* [高度なキーコードリファレンス](ja/feature_advanced_keycodes.md)

!> 選択したレイアウトが物理的なビルドと一致しない場合は、使用していないキーは空白のままにしておきます。どのキーが使用されているかわからない場合、例えば、バックスペースキーは1つだが `LAYOUT_all` には2つのキーがある場合は、同じキーコードを両方の場所に配置してください。

## ステップ5: 後日のためにキーマップを保存する

キーマップに満足するか、または後で作業したい場合は、`Export Keymap' ボタンを押します。
これでキーマップがあなたのコンピュータに保存されます。
その後、`Import Keymap` ボタンを押すことで、この .json ファイルを後で読み込むことができます。

!> **注意:** このファイルは、kbfirmware.com またはその他のツールに使用される .json ファイルと同じ形式ではありません。これらのツールにこの .json を使用したり、QMK Configurator でこれらのツールの .json を使用しようとすると、問題が発生します。

## ステップ6: ファームウェアをコンパイルする

緑色の `Compile` ボタンを押します。

コンパイルが完了すると、緑色の `Download Firmware` ボタンを押すことができます。

## 次のステップ: キーボードに書き込む(フラッシュする)

[ファームウェアを書きこむ](ja/newbs_flashing.md) を参照してください。
