# 自動シフト: なぜシフトキーが必要ですか？

<!---
  original document: 0.10.33:docs/feature_auto_shift.md
  git diff 0.10.33 HEAD -- docs/feature_auto_shift.md | cat
-->

キーをタップすると、その文字を取得します。キーをタップするが、*わずかに*長く押し続けると、シフト状態になります。ほら！シフトキーは必要ありません！

## なぜ自動シフトなのですか？

多くの人が腱鞘炎などの症状に苦しんでいます。一般的な原因は、指を繰り返し長い距離を伸ばすことです。私たちはキーボード上でシフトキーに手を伸ばすためにあまりにも頻繁に小指を伸ばします。自動シフトキーはそれを軽減しようとしています。

## どのように動作しますか？

キーをタップする時に、キーを放す前にほんの短い間押したままにします。この押したままにする時間は全ての人にとって異なる長さです。自動シフトは、定数 `AUTO_SHIFT_TIMEOUT` を定義し、これは普段の押された状態の時間の2倍に通常は設定されます。タイマーは、キーを押す時に開始され、キーを放す時に止まります。押された時間が `AUTO_SHIFT_TIMEOUT` 以上の場合に、キーのシフトバージョンが発行されます。時間が `AUTO_SHIFT_TIMEOUT` 時間よりも短い場合は、通常の状態が発行されます。

## 自動シフトには制限がありますか？

残念ながらあります。

1. キーリピートが動作しなくなります。例えば、20個の 'a' 文字が必要な場合、'a' キーを1、2秒押し続けるかもしれません。オペレーティングシステムに押されたキーの状態を発行する代わりに押された時間を計るので、自動シフトでは動作しません。
2. シフトをするつもりがない時にシフトされた文字を取得し、シフトしたい時にそうではない他の文字を取得するでしょう。これは結局は練習になります。急いでいる時は、シフトされたバージョンのために十分長くキーを押したと思うかもしれませんが、そうではありませんでした。一方、キーをタップしていると思うかもしれませんが、実際には予想よりも少し長い間押していました。

## どうやって自動シフトを有効にしますか？

キーマップフォルダの `rules.mk` に追加します:

    AUTO_SHIFT_ENABLE = yes

`rules.mk` が存在しない場合、それを作成することができます。

そして自動シフトキーを有効にした新しいファームウェアをコンパイルしてインストールします！以上です！

## モディファイア

デフォルトで、1つ以上のモディファイアと一緒にキーが押されると自動シフトは無効になります。従って、本当に長い間 Ctrl+A を保持しても、Ctrl+Shift+A と同じではありません。

`config.h` に定義を追加することで、モディファイアの自動シフトを再度有効にすることができます

```c
#define AUTO_SHIFT_MODIFIERS
```

この場合、`AUTO_SHIFT_TIMEOUT` を超えて押された Ctrl+A は Ctrl+Shift+A として送信されます


## 自動シフトの設定

必要に応じて、自動シフトの挙動を変更することができる幾つかの設定があります。キーマップフォルダにある `config.h` に様々な変数を設定することで行われます。`config.h` ファイルが存在しない場合、それを作成することができます。

例

```c
#pragma once

#define AUTO_SHIFT_TIMEOUT 150
#define NO_AUTO_SHIFT_SPECIAL
```

### AUTO_SHIFT_TIMEOUT (単位: ミリ秒)

これは、シフトされた状態を取得するためにどれだけ長くキーを押し続けなければならないかを制御します。
明らかにこれは人によって異なります。一般的な人にとって、135 から 150 の設定がうまく機能します。ただし、少なくとも 175 の値から開始する必要があります。これはデフォルト値です。その後、ここから下げていきます。間違って検出することなくシフトされた状態を取得するのに必要な、最も短い時間を得るという考え方です。

完璧に動作するまで、いろいろな値を試してみます。多くの人は、全てが所定の値で適切に動作するものの、時々、1つあるいは2つのキーがシフト状態を発行することが分かるでしょう。これは単に習慣と、幾つかのキーを他のキーよりも少し長く押し続けることによるものです。この値を見つけたら、問題のキーを通常よりも少し早くタップするとともに、その値を設定します。

?> 自動シフトには、この値を素早く取得するのに役立つ3つの特別なキーがあります。詳細は「自動シフトのセットアップ」を見てください！

### NO_AUTO_SHIFT_SPECIAL (単純にこのように定義します)

-\_, =+, [{, ]}, ;:, '", ,<, .> および /? を含む特殊キーを自動シフトしません

### NO_AUTO_SHIFT_NUMERIC (単純にこのように定義します)

0から9までの数字キーを自動シフトしません。

### NO_AUTO_SHIFT_ALPHA (単純にこのように定義します)

AからZを含むアルファベット文字を自動シフトしません。

## 自動シフトセットアップの使用

これにより、`AUTO_SHIFT_TIMEOUT` で設定している時間を一時的に増減させたり報告するために、3つのキーを定義することができます。

### セットアップ

3つのキーを一時的にキーマップにマップします:

| キー名 | 説明 |
|----------|-----------------------------------------------------|
| KC_ASDN | 自動シフトタイムアウト変数を下げる |
| KC_ASUP | 自動シフトタイムアウト変数を上げる |
| KC_ASRP | 現在の自動シフトタイムアウト値を報告する |
| KC_ASON | 自動シフト機能をオンにする |
| KC_ASOFF | 自動シフト機能をオフにする |
| KC_ASTG | 自動シフト機能の状態を切り替える |

新しいファームウェアをコンパイルしてアップロードします。

### 使い方

これらのテスト中は、完全に普段通り入力する必要があり、意図的にシフトされたキーを使わずに入力するように注意する必要があります。

1. アルファベットの複数の文を入力します。
2. 大文字に注意してください。
3. 大文字が存在しない場合は、自動シフトタイムアウト値を減らすために `KC_ASDN` にマップしたキーを押し、ステップ1に戻ります。
4. 大文字が幾つかある場合は、押す時間を短くしてこれらのキーをタップする必要があるか、あるいはタイムアウトを増やす必要があるかを決定します。
5. タイムアウトを増やすことに決めた場合は、`KC_ASUP` にマップしたキーを押し、ステップ1に戻ります。
6. 結果に満足したら、`KC_ASRP` にマップしたキーを押します。キーボードは `AUTO_SHIFT_TIMEOUT` の値を自動的に入力します。
7. 報告された値で `config.h` の `AUTO_SHIFT_TIMEOUT` を更新します。
8. `config.h` に `AUTO_SHIFT_NO_SETUP` を追加します。
9. `KC_ASDN`、`KC_ASUP` および `KC_ASRP` のキーバインディングを削除します。
10. 新しいファームウェアをコンパイルしてアップロードします。

#### 実行例

    hello world. my name is john doe. i am a computer programmer playing with
    keyboards right now.
    
     [KC_ASDN を何度か押します] 
    
    heLLo woRLd. mY nAMe is JOHn dOE. i AM A compUTeR proGRaMMER PlAYiNG witH
    KEYboArDS RiGHT NOw.
    
     [KC_ASUP を数回押します] 
    
    hello world. my name is john Doe. i am a computer programmer playing with
    keyboarDs right now.
    
     [KC_ASRPを押します] 
    
    115

キーボードは現在の `AUTO_SHIFT_TIMEOUT` 値を表す `115` を入力しました。これで設定が完了しました！テスト中に現れる *D* キーを少し練習してください。それで完璧です。
