# 動的マクロ: ランタイムでのマクロの記録および再生

<!---
  original document: 0.10.33:docs/feature_dynamic_macros.md
  git diff 0.10.33 HEAD -- docs/feature_dynamic_macros.md | cat
-->

QMK はその場で作られた一時的なマクロをサポートします。これらを動的マクロと呼びます。それらはユーザがキーボードから定義し、キーボードのプラグを抜くか再起動すると失われます。

1つまたは2つのマクロに合計128のキー押下を保存できます。RAM をより多く使用してサイズを増やすことができます。

有効にするには、最初に `rules.mk` に `DYNAMIC_MACRO_ENABLE = yes` を記述します。そして、以下のキーをキーマップに追加します:

| キー | Alias | 説明 |
|------------------|----------|---------------------------------------------------|
| `DYN_REC_START1` | `DM_REC1` | マクロ 1 の記録を開始します |
| `DYN_REC_START2` | `DM_REC2` | マクロ 2 の記録を開始します |
| `DYN_MACRO_PLAY1` | `DM_PLY1` | マクロ 1 を再生します |
| `DYN_MACRO_PLAY2` | `DM_PLY2` | マクロ 2 を再生します |
| `DYN_REC_STOP` | `DM_RSTP` | 現在記録中のマクロの記録を終了します。 |

これが必要な全てです。

マクロの記録を開始するには、`DYN_REC_START1` または `DYN_REC_START2` のどちらかを押します。

記録を終了するには、`DYN_REC_STOP` レイヤーボタンを押します。`DYN_REC_START1` または `DYN_REC_START2` をもう一度押すことでも記録を終了することができます。

マクロを再生するには、`DYN_MACRO_PLAY1` あるいは `DYN_MACRO_PLAY2` のどちらかを押します。

マクロの一部としてマクロを再生することができます。マクロ 1 を記録中にマクロ 2 を再生、またはその逆も問題ありません。ただし、再帰的なマクロ、つまりマクロ 1 を再生するマクロ 1 は作成しないでください。もしそうしてキーボードが反応しなくなった場合は、キーボードを取り外し再び接続します。これを完全に無効にするには、`config.h` ファイルで `DYNAMIC_MACRO_NO_NESTING`  を定義します。

?> 動的マクロの内部の詳細については、`process_dynamic_macro.h` および `process_dynamic_macro.c` ファイルのコメントを読んでください。

## カスタマイズ

ある程度のカスタマイズを可能にするオプションがいくつか追加されています。

| 定義 | デフォルト | 説明 |
|----------------------------|----------------|-----------------------------------------------------------------------------------------------------------------|
| `DYNAMIC_MACRO_SIZE` | 128 | 動的マクロが使用できるメモリ量を設定します。これは限られたリソースであり、コントローラに依存します。 |
| `DYNAMIC_MACRO_USER_CALL` | *定義なし* | これを定義すると、ユーザの `keymap.c` ファイルを使ってマクロが起動されます。 |
| `DYNAMIC_MACRO_NO_NESTING` | *定義なし* | これを定義すると、別のマクロからマクロを呼び出す(入れ子になったマクロ)機能を無効にします。 |
| `DYNAMIC_MACRO_DELAY` | *定義なし* | 各キーを送信する時の待ち時間（ms単位）を設定します。 |


記録中にキーを押すたびに LED が点滅し始めた場合は、マクロバッファにマクロを入れるスペースがもう無いことを意味します。マクロを入れるには、他のマクロ(それらは同じバッファを共有します)を短くするか、`config.h` に `DYNAMIC_MACRO_SIZE` 定義を追加することでバッファを増やします(デフォルト値: 128; ヘッダ内のコメントを読んでください)。


### DYNAMIC_MACRO_USER_CALL

以前のバージョンの動的マクロをお使いの方へ: 専用の `DYN_REC_STOP` キーを使わずに動的マクロキーへのアクセスに使われるレイヤーモディファイアのみを使って、マクロの記録を終了することもまだ可能です。この動作に戻したい場合は、`#define DYNAMIC_MACRO_USER_CALL` を `config.h` に追加し、以下のスニペットを `process_record_user()` 関数の先頭に記述します:

```c
	uint16_t macro_kc = (keycode == MO(_DYN) ? DYN_REC_STOP : keycode);

	if (!process_record_dynamic_macro(macro_kc, record)) {
		return false;
	}
```

### ユーザフック

カスタム機能とフィードバックオプションを動的マクロ機能に追加するために使うことができるフックが幾つかあります。これによりある程度のカスタマイズが可能になります。

direction がどのマクロであるかを示すことに注意してください。`1` がマクロ 1、`-1` がマクロ 2、0 がマクロ無しです。

* `dynamic_macro_record_start_user(void)` - マクロの記録を開始する時に起動されます。
* `dynamic_macro_play_user(int8_t direction)` - マクロを再生する時に起動されます。
* `dynamic_macro_record_key_user(int8_t direction, keyrecord_t *record)` - マクロの記録中に各キー押下で起動されます。
* `dynamic_macro_record_end_user(int8_t direction)` - マクロの記録を停止した時に起動されます。

さらに、動的マクロ機能が有効な場合にバックライトを点滅させるために `dynamic_macro_led_blink()` を呼び出すことができます。
