# キーロック

<!---
  original document: 0.8.134:docs/feature_key_lock.md
  git diff 0.8.134 HEAD -- docs/feature_key_lock.md | cat
-->

特定のキーを長時間押すことが必要になる場合があります。キーロックは次に押すキーを押したままにします。もう一度押すと、リリースされます。

いくつかの文を全て大文字で入力する必要があるとしましょう。`KC_LOCK` を押し、次にシフトを押します。これで、シフトは次にタップするまで押していると見なされます。キーロックを Caps Lock と考えることができますが、さらに強力です。

## 使用法

最初に `rules.mk` で `KEY_LOCK_ENABLE = yes` を設定することでキーロックを有効にします。次に、キーマップでキーを選択し、それをキーコード `KC_LOCK` に割り当てます。

## キーコード

| キーコード | 説明 |
|---------|--------------------------------------------------------------|
| `KC_LOCK` | キーが再び押されるまで次のキーを押したままにします。 |

## 注意事項

キーロックは、標準アクションキーと[ワンショットモディファイア](ja/one_shot_keys.md)キー (例えば、Shift を `OSM(MOD_LSFT)` と定義した場合)のみを押し続けることができます。
これは、QMK の特殊機能(ワンショットモディファイアを除く)、または `KC_LPRN` のような shift を押されたキーのバージョンは含みません。[基本的なキーコード](ja/keycodes_basic.md)リストにある場合、押したままにすることができます。

レイヤーの切り替えは、キーロックを解除しません。
