# 分割キーボード

<!---
  original document:0.10.8:docs/feature_split_keyboard.md
  git diff 0.10.8 HEAD -- docs/feature_split_keyboard.md | cat
-->

QMK ファームウェアリポジトリの多くのキーボードは、"分割"キーボードです。それらは2つのコントローラを使います — 1つは USB に接続し、もう1つは TRRS または同様のケーブルを介してシリアルまたは I<sup>2</sup>C 接続で接続します。

分割キーボードには多くの利点がありますが、有効にするには追加の作業が必要です。

QMK ファームウェアには、任意のキーボードで使用可能な一般的な実装と、多くのキーボード固有の実装があります。

このため、主に Let's Split とその他のキーボードで使われる一般的な実装について説明します。

!> ARM はまだ完全には分割キーボードをサポートしておらず、様々な制限があります。進捗はしていますが、機能の100%にはまだ達していません。


## 互換性の概要

| Transport | AVR | ARM |
|------------------------------|--------------------|--------------------|
| ['serial'](ja/serial_driver.md) | :heavy_check_mark: | :white_check_mark: <sup>1</sup> |
| I2C | :heavy_check_mark: |  |

注意:

1. ハードウェアとソフトウェアの両方の制限は、[ドライバーのドキュメント](ja/serial_driver.md)の中で説明されます。

## ハードウェア設定

2つの Pro Micro 互換のコントローラを使っており、キーボードの左右を接続するために TRRS ジャックを使っていることを前提とします。

### ハードウェア要件

左右それぞれのキーボードマトリックスのためのダイオードとスイッチとは別に、2個の TRRS ソケットと 1本の TRRS ケーブルが必要です。

あるいは、少なくとも3本のワイヤがあるケーブルとソケットを使うことができます。

キーボードの左右間で通信するために I<sup>2</sup>C を使いたい場合は、少なくとも4本のワイヤを備えたケーブルと 2個の 4.7kΩ プルアップ抵抗が必要です。

#### 考慮事項

最も一般的に使われる接続は、TRRS ケーブルとジャックです。これらは4本のワイヤを提供し、分割キーボードに非常に有用で、簡単に見つけることができます。

ただし、ワイヤのうちの1本が Vcc を供給するため、キーボードはホットプラグ不可能です。TRRS ケーブルを抜き差しする前に、必ずキーボードのUSB接続をはずす必要があります。そうしなければ、コントローラを短絡させたり、もっと悪いことが起こるかもしれません。

別のオプションは電話ケーブルを使うことです (例えば、旧式の RJ-11/RJ-14 ケーブル)。実際に4本のワイヤ/レーンをサポートするものを使うようにしてください。

ただし、USB ケーブル、SATA ケーブル、そして単に4本の電線でもコントローラ間の通信に使用できることがわかっています。

!> コントローラ間の通信に USB ケーブルを使っても問題ありませんが、コネクタは通常の USB 接続と間違えられるかもしれず、配線方法によってはキーボードが短絡する可能性があります。このため、分割キーボードの接続のためにはお勧めできません。

### シリアル配線

2つの Pro Micro 間で GND、Vcc、D0/D1/D2/D3 (別名 PD0/PD1/PD2/PD3) を TRS/TRRS ケーブルの3本のワイヤで接続します。

?> ここで使われるピンは実際には以下の `SOFT_SERIAL_PIN` によって設定されることに注意してください。

<img alt="sk-pd0-connection-mono" src="https://user-images.githubusercontent.com/2170248/92296488-28e9ad80-ef70-11ea-98be-c40cb48a0319.JPG" width="48%"/>
<img alt="sk-pd2-connection-mono" src="https://user-images.githubusercontent.com/2170248/92296490-2d15cb00-ef70-11ea-801f-5ace313013e6.JPG" width="48%"/>

### I<sup>2</sup>C 配線

2つの Pro Micro 間で GND、Vcc、さらに SCL と SDA (それぞれ 別名 PD0/ピン3 および PD1/ピン2) を TRRS ケーブルの4本のワイヤで接続します。

プルアップ抵抗はキーボードの左右どちら側にも配置することができます。もし各側を単独で使いたい場合は、4つの抵抗を使い、両側にプルアップ抵抗を配置することもできます。

<img alt="sk-i2c-connection-mono" src="https://user-images.githubusercontent.com/2170248/92297182-92b98580-ef77-11ea-9d7d-d6033914af43.JPG" width="50%"/>

## ファームウェア設定

分割キーボード機能を有効にするには、以下を `rules.mk` に追加してください:

```make
SPLIT_KEYBOARD = yes
```

カスタムトランスポート (通信メソッド)を使っている場合は、以下を追加する必要もあります:

```make
SPLIT_TRANSPORT = custom
```

### 左右の設定

デフォルトでは、ファームウェアはどちら側がどちらであるかを認識しません; 決定するには幾つかの助けが必要です。これを行うには幾つかの方法があり、以下に優先順に列挙します。

#### ピンによる左右の設定

左右を決定するためにコントローラ上のピンを読むようにファームウェアを設定することができます。これを行うには、以下を `config.h` ファイルに追加します:

```c
#define SPLIT_HAND_PIN B7
```

これは指定されたピンを読み込みます。high の場合、コントローラはそれを左側だと仮定し、low の場合、それは右側であると仮定します。

#### マトリックスピンによる左右の設定

左右を決定するためにコントローラのキーマトリックスピンを読むようにファームウェアを設定することができます。これを行うには、以下を `config.h` ファイルに追加します:

```c
#define SPLIT_HAND_MATRIX_GRID D0, F1
```

最初のピンは出力ピンで、2つ目は入力ピンです。

キーマトリックスに未使用の交点があるキーボードがあります。この設定は、左右の決定にこれらの未使用の交点の1つを使用します。

通常、ダイオードが交点に接続されている場合、左側と判断されます。次の定義を追加すると、右側と判断されます。

```c
#define SPLIT_HAND_MATRIX_GRID_LOW_IS_RIGHT
```

#### EEPROM による左右の設定

このメソッドは永続ストレージ(`EEPROM`)のフラグを設定することで、キーボードの左右を設定します。これはコントローラが最初に起動する時にチェックされ、キーボードのどちら側であるかとキーボードのレイアウトの向きを決定します。


このメソッドを有効にするには、以下を `config.h` ファイルに追加します:

```c
#define EE_HANDS
```

ただし、各コントローラに正しい側の EEPROM ファイルを書き込む必要があります。これを手動で行うこともできますが、ファームウェアを書き込む時にこれを行う avrdude および dfu のターゲットが存在します。

* `:avrdude-split-left`
* `:avrdude-split-right`
* `:dfu-split-left`
* `:dfu-split-right`
* `:dfu-util-split-left`
* `:dfu-util-split-right`

この設定は、`EEP_RST` キーや `eeconfig_init()` 関数を使って EEPROM を再初期化する時には変更されません。ただし、ファームウェアの組み込みオプション以外で EEPROM をリセット([QMK Toolbox]() の "Reset EEPROM" ボタンの動作のように、`EEPROM` を上書きするファイルを書きこむなど)した場合、`EEPROM` ファイルを再書き込みする必要があります。

`EEPROM` ファイルは、QMK ファームウェアのリポジトリ内の[ここ](https://github.com/qmk/qmk_firmware/tree/master/quantum/split_common)にあります。

#### `#define` による左右の設定

コンパイル時に左右を設定することができます。これは以下を `config.h` ファイルに追加することで行うことができます:

```c
#define MASTER_RIGHT
```

あるいは

```c
#define MASTER_LEFT
```

どちらも定義されていない場合、左右のデフォルトは `MASTER_LEFT` になります。


### 通信オプション

全ての分割キーボードが同一であるとは限らないため、`config.h` ファイル内で設定することができる多くの追加のオプションがあります。

```c
#define USE_I2C
```

これは分割キーボードの I<sup>2</sup>C サポートを有効にします。これは厳密には通信用ではありませんが、OLED あるいは I<sup>2</sup>C ベースのデバイスに使うことができます。

```c
#define SOFT_SERIAL_PIN D0
```

これはシリアル通信用に使われるピンを設定します。シリアルを使っていない場合は、これを定義する必要はありません。

ただし、キーボード上でシリアルおよび I<sup>2</sup>C を使っている場合は、これを設定し、D0 および D1 以外の値に設定する必要があります (これらは I<sup>2</sup>C 通信のために使われます)。

```c
#define SELECT_SOFT_SERIAL_SPEED {#}`
```

シリアル通信に問題がある場合は、この値を変更して、シリアル用の通信速度を制御することができます。デフォルトは1で、可能な値は以下の通りです:

* **`0`**: 約189kbps (実験用途専用)
* **`1`**: 約137kbps (デフォルト)
* **`2`**: 約75kbps
* **`3`**: 約39kbps
* **`4`**: 約26kbps
* **`5`**: 約20kbps

### ハードウェア設定オプション

ハードウェアのセットアップ方法に基づいて、設定する必要のある設定が幾つかあります。

```c
#define MATRIX_ROW_PINS_RIGHT { <row pins> }
#define MATRIX_COL_PINS_RIGHT { <col pins> }
```

これにより、右側のマトリックスに異なるピンのセットを指定することができます。これは、左右の形が違うキーボード (Keebio の Quefrency など)で、左右で別の構成が必要な場合に便利です。

```c
#define DIRECT_PINS_RIGHT { { F1, F0, B0, C7 }, { F4, F5, F6, F7 } }
```

これにより右側のための異なる直接ピンのセットを指定することができます。

```c
#define ENCODERS_PAD_A_RIGHT { encoder1a, encoder2a }
#define ENCODERS_PAD_B_RIGHT { encoder1b, encoder2b }
```

これにより右側のための異なるエンコーダピンのセットを指定することができます。

```c
#define RGBLIGHT_SPLIT
```

このオプションは、分割キーボードのコントローラ間で RGB ライトモードの同期を有効にします。これはコントローラに直接配線されている RGB LED を持つキーボード用です (つまり、それらは TRRS ケーブルで "追加データ"オプションを使っていません)。

```c
#define RGBLED_SPLIT { 6, 6 }
```

これは各コントローラに直接接続されている LED の数を設定します。最初の数は左側、2番目の数は右側です。

?> この設定は `RGBLIGHT_SPLIT` が有効になっていることを意味し、有効になっていない場合は強制的に有効にします。


```c
#define SPLIT_USB_DETECT
```
このオプションは、スタートアップの挙動を変更して、マスタ/スレーブの決定時にアクティブな USB 接続を検出します。このオプションがタイムアウトになった場合、その片側はスレーブと見なされます。これは ARM のデフォルトの挙動で、AVR Teensy ボードに必要です (ハードウェアの制限のため)。

?> この設定はバッテリパックを使ったデモの機能を停止します。

```c
#define SPLIT_USB_TIMEOUT 2000
```
これは、`SPLIT_USB_DETECT` を使う時のマスタ/スレーブを検出する場合の最大タイムアウトを設定します。

```c
#define SPLIT_USB_TIMEOUT_POLL 10
```
これは `SPLIT_USB_DETECT` を使う時のマスタ/スレーブを検出する場合のポーリング頻度を設定します

## 追加のリソース(英語)

Nicinabox には Let's Split キーボードのための[非常に優れた詳細なガイド](https://github.com/nicinabox/lets-split-guide)があり、トラブルシューティング情報を含む知っておくべきほとんど全てをカバーします。

ただし、RGB ライトセクションは、RGB Split コードが QMK ファームウェアに追加されるずっと前に書かれたため、古くなっています。ガイドに従う代わりに、各 LED テーブ(訳注: LED strip とも呼びます)を直接コントローラに配線します。

<!-- I may port this information later, but for now ... it's very nice, and covers everything -->
