# スワップハンドアクション

<!---
  original document: 0.13.17:docs/feature_swap_hands.md
  git diff 0.13.17 HEAD -- docs/feature_swap_hands.md | cat
-->

スワップハンドアクションにより、別のレイヤーを必要とせずに片手入力をサポートします。Makefile に `SWAP_HANDS_ENABLE` を設定し、キーマップに `hand_swap_config` エントリを定義します。これで `ACTION_SWAP_HANDS` コマンドキーが押されるたびにキーボードがミラーされます。例えば、QWERTY で "Hello, World" を入力するには、`^Ge^s^s^w^c W^wr^sd` を入力します。

## 設定

設定テーブルは列/行から新しい列/行にマップするための単純な2次元配列です。Planck の `hand_swap_config` の例:

```C
const keypos_t PROGMEM hand_swap_config[MATRIX_ROWS][MATRIX_COLS] = {
  {{11, 0}, {10, 0}, {9, 0}, {8, 0}, {7, 0}, {6, 0}, {5, 0}, {4, 0}, {3, 0}, {2, 0}, {1, 0}, {0, 0}},
  {{11, 1}, {10, 1}, {9, 1}, {8, 1}, {7, 1}, {6, 1}, {5, 1}, {4, 1}, {3, 1}, {2, 1}, {1, 1}, {0, 1}},
  {{11, 2}, {10, 2}, {9, 2}, {8, 2}, {7, 2}, {6, 2}, {5, 2}, {4, 2}, {3, 2}, {2, 2}, {1, 2}, {0, 2}},
  {{11, 3}, {10, 3}, {9, 3}, {8, 3}, {7, 3}, {6, 3}, {5, 3}, {4, 3}, {3, 3}, {2, 3}, {1, 3}, {0, 3}},
};
```

配列のインデックスはマトリックスと同様に逆になり、値の型は `{col, row}` である `keypos_t` で、全ての値はゼロベースであることに注意してください。上の例では、`hand_swap_config[2][4]` (第3行, 第5列)は `{7, 2}` (第3行, 第8列) を返します。はい。紛らわしいです。

## キーコードの入れ替え

| キー | 説明 |
|-----------|-------------------------------------------------------------------------|
| `SH_T(key)` | タップで `key` を送信する。押している時の一時的な入れ替え。 |
| `SH_ON` | 入れ替えをオンにして、そのままにする。 |
| `SH_OFF` | 入れ替えをオフにして、そのままにする。既知の状態に戻るのに適しています。 |
| `SH_MON` | 押すとスワップハンドし、放すと通常に戻る (一時的)。 |
| `SH_MOFF` | 一時的に入れ替えをオフする。 |
| `SH_TG` | キーを押すたびに入れ替えのオンとオフを切り替える。 |
| `SH_TT` | タップで切り替える。押されている時の一時的なもの。 |
| `SH_OS` | ワンショットスワップハンド: 押されている時あるいは次のキーを押すまで切り替える。 |
