#pragma once

#include "progmem.h"

#define FIRMWARE_LENGTH 3070

// clang-format off

const uint8_t firmware_data[FIRMWARE_LENGTH] PROGMEM = {
    0x03, 0xA6, 0x68, 0x1E, 0x7D, 0x10, 0x7E, 0x7E, 0x5F, 0x1C, 0xB8, 0xF2, 0x47, 0x0C, 0x7B, 0x74,
    0x4B, 0x14, 0x8B, 0x75, 0x66, 0x51, 0x0B, 0x8C, 0x76, 0x74, 0x4B, 0x14, 0xAA, 0xD6, 0x0F, 0x9C,
    0xBA, 0xF6, 0x6E, 0x3F, 0xDD, 0x38, 0xD5, 0x02, 0x80, 0x9B, 0x82, 0x6D, 0x58, 0x13, 0xA4, 0xAB,
    0xB5, 0xC9, 0x10, 0xA2, 0xC6, 0x0A, 0x7F, 0x5D, 0x19, 0x91, 0xA0, 0xA3, 0xCE, 0xEB, 0x3E, 0xC9,
    0xF1, 0x60, 0x42, 0xE7, 0x4C, 0xFB, 0x74, 0x6A, 0x56, 0x2E, 0xBF, 0xDD, 0x38, 0xD3, 0x05, 0x88,
    0x92, 0xA6, 0xCE, 0xFF, 0x5D, 0x38, 0xD1, 0xCF, 0xEF, 0x58, 0xCB, 0x65, 0x48, 0xF0, 0x35, 0x85,
    0xA9, 0xB2, 0x8F, 0x5E, 0xF3, 0x80, 0x94, 0x97, 0x7E, 0x75, 0x97, 0x87, 0x73, 0x13, 0xB0, 0x8A,
    0x69, 0xD4, 0x0A, 0xDE, 0xC1, 0x79, 0x59, 0x36, 0xDB, 0x9D, 0xD6, 0xB8, 0x15, 0x6F, 0xCE, 0x3C,
    0x72, 0x32, 0x45, 0x88, 0xDF, 0x6C, 0xA5, 0x6D, 0xE8, 0x76, 0x96, 0x14, 0x74, 0x20, 0xDC, 0xF4,
    0xFA, 0x37, 0x6A, 0x27, 0x32, 0xE3, 0x29, 0xBF, 0xC4, 0xC7, 0x06, 0x9D, 0x58, 0xE7, 0x87, 0x7C,
    0x2E, 0x9F, 0x6E, 0x49, 0x07, 0x5D, 0x23, 0x64, 0x54, 0x83, 0x6E, 0xCB, 0xB7, 0x77, 0xF7, 0x2B,
    0x6E, 0x0F, 0x2E, 0x66, 0x12, 0x60, 0x55, 0x65, 0xFC, 0x43, 0xB3, 0x58, 0x73, 0x5B, 0xE8, 0x67,
    0x04, 0x43, 0x02, 0xDE, 0xB3, 0x89, 0xA0, 0x6D, 0x3A, 0x27, 0x79, 0x64, 0x5B, 0x0C, 0x16, 0x9E,
    0x66, 0xB1, 0x8B, 0x87, 0x0C, 0x5D, 0xF2, 0xB6, 0x3D, 0x71, 0xDF, 0x42, 0x03, 0x8A, 0x06, 0x8D,
    0xEF, 0x1D, 0xA8, 0x96, 0x5C, 0xED, 0x31, 0x61, 0x5C, 0xA1, 0x34, 0xF6, 0x8C, 0x08, 0x60, 0x33,
    0x07, 0x00, 0x3E, 0x79, 0x95, 0x1B, 0x43, 0x7F, 0xFE, 0xB6, 0xA6, 0xD4, 0x9D, 0x76, 0x72, 0xBF,
    0xAD, 0xC0, 0x15, 0xE8, 0x37, 0x31, 0xA3, 0x72, 0x63, 0x52, 0x1D, 0x1C, 0x5D, 0x51, 0x1B, 0xE1,
    0xA9, 0xED, 0x60, 0x32, 0x3E, 0xA9, 0x50, 0x28, 0x53, 0x06, 0x59, 0xE2, 0xFC, 0xE7, 0x02, 0x64,
    0x39, 0x21, 0x56, 0x4A, 0xA5, 0x40, 0x80, 0x81, 0xD5, 0x5A, 0x60, 0x7B, 0x68, 0x84, 0xF1, 0xE0,
    0xB1, 0xB6, 0x5B, 0xDF, 0xA8, 0x1D, 0x6D, 0x65, 0x20, 0xC0, 0xA2, 0xB9, 0xD9, 0xBB, 0x00, 0xA6,
    0xDB, 0x8B, 0x01, 0x53, 0x91, 0xFE, 0xC4, 0x51, 0x85, 0xB0, 0x96, 0x7F, 0xFD, 0x51, 0xDD, 0x14,
    0x03, 0x67, 0x2E, 0x75, 0x1C, 0x76, 0xD3, 0x6E, 0xDD, 0x99, 0x55, 0x76, 0xE5, 0xAB, 0x23, 0xFC,
    0x4A, 0xD5, 0xC6, 0xE8, 0x2E, 0xCA, 0x8A, 0xB3, 0xF6, 0x8C, 0x6C, 0xB0, 0xE9, 0xF2, 0xE7, 0x9E,
    0x69, 0x41, 0xED, 0xF1, 0x6D, 0xD2, 0x86, 0xD8, 0x7E, 0xCB, 0x5D, 0x47, 0x6C, 0x85, 0x6A, 0x23,
    0xED, 0x20, 0x40, 0x93, 0xB4, 0x20, 0xC7, 0xA5, 0xC9, 0xAF, 0x03, 0x15, 0xAC, 0x19, 0xE5, 0x2A,
    0x36, 0xDF, 0x6D, 0xC5, 0x8C, 0x80, 0x07, 0xCE, 0x92, 0x0C, 0xD8, 0x06, 0x62, 0x0F, 0xDD, 0x48,
    0x46, 0x1A, 0x53, 0xC7, 0x8A, 0x8C, 0x5D, 0x5D, 0xB4, 0xA1, 0x02, 0xD3, 0xA9, 0xB8, 0xF3, 0x94,
    0x8F, 0x3F, 0xE5, 0x54, 0xD4, 0x11, 0x65, 0xB2, 0x5E, 0x09, 0x0B, 0x81, 0xE3, 0x75, 0xA7, 0x89,
    0x81, 0x39, 0x6C, 0x46, 0xF6, 0x06, 0x9F, 0x27, 0x3B, 0xB6, 0x2D, 0x5F, 0x1D, 0x4B, 0xD4, 0x7B,
    0x1D, 0x61, 0x74, 0x89, 0xE4, 0xE3, 0xBD, 0x98, 0x1B, 0xC4, 0x51, 0x3B, 0xA4, 0xFA, 0xE0, 0x92,
    0xF7, 0xBE, 0xF2, 0x4D, 0xBB, 0xFF, 0xAD, 0x4F, 0x6D, 0x68, 0xC2, 0x79, 0x40, 0xAA, 0x9B, 0x8F,
    0x0C, 0x32, 0x4B, 0x5F, 0x3E, 0xAB, 0x59, 0x98, 0xB3, 0xF5, 0x1D, 0xAC, 0x5E, 0xBC, 0x78, 0xD3,
    0x01, 0x6C, 0x64, 0x15, 0x2F, 0xD8, 0x71, 0xA6, 0x2D, 0x45, 0xE1, 0x22, 0x42, 0xE4, 0x4E, 0x04,
    0x3C, 0x7D, 0xF4, 0x40, 0x21, 0xB4, 0x67, 0x05, 0xA8, 0xE2, 0xF3, 0x72, 0x87, 0x4C, 0x7D, 0xD9,
    0x1B, 0x65, 0x97, 0xF3, 0xC2, 0xE3, 0xE4, 0xC8, 0xD2, 0xDE, 0xF6, 0xEF, 0xDC, 0xBB, 0x44, 0x08,
    0x5E, 0xE2, 0x45, 0x27, 0x01, 0xB0, 0xF6, 0x43, 0xE7, 0x3A, 0xF6, 0xDC, 0x9D, 0xED, 0xF3, 0xC5,
    0x0C, 0xB8, 0x9C, 0x98, 0x3A, 0xD8, 0x36, 0xEE, 0x96, 0x72, 0x67, 0xE7, 0x81, 0x91, 0xD5, 0x05,
    0x0A, 0xE0, 0x82, 0xD5, 0x8F, 0xE8, 0xF9, 0xB0, 0xC9, 0xCF, 0x93, 0xE7, 0x04, 0xC5, 0xBC, 0x2B,
    0x43, 0x56, 0x7E, 0xE8, 0x67, 0x7C, 0xE5, 0xFB, 0x49, 0xAD, 0x5E, 0x9F, 0x25, 0x13, 0xDE, 0x6E,
    0x6E, 0xE9, 0xF1, 0xEC, 0x87, 0x0B, 0x59, 0x81, 0x76, 0x84, 0x76, 0xB3, 0x24, 0xAF, 0x30, 0xFD,
    0x27, 0x8B, 0xAB, 0xD8, 0x00, 0x8B, 0x9B, 0x0C, 0xD2, 0xB2, 0x4E, 0x5E, 0x9D, 0x1D, 0x96, 0x01,
    0x00, 0x67, 0xC1, 0x5F, 0x02, 0x20, 0xFD, 0x45, 0x6A, 0x01, 0x60, 0x58, 0x45, 0xCA, 0x47, 0x21,
    0x90, 0x5A, 0xC4, 0x43, 0x26, 0x1A, 0xD7, 0xA5, 0x4A, 0xB2, 0x5D, 0x2B, 0x35, 0x49, 0xFB, 0xA5,
    0x17, 0x92, 0x21, 0x1E, 0x93, 0x96, 0x67, 0xA2, 0x7E, 0x36, 0x7A, 0xDE, 0x5F, 0xBE, 0x7A, 0x58,
    0x9D, 0xF8, 0x78, 0xA3, 0xFA, 0xC8, 0xD5, 0x17, 0xF0, 0x21, 0x97, 0x8C, 0x80, 0xB5, 0x4B, 0x3B,
    0xBD, 0xBB, 0x41, 0x21, 0xA8, 0x50, 0x67, 0xF7, 0xE7, 0x19, 0x80, 0x10, 0x8E, 0xCE, 0x04, 0x18,
    0x3F, 0x51, 0x6B, 0x77, 0xD8, 0x9E, 0x16, 0xAF, 0xEC, 0xEF, 0x48, 0x16, 0x4D, 0x9E, 0x85, 0x38,
    0x18, 0x3E, 0xD4, 0x28, 0x87, 0x60, 0x2A, 0xF6, 0x7F, 0x09, 0x86, 0x6F, 0x9C, 0x3C, 0x3A, 0xFF,
    0xAB, 0xD0, 0x61, 0xA2, 0x97, 0x0D, 0x71, 0x94, 0x7E, 0xFD, 0xB9, 0x80, 0x02, 0x89, 0x6A, 0xB3,
    0x84, 0x6C, 0x2A, 0x77, 0x62, 0xBE, 0x0B, 0xF4, 0xAF, 0xAC, 0x7B, 0x7C, 0x8E, 0xCA, 0x01, 0xBA,
    0x71, 0x78, 0x94, 0xFD, 0xB5, 0x39, 0xA4, 0x4D, 0x2F, 0x78, 0xCF, 0xCA, 0x92, 0x0C, 0x1A, 0x99,
    0x48, 0x4C, 0x11, 0x96, 0xB5, 0x4E, 0x41, 0x28, 0xE4, 0xA6, 0xFE, 0x4B, 0x72, 0x91, 0xE7, 0xD4,
    0xDD, 0x9F, 0x12, 0xE6, 0x29, 0x38, 0xCE, 0x45, 0xAE, 0x02, 0xB8, 0x24, 0xAE, 0xBD, 0xE9, 0x66,
    0x08, 0x62, 0xA2, 0x2C, 0x2B, 0x00, 0xE2, 0x23, 0xD9, 0xC4, 0x48, 0xE4, 0xD3, 0xAC, 0xBB, 0x34,
    0xC7, 0xF0, 0xE3, 0x4F, 0xB9, 0x30, 0xEA, 0xA2, 0x12, 0xF1, 0x30, 0x2C, 0x36, 0xDE, 0x48, 0xF2,
    0xB0, 0x4C, 0x43, 0x3F, 0x2E, 0x58, 0xE4, 0x20, 0xE3, 0x58, 0xCD, 0x31, 0x22, 0xF0, 0xA2, 0x2A,
    0xE6, 0x19, 0x90, 0x55, 0x86, 0xF6, 0x55, 0x79, 0xD1, 0xD7, 0x46, 0x2F, 0xC0, 0xDC, 0x99, 0xE8,
    0xF3, 0x6A, 0xDF, 0x7F, 0xEB, 0x24, 0x4A, 0x1E, 0x5A, 0x75, 0xDE, 0x2F, 0x5C, 0x19, 0x61, 0x03,
    0x53, 0x54, 0x6A, 0x3B, 0x18, 0x70, 0xB6, 0x4F, 0xF1, 0x9C, 0x0A, 0x59, 0x9D, 0x19, 0x92, 0x65,
    0x8C, 0x83, 0x14, 0x2D, 0x44, 0x8A, 0x75, 0xA9, 0xF5, 0x90, 0xD2, 0x66, 0x4E, 0xFA, 0x69, 0x0F,
    0x5B, 0x0B, 0x98, 0x65, 0xC8, 0x11, 0x42, 0x59, 0x7F, 0xDD, 0x1B, 0x75, 0x17, 0x31, 0x4C, 0x75,
    0x58, 0xEB, 0x58, 0x63, 0x7D, 0xF2, 0xA6, 0xC2, 0x6E, 0xB7, 0x3F, 0x3E, 0x5E, 0x47, 0xAD, 0xB7,
    0x04, 0xE8, 0x05, 0xF8, 0xB2, 0xCF, 0x19, 0xF3, 0xD2, 0x85, 0xFE, 0x3E, 0x3E, 0xB1, 0x62, 0x08,
    0x2C, 0x10, 0x07, 0x0D, 0x73, 0x90, 0x17, 0xFA, 0x9B, 0x56, 0x02, 0x75, 0xF9, 0x51, 0xE0, 0xE9,
    0x1A, 0x7B, 0x9F, 0xB3, 0xF3, 0x98, 0xB8, 0x1C, 0x9C, 0xE1, 0xD5, 0x35, 0xAE, 0xC8, 0x60, 0x48,
    0x11, 0x09, 0x94, 0x6B, 0xD0, 0x8B, 0x15, 0xBC, 0x05, 0x68, 0xD3, 0x54, 0x8A, 0x51, 0x39, 0x5C,
    0x42, 0x76, 0xCE, 0xD8, 0xAD, 0x89, 0x30, 0xC9, 0x05, 0x1C, 0xCC, 0x94, 0x3F, 0x0F, 0x90, 0x6F,
    0x72, 0x2D, 0x85, 0x64, 0x9A, 0xB9, 0x23, 0xF9, 0x0B, 0xC3, 0x7C, 0x39, 0x0F, 0x97, 0x07, 0x97,
    0xDA, 0x58, 0x48, 0x33, 0x05, 0x23, 0xB8, 0x82, 0xE8, 0xD3, 0x53, 0x89, 0xAF, 0x33, 0x80, 0x22,
    0x84, 0x0C, 0x95, 0x5C, 0x67, 0xB8, 0x77, 0x0C, 0x5C, 0xA2, 0x5F, 0x3D, 0x58, 0x0F, 0x27, 0xF3,
    0x2F, 0xAE, 0x48, 0xBD, 0x0B, 0x6F, 0x54, 0xFB, 0x67, 0x4C, 0xEA, 0x32, 0x27, 0xF1, 0xFA, 0xE2,
    0xB0, 0xEC, 0x0B, 0x15, 0xB4, 0x70, 0xF6, 0x5C, 0xDD, 0x71, 0x60, 0xC3, 0xC1, 0xA8, 0x32, 0x65,
    0xAC, 0x7A, 0x77, 0x41, 0xE5, 0xA9, 0x6B, 0x11, 0x81, 0xFA, 0x34, 0x8D, 0xFB, 0xC1, 0x80, 0x6E,
    0xC4, 0x60, 0x30, 0x07, 0xD4, 0x8B, 0x67, 0xBD, 0xAA, 0x8C, 0x9C, 0x64, 0xAC, 0xDB, 0x0B, 0x24,
    0x8B, 0x63, 0x6F, 0xE6, 0xBC, 0xE7, 0x33, 0xA4, 0x4A, 0x4C, 0xA7, 0x9F, 0x43, 0x53, 0xD2, 0xBB,
    0x8F, 0x43, 0xC7, 0x3D, 0x78, 0x68, 0x3F, 0xA5, 0x3D, 0xCA, 0x69, 0x84, 0xA6, 0x97, 0x2D, 0xC0,
    0x7D, 0x31, 0x34, 0x55, 0x1D, 0x07, 0xB1, 0x5F, 0x40, 0x5C, 0x93, 0xB0, 0xBC, 0x7C, 0xB0, 0xBC,
    0xE7, 0x12, 0xEE, 0x6B, 0x2B, 0xD3, 0x4D, 0x67, 0x70, 0x3A, 0x9A, 0xF2, 0x3C, 0x7C, 0x81, 0xFA,
    0xD7, 0xD9, 0x90, 0x91, 0x81, 0xB8, 0xB1, 0xF3, 0x48, 0x6A, 0x26, 0x4F, 0x0C, 0xCE, 0xB0, 0x9E,
    0xFD, 0x4A, 0x3A, 0xAF, 0xAC, 0x5B, 0x3F, 0xBF, 0x44, 0x5A, 0xA3, 0x19, 0x1E, 0x4B, 0xE7, 0x36,
    0x6A, 0xD7, 0x20, 0xAE, 0xD7, 0x7D, 0x3B, 0xE7, 0xFF, 0x3A, 0x86, 0x2E, 0xD0, 0x4A, 0x3E, 0xAF,
    0x9F, 0x8E, 0x01, 0xBF, 0xF8, 0x4F, 0xC1, 0xE8, 0x6F, 0x74, 0xE1, 0x45, 0xD3, 0xF7, 0x04, 0x6A,
    0x4B, 0x9D, 0xEC, 0x33, 0x27, 0x76, 0xD7, 0xC5, 0xE1, 0xB0, 0x3B, 0x0E, 0x23, 0xEC, 0xF0, 0x86,
    0xD2, 0x1A, 0xBF, 0x3D, 0x04, 0x62, 0xB3, 0x6C, 0xB2, 0xEB, 0x17, 0x05, 0xA6, 0x0A, 0x8A, 0x7E,
    0x83, 0x1C, 0xB6, 0x37, 0x09, 0xC6, 0x0B, 0x70, 0x3C, 0xB5, 0x93, 0x81, 0xD8, 0x93, 0xA0, 0x5F,
    0x1E, 0x08, 0xE2, 0xC6, 0xE5, 0xC9, 0x72, 0xF1, 0xF1, 0xC1, 0xED, 0xD5, 0x58, 0x93, 0x83, 0xF8,
    0x65, 0x67, 0x2E, 0x0D, 0xA9, 0xF1, 0x64, 0x12, 0xE6, 0x4C, 0xEA, 0x15, 0x3F, 0x8C, 0x1A, 0xB6,
    0xBF, 0xF6, 0xB9, 0x52, 0x35, 0x09, 0xB0, 0xE6, 0xF7, 0xCD, 0xF1, 0xA5, 0xAA, 0x81, 0xD1, 0x81,
    0x6F, 0xB4, 0xA9, 0x66, 0x1F, 0xFC, 0x48, 0xC0, 0xB6, 0xD1, 0x8B, 0x06, 0x2F, 0xF6, 0xEF, 0x1F,
    0x0A, 0xE6, 0xCE, 0x3A, 0x4A, 0x55, 0xBF, 0x6D, 0xF9, 0x4D, 0xD4, 0x08, 0x45, 0x4B, 0xC3, 0x66,
    0x19, 0x92, 0x10, 0xE1, 0x17, 0x8E, 0x28, 0x91, 0x16, 0xBF, 0x3C, 0xEE, 0xA3, 0xA6, 0x99, 0x92,
    0x10, 0xE1, 0xF6, 0xCC, 0xAC, 0xB8, 0x65, 0x0B, 0x43, 0x66, 0xF8, 0xE3, 0xE5, 0x3F, 0x24, 0x89,
    0x47, 0x5D, 0x78, 0x43, 0xD0, 0x61, 0x17, 0xBD, 0x5B, 0x64, 0x54, 0x08, 0x45, 0x59, 0x93, 0xF6,
    0x95, 0x8A, 0x41, 0x51, 0x62, 0x4B, 0x51, 0x02, 0x30, 0x73, 0xC7, 0x87, 0xC5, 0x4B, 0xA2, 0x97,
    0x0F, 0xE8, 0x46, 0x5F, 0x7E, 0x2A, 0xE1, 0x30, 0x20, 0xB0, 0xFA, 0xE7, 0xCE, 0x61, 0x42, 0x57,
    0x6E, 0x21, 0xF3, 0x7A, 0xEC, 0xE3, 0x25, 0xC7, 0x25, 0xF3, 0x67, 0xA7, 0x57, 0x40, 0x00, 0x02,
    0xCF, 0x1C, 0x80, 0x77, 0x67, 0xBD, 0x70, 0xA1, 0x19, 0x92, 0x31, 0x75, 0x93, 0x27, 0x27, 0xB6,
    0x82, 0xE4, 0xEB, 0x1D, 0x78, 0x48, 0xE7, 0xA5, 0x5E, 0x57, 0xEF, 0x64, 0x28, 0x64, 0x1B, 0xF6,
    0x11, 0xB2, 0x03, 0x9D, 0xB9, 0x18, 0x02, 0x27, 0xF7, 0xBE, 0x9D, 0x55, 0xFC, 0x00, 0xD2, 0xC7,
    0xAE, 0xAD, 0x0B, 0xC5, 0xE9, 0x42, 0x41, 0x48, 0xD8, 0x32, 0xCF, 0xF6, 0x0F, 0xF5, 0xBC, 0x97,
    0xC6, 0x99, 0x47, 0x76, 0xBD, 0x89, 0x06, 0x0F, 0x63, 0x0C, 0x51, 0xD4, 0x5E, 0xEA, 0x48, 0xA8,
    0xA2, 0x56, 0x1C, 0x79, 0x84, 0x86, 0x40, 0x88, 0x41, 0x76, 0x55, 0xFC, 0xC2, 0xD7, 0xFD, 0xC9,
    0xC7, 0x80, 0x61, 0x35, 0xA7, 0x43, 0x20, 0xF7, 0xEB, 0x6C, 0x66, 0x13, 0xB0, 0xEC, 0x02, 0x75,
    0x3E, 0x4B, 0xAF, 0xB9, 0x5D, 0x40, 0xDA, 0xD6, 0x6E, 0x2D, 0x39, 0x54, 0xC2, 0x95, 0x35, 0x54,
    0x25, 0x72, 0xE1, 0x78, 0xB8, 0xEB, 0xC1, 0x16, 0x58, 0x0F, 0x9C, 0x9B, 0xB4, 0xEA, 0x37, 0xEC,
    0x3B, 0x11, 0xBA, 0xD5, 0x8A, 0xA9, 0xE3, 0x98, 0x00, 0x51, 0x1C, 0x14, 0xE0, 0x40, 0x96, 0xE5,
    0xE9, 0xF2, 0x21, 0x22, 0xB1, 0x23, 0x60, 0x78, 0xD3, 0x17, 0xF8, 0x7A, 0xA5, 0xA8, 0xBA, 0x20,
    0xD3, 0x15, 0x1E, 0x32, 0xE4, 0x5E, 0x15, 0x48, 0xAE, 0xA9, 0xE5, 0xB8, 0x33, 0xEC, 0xE8, 0xA2,
    0x42, 0xAC, 0xBF, 0x10, 0x84, 0x53, 0x87, 0x19, 0xB4, 0x5F, 0x76, 0x4D, 0x01, 0x9D, 0x56, 0x74,
    0xD9, 0x5C, 0x97, 0xE7, 0x88, 0xEA, 0x3A, 0xBF, 0xDC, 0x4C, 0x33, 0x8A, 0x16, 0xB9, 0x5B, 0xFA,
    0xD8, 0x42, 0xA7, 0xBB, 0x3C, 0x04, 0x27, 0x78, 0x49, 0x81, 0x2A, 0x5A, 0x7D, 0x7C, 0x23, 0xA8,
    0xBA, 0xF7, 0x9A, 0x9F, 0xD2, 0x66, 0x3E, 0x38, 0x3C, 0x75, 0xF9, 0xD1, 0x30, 0x26, 0x30, 0x6E,
    0x5A, 0x6E, 0xDC, 0x6A, 0x69, 0x32, 0x50, 0x33, 0x47, 0x9E, 0xA4, 0xA8, 0x64, 0x66, 0xF0, 0x8A,
    0xE4, 0xFD, 0x27, 0x6F, 0x51, 0x25, 0x8B, 0x43, 0x74, 0xC9, 0x8E, 0xBD, 0x88, 0x31, 0xBE, 0xEC,
    0x65, 0xD2, 0xCB, 0x8D, 0x5A, 0x13, 0x48, 0x16, 0x8C, 0x61, 0x0B, 0x11, 0xF6, 0xC6, 0x66, 0xAE,
    0xC3, 0xCC, 0x0C, 0xD2, 0xE1, 0x9F, 0x82, 0x41, 0x3F, 0x56, 0xF9, 0x73, 0xEF, 0xDC, 0x30, 0x50,
    0xCF, 0xB6, 0x7F, 0xBC, 0xD0, 0xB3, 0x10, 0xAB, 0x24, 0xE4, 0xEC, 0xAD, 0x18, 0x8C, 0x39, 0x2D,
    0x30, 0x4C, 0xC5, 0x40, 0x0D, 0xF6, 0xAC, 0xD6, 0x18, 0x5D, 0x96, 0xBF, 0x5F, 0x71, 0x75, 0x96,
    0x22, 0x97, 0x0F, 0x02, 0x94, 0x6E, 0xA6, 0xAE, 0x6D, 0x8F, 0x1E, 0xCA, 0x12, 0x9B, 0x2A, 0x1C,
    0xCE, 0xA9, 0xEE, 0xFD, 0x12, 0x8E, 0xFC, 0xED, 0x09, 0x33, 0xBA, 0xF4, 0x1A, 0x15, 0xF6, 0x9D,
    0x87, 0x16, 0x43, 0x7C, 0x78, 0x57, 0xE1, 0x44, 0xC9, 0xEB, 0x1F, 0x58, 0x4D, 0xC1, 0x49, 0x11,
    0x5C, 0xB2, 0x11, 0xA8, 0x55, 0x16, 0xF1, 0xC6, 0x50, 0xE9, 0x87, 0x89, 0xF6, 0xCF, 0xD8, 0x9C,
    0x51, 0xA7, 0xBC, 0x5B, 0x31, 0x6D, 0x4D, 0x51, 0xD0, 0x4C, 0xBC, 0x0D, 0x58, 0x2D, 0x7B, 0x88,
    0x7A, 0xF9, 0x8E, 0xD6, 0x40, 0x4D, 0xBB, 0xBE, 0xC4, 0xE5, 0x07, 0xFC, 0xD9, 0x7B, 0x6D, 0xA6,
    0x42, 0x57, 0x8F, 0x02, 0x94, 0x4F, 0xE4, 0x2A, 0x65, 0xE2, 0x19, 0x5A, 0x50, 0xE1, 0x25, 0x65,
    0x4A, 0x60, 0xC2, 0xCD, 0xA8, 0xEC, 0x05, 0x2E, 0x87, 0x7B, 0x95, 0xB7, 0x4F, 0xA0, 0x0B, 0x1B,
    0x4A, 0x7F, 0x92, 0xC8, 0x90, 0xEE, 0x89, 0x1E, 0x10, 0xD2, 0x85, 0xE4, 0x9F, 0x63, 0xC8, 0x12,
    0xBB, 0x4E, 0xB8, 0xCF, 0x0A, 0xEC, 0x18, 0x4E, 0xE6, 0x7C, 0xB3, 0x33, 0x26, 0xC7, 0x1F, 0xD2,
    0x04, 0x23, 0xEA, 0x07, 0x0C, 0x5F, 0x90, 0xBD, 0xA7, 0x6A, 0x0F, 0x4A, 0xD6, 0x10, 0x01, 0x3C,
    0x12, 0x29, 0x2E, 0x96, 0xC0, 0x4D, 0xBB, 0xBE, 0xE5, 0xA7, 0x83, 0xD5, 0x6A, 0x3C, 0xE3, 0x5B,
    0xB8, 0xF2, 0x5C, 0x6D, 0x1F, 0xA6, 0xF3, 0x12, 0x24, 0xF6, 0xD6, 0x3B, 0x10, 0x14, 0x09, 0x07,
    0x82, 0xE8, 0x30, 0x6A, 0x99, 0xDC, 0x95, 0x01, 0x9C, 0xD4, 0x68, 0x3B, 0xCA, 0x98, 0x12, 0xAB,
    0x77, 0x25, 0x15, 0x7D, 0x10, 0x32, 0x45, 0x98, 0xCD, 0x7A, 0xDF, 0x71, 0x8A, 0x75, 0xC1, 0x1C,
    0xD4, 0x68, 0x25, 0xEB, 0xBB, 0x54, 0x27, 0x6F, 0x2A, 0xF7, 0xB9, 0x98, 0x03, 0x27, 0xDE, 0x24,
    0xA8, 0xBB, 0x98, 0xC2, 0x84, 0xFF, 0x9B, 0x51, 0xD8, 0x53, 0x50, 0xDA, 0xF5, 0x88, 0xAA, 0x87,
    0x2F, 0xAE, 0xD6, 0xEA, 0x6B, 0xDE, 0xC8, 0xD7, 0xA7, 0x28, 0x65, 0x81, 0xE8, 0xB2, 0x3B, 0x1D,
    0x4F, 0x75, 0x8F, 0x9F, 0x7A, 0x74, 0x8E, 0xC1, 0x5F, 0x9A, 0xA8, 0x9D, 0xFA, 0x03, 0xA3, 0x71,
    0x9B, 0x37, 0x6D, 0xD5, 0x0B, 0xF5, 0xE1, 0xA1, 0x1B, 0x01, 0x6A, 0xC6, 0x67, 0xAA, 0xEA, 0x2C,
    0x9D, 0xA4, 0xD2, 0x6E, 0xFC, 0xDE, 0x2E, 0x7F, 0x94, 0x69, 0xE5, 0x4A, 0xE0, 0x01, 0x48, 0x3C,
    0x6B, 0xF7, 0x1E, 0xB6, 0x0B, 0x5F, 0xF9, 0x2E, 0x07, 0xC5, 0xE8, 0xAE, 0x37, 0x1B, 0xBC, 0x3C,
    0xD8, 0xD5, 0x0B, 0x91, 0x9E, 0x80, 0x24, 0xF5, 0x06, 0x0C, 0x0E, 0x98, 0x07, 0x96, 0x2D, 0x19,
    0xDC, 0x58, 0x93, 0xCC, 0xFB, 0x4E, 0xEB, 0xBD, 0x0F, 0xF5, 0xAF, 0x01, 0xFA, 0xF1, 0x7C, 0x43,
    0x8C, 0xB8, 0x56, 0x3E, 0xBE, 0x77, 0x4E, 0x2B, 0xF7, 0xBB, 0xB7, 0x45, 0x47, 0xCD, 0xCC, 0xA6,
    0x4C, 0x72, 0x7B, 0x6A, 0x2A, 0x70, 0x13, 0x07, 0xFD, 0xB8, 0x9C, 0x98, 0x3A, 0xD8, 0x23, 0x67,
    0x5B, 0x34, 0xD5, 0x14, 0x0C, 0xAB, 0x77, 0x1F, 0xF8, 0x3D, 0x5A, 0x9F, 0x92, 0xB7, 0x2C, 0xAD,
    0x31, 0xDE, 0x61, 0x07, 0xB3, 0x6B, 0xF7, 0x38, 0x15, 0x95, 0x46, 0x14, 0x48, 0x53, 0x69, 0x52,
    0x66, 0x07, 0x6D, 0x83, 0x71, 0x8A, 0x67, 0x25, 0x20, 0x0F, 0xFE, 0xD7, 0x02, 0xD7, 0x6E, 0x2C,
    0xD2, 0x1A, 0x0A, 0x5D, 0xFD, 0x0F, 0x74, 0xE3, 0xA4, 0x36, 0x07, 0x9A, 0xDF, 0xD4, 0x79, 0xBF,
    0xEF, 0x59, 0xC0, 0x44, 0x52, 0x87, 0x9A, 0x6E, 0x1D, 0x0E, 0xEE, 0xDE, 0x2E, 0x1A, 0xA9, 0x8F,
    0x3A, 0xC9, 0xBA, 0xEC, 0x99, 0x78, 0x2D, 0x55, 0x6B, 0x14, 0xC2, 0x06, 0xD5, 0xFC, 0x93, 0x53,
    0x4D, 0x11, 0x8C, 0xF8, 0xFA, 0x79, 0x7C, 0xA6, 0x64, 0xAE, 0x61, 0xB8, 0x7B, 0x94, 0x56, 0xA6,
    0x39, 0x78, 0x9A, 0xE5, 0xC7, 0xDF, 0x18, 0x63, 0x23, 0x9C, 0xFA, 0x66, 0xBB, 0xB7, 0x5A, 0x27,
    0x4C, 0xD1, 0xA1, 0x83, 0x22, 0xB3, 0x52, 0x49, 0x35, 0xB0, 0x22, 0x83, 0x59, 0x12, 0x00, 0x16,
    0x98, 0xDD, 0xAD, 0xC2, 0x94, 0xF9, 0xD3, 0x7B, 0x64, 0x7F, 0x44, 0x3E, 0x3C, 0x8B, 0x9A, 0x83,
    0x9C, 0x69, 0x6B, 0xE4, 0xDF, 0x9F, 0xED, 0x54, 0x1F, 0xE5, 0x5D, 0x7A, 0x05, 0x82, 0xB3, 0xDD,
    0xEF, 0xFC, 0x53, 0x96, 0xB0, 0x2C, 0x5A, 0xF8, 0xDF, 0x9C, 0x8B, 0x16, 0x4E, 0xDF, 0xDA, 0x4D,
    0x09, 0x09, 0x69, 0x50, 0x03, 0x65, 0xD8, 0x73, 0x70, 0xE8, 0x86, 0xBF, 0xBB, 0x35, 0xCE, 0xB2,
    0x46, 0xCB, 0x02, 0x00, 0x5B, 0xB4, 0xE2, 0xC6, 0x8F, 0x2F, 0x98, 0xAF, 0x87, 0x4B, 0x48, 0x45,
    0xED, 0xCC, 0x1D, 0xE6, 0x58, 0xD6, 0xF2, 0x50, 0x25, 0x9F, 0x52, 0xC7, 0xCB, 0x8A, 0x17, 0x9D,
    0x5B, 0xE5, 0xC8, 0xD7, 0x72, 0xB7, 0x52, 0xB2, 0xC4, 0x98, 0xE3, 0x7A, 0x17, 0x3E, 0xC6, 0x60,
    0xA7, 0x97, 0xB0, 0xCF, 0x18, 0x81, 0x53, 0x84, 0x4C, 0xD5, 0x17, 0x32, 0x03, 0x13, 0x39, 0x51,
    0x09, 0x10, 0xE3, 0x77, 0x49, 0x4F, 0x62, 0x01, 0xBF, 0x8C, 0x9A, 0xE0, 0x41, 0x9E, 0x89, 0x74,
    0x36, 0xF9, 0x96, 0x86, 0x2E, 0x96, 0x1C, 0x4A, 0xB7, 0x2B, 0x4A, 0x97, 0xBC, 0x99, 0x40, 0xA3,
    0xE0, 0x3D, 0xC8, 0xAD, 0x2F, 0xDF, 0x4F, 0x2C, 0xC4, 0x69, 0x82, 0x9F, 0x9B, 0x81, 0x0C, 0x61,
    0x5C, 0xA5, 0x9D, 0x8C, 0x89, 0xC0, 0x2C, 0xB4, 0x4A, 0x33, 0x4E, 0xEB, 0xA2, 0x56, 0x40, 0xC0,
    0xC2, 0x46, 0xAF, 0x6A, 0xFC, 0x67, 0xD1, 0x80, 0x5E, 0xC5, 0x6D, 0x84, 0x43, 0x27, 0x3F, 0x55,
    0x15, 0x96, 0x6A, 0xA0, 0xA5, 0xDA, 0xB7, 0xFF, 0xB7, 0x75, 0x6E, 0x4C, 0x49, 0x91, 0x9D, 0x22,
    0xA3, 0x46, 0xEA, 0xED, 0x9A, 0x00, 0xE2, 0x32, 0xC3, 0xD6, 0xA9, 0x71, 0x20, 0x55, 0xA3, 0x19,
    0xED, 0xF8, 0x4F, 0xA7, 0x12, 0x9C, 0x66, 0x87, 0xAF, 0x4E, 0xB7, 0xF0, 0xDB, 0xBF, 0xEF, 0xF0,
    0xF6, 0xAF, 0xEA, 0xDA, 0x09, 0xFE, 0xDE, 0x38, 0x5C, 0xA5, 0xA2, 0xDF, 0x99, 0x45, 0xA8, 0xE4,
    0xE7, 0x92, 0xAC, 0x67, 0xAA, 0x4F, 0xBF, 0x77, 0x3E, 0xA2, 0x40, 0x49, 0x22, 0x4A, 0x1E, 0x3B,
    0xAA, 0x70, 0x7F, 0x95, 0xAF, 0x37, 0x4B, 0xFC, 0x99, 0xE2, 0xE0, 0xBA, 0xD7, 0x34, 0xCE, 0x55,
    0x88, 0x5B, 0x84, 0x1B, 0x57, 0xC4, 0x80, 0x03, 0x53, 0xC9, 0x2F, 0x93, 0x04, 0x4D, 0xD5, 0x96,
    0xE5, 0x70, 0xA6, 0x6E, 0x63, 0x5D, 0x9D, 0x6C, 0xDB, 0x02, 0x0A, 0xA9, 0xDA, 0x8B, 0x53, 0xDC,
    0xD9, 0x9A, 0xC5, 0x94, 0x2C, 0x91, 0x92, 0x2A, 0xDE, 0xBB, 0x8B, 0x13, 0xB9, 0x19, 0x96, 0x64,
    0xCC, 0xF2, 0x64, 0x39, 0xB7, 0x75, 0x49, 0xE9, 0x86, 0xC2, 0x86, 0x62, 0xD9, 0x24, 0xD3, 0x81,
    0x35, 0x49, 0xFC, 0xA0, 0xA5, 0xA0, 0x93, 0x05, 0x64, 0xB4, 0x1A, 0x57, 0xCE, 0x0C, 0x90, 0x02,
    0x27, 0xC5, 0x7A, 0x2B, 0x5D, 0xAE, 0x3E, 0xD5, 0xDD, 0x10, 0x7C, 0x14, 0xEA, 0x3A, 0x08, 0xAC,
    0x72, 0x4E, 0x90, 0x3D, 0x3B, 0x7C, 0x86, 0x2E, 0xEB, 0xD4, 0x06, 0x70, 0xE6, 0xC7, 0xFB, 0x5F,
    0xBD, 0x18, 0xF4, 0x11, 0xA4, 0x1A, 0x93, 0xC3, 0xBE, 0xD9, 0xFB, 0x26, 0x48, 0x2F, 0x37, 0x3C,
    0xD0, 0x03, 0x47, 0x1A, 0xF7, 0x62, 0x19, 0x24, 0x5C, 0xF4, 0xA8, 0x92, 0x20, 0x7A, 0xF2, 0x9E,
    0x2A, 0xC5, 0x95, 0xA2, 0xFB, 0xA4, 0xEA, 0x85, 0xD8, 0x56, 0xB7, 0x70, 0xD1, 0x60, 0x30, 0xA5,
    0x30, 0x82, 0x70, 0xDC, 0x7A, 0x65, 0x8A, 0x36, 0x3F, 0x5B, 0x0C, 0xAE, 0x54, 0x7C, 0xD3, 0x57,
    0x84, 0x7B, 0x3A, 0x65, 0x18, 0x81, 0xEE, 0x05, 0x9B, 0x44, 0x4D, 0xB8, 0xDA, 0xA2, 0xA1, 0xC9,
    0x15, 0xD3, 0x73, 0x03, 0x0E, 0x43, 0xE9, 0x8E, 0x15, 0xF9, 0xBE, 0xC6, 0xC5, 0x8A, 0xE5, 0xC0,
    0x1E, 0xC2, 0x37, 0x9E, 0x2A, 0x26, 0xA5, 0xA0, 0xBD, 0x24, 0x5F, 0xB9, 0xC1, 0xAB, 0x34, 0x48,
    0xB9, 0x5D, 0x98, 0xB4, 0x65, 0x18, 0xF3, 0x63, 0x19, 0x44, 0x1B, 0x11, 0x16, 0xFF, 0xDC, 0xF1,
    0x79, 0x08, 0x86, 0x0F, 0x52, 0x98, 0x73, 0xC4, 0x92, 0x90, 0x2B, 0x47, 0x09, 0xD0, 0x43, 0x6C,
    0x2F, 0x20, 0xEB, 0xDC, 0xDA, 0xC5, 0x08, 0x7B, 0x94, 0x42, 0x30, 0x6A, 0xC7, 0xDA, 0x8C, 0xC3,
    0x76, 0xA7, 0xA5, 0xCC, 0x62, 0x13, 0x00, 0x60, 0x31, 0x58, 0x44, 0x9B, 0xF5, 0x64, 0x14, 0xF5,
    0x11, 0xC5, 0x54, 0x52, 0x83, 0xD4, 0x73, 0x01, 0x16, 0x0E, 0xB3, 0x7A, 0x29, 0x69, 0x35, 0x56,
    0xD4, 0xEE, 0x8A, 0x17, 0xA2, 0x99, 0x24, 0x9C, 0xD7, 0x8F, 0xDB, 0x55, 0xB5, 0x3E
};
