Jetpacktuxedo's AMJ40 layout
=====================

This is based heavily on my minivan layout, with most difference stemming from the different widths between the minivan and the AMJ40. ![Image of my specific layout](https://i.imgur.com/B9XraJY.jpg)

## Base Layer (0)

The base layer is pretty simple, straight qwerty layout where available. Both spacebars go to layer 1 when held. `tab` is `tab` when pressed and `fn2` when held, `enter` is the same. `GESC` is `esc` when used alone, but `~` when shifted. `/` is `/` when tapped but `rshift` when held.
```
|GESC| Q  | W  | E  | R  | T  | Y  | U  | I  | O  | P  |BSPC|
| TAB | A  | S  | D  | F  | G  | H  | J  | K  | L  | ENTER  |
|LSHIFT | Z  | X  | C  | V  | B  | N  | M  | ,  | .  |  /   |
|LCTRL|LWIN|LALT |  SPACE   |    SPACE    |RALT |FN 3|RCTRL |
```

## Number Layer (1)

Numbers are set up just like on my minivan layout, but symbols are a bit different because the AMJ40 is one key narrower than the minivan and also lacks dedicated arrows. Decided to go with `hjkl` arrows, which takes some getting used to. `;` is on a layer now because of the narrowness I mentioned before, and it (along with `-`, `=`, and `'`) moves to the right hand to leave room for the `hjkl` arrows. `delete` on `backspace`, `[` and `]` on `<` and `>`, and `\` on `/` are all stolen straight from my minivan layout.
```
| `  | 1  | 2  | 3  | 4  | 5  | 6  | 7  | 8  | 9  | 0  |DEL |
|     | -  | =  | ;  | '  |    | ←  | ↓  | ↑  | →  |        |
|       |    |    |    |    |    |    |    | [  | ]  |  \   |
|     |    |     |          |             |     |    |      |
```

## Shifted Layer (2)

I don't want to be using two key combos constantly, so I also added this symbol layer that is basically shift+numeric layer. Also has nav keys on top of where arrows sit on the previous layer
```
| ~  | !  | @  | #  | $  | %  | ^  | &  | *  | (  | )  |DEL |
|     | _  | +  | :  | "  |    |HOME|PGDN|PGUP|END |        |
|       |    |    |    |    |    |    |    | {  | }  |  |   |
|     |    |     |          |             |     |    |      |
```

## Fkey Layer (3)

Honestly, I use this more for jumping to my gaming layer and for reset than I use it for Fkeys. Lol. Hitting the left windows key while in this layer locks the gaming layer listed below
```
|    | F1 | F2 | F3 | F4 | F5 | F6 | F7 | F8 | F9 |F10 |RSET|
|     |F11 |F12 |    |    |    |    |    |    |    |        |
|       |    |    |    |    |    |    |    |    |    |      |
|     |FN 4|     |          |             |     |    |      |
```

## "Gaming" Layer (4)

Based on the "gaming" layer on my minivan that I mostly just use for mouse keys. To toggle this back off you hit the right windows key (to go to layer 3) and then the left windows key again.
```
|ESC |    |    |    |    |    |MWUP|MLCK|M UP|MRCK|    |    |
| TAB |    |    |    |    |    |MWDN|M L |M DN|M R |        |
|       |    |    |    |    |    |    |    |    |    |      |
|     |    |     |  SPACE   |             |     |    |      |
```

