![German Gaming Layout Image](https://i.imgur.com/0y938rG.png)

Despite being less accurate, the columns in the image are shifted up and down to avoid the [Hermann grid illusion](https://en.wikipedia.org/wiki/Grid_illusion).
​

# German Gaming Layout
​
This layout was build with gaming in mind for a german user. As a result I added a "game" layer that shifts the keys of the left side (below the number row) one to the right, so that <kbd>WASD</kbd> is on the <kbd>ESDF</kbd> keys. The reason this layer was added is that using <kbd>WASD</kbd> is less comfortable with a contoured Dactyl-style keyboard, where each column is adjusted for the respective fingers. <kbd>ESDF</kbd> also has the upside of allowing one to stay in the home row. Note that the rightmost column of the default layer, so <kbd>TGB</kbd>, ends up in the leftmost position.

Of course, one could just be forced to reconfigure every game, but that wouldn't be very user-friendly and likely reduce satisfaction with the layout. When in game mode, the right side of keys also features arrow keys on <kbd>IJKL</kbd>.


## Raise and Lower layer

Additionally, via the RAISE layer, it's always possible to access the arrow keys, which are often used in game menues. On the exact same position one can access <kbd>Home</kbd>, <kbd>End</kbd>, <kbd>Page Down</kbd> and <kbd>Page Up</kbd> via the LOWER layer. The left side of the LOWER layer also contains the few characters that would usually have their own key in a traditional german keyboard.

The right side features various media keys in the RAISE layer, and a numpad in the LOWER layer.


## Firmware

The keyboard can be put into Reset mode (for flashing a keymap) by pressing <kbd>**LOWER**</kbd> + <kbd>Super</kbd> (also known as Windows key), or by pressing <kbd>**LOWER**</kbd> + <kbd>**RAISE**</kbd> + <kbd>R</kbd>.

`MOUSEKEY_ENABLE` was set to `no` for this keymap, since it wasn't used and the size of the firmware ended up being too large.
