# Boardrun Bizarre

![Boardrun Bizarre](https://i.imgur.com/usKQUWI.jpg)

The Boardrun is a family of ortholinear keyboards with columnar stagger, inspired by the Alice layout. The Classic is a 60% layout that uses Ergodox keycap sets for compatibility, whereas the Bizarre is a 65% layout that uses standard (staggered) keycap sets in an ortholinear arrangement.

The Boardrun is an evolution of the Boardwalk layout. The Boardwalk proved that the Ergodox keycap set could be adapted to more keyboards that provided a more compact design and layout flexibility. While adaptation was a design goal of the Boardwalk layout, the Boardrun was designed to distill and refine the best aspects of the current state of keyboard layouts, taking into account current trends in staggered design, the Ergodox keycap layout, and the Boardwalk's most popular layouts. To that end, a columnar staggered, ortholinear layout with alpha rotation was settled on, using the "HHKB" layout from the Boardwalk. The result is two layouts that are comfortable, familiar, and have great compatibility with keysets.

-   Keyboard Maintainer: QMK Community
-   Hardware Supported: Boardrun Bizarre Ortholinear PCB
-   Hardware Availability: mkultra.click

Make example for this keyboard (after setting up your build environment):

    make boardrun/bizarre:default
    
Flashing example for this keyboard:

    make boardrun/bizarre:default:flash
    
The board may be reset into bootloader mode via either the reset button (on the bottom of the PCB) or a configured `QK_BOOT` shortcut (which may vary depending on when the PCB was flashed).

See the [build environment setup](https://docs.qmk.fm/#/getting_started_build_tools) and the [make instructions](https://docs.qmk.fm/#/getting_started_make_guide) for more information. Brand new to QMK? Start with our [Complete Newbs Guide](https://docs.qmk.fm/#/newbs).
