/* Copyright 2022 boardsource
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include QMK_KEYBOARD_H

const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {
    [0] = LAYOUT_ortho_2x3(
        RGB_TOG, KC_1, KC_2,
        RGB_MOD, KC_3,KC_4
    )
};

#ifdef OLED_ENABLE
oled_rotation_t oled_init_user(oled_rotation_t rotation) {
    return OLED_ROTATION_180;
}

static void render_RIP(void) {
  static const char PROGMEM my_logo[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x08, 0x04,
    0x04, 0x7c, 0xfc, 0xf0, 0x00, 0x00, 0x40, 0x20, 0xf0, 0x7c, 0x06, 0x00, 0x41, 0xc0, 0x00, 0x00,
    0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0xc0, 0x00,
    0x00, 0x00, 0xe0, 0x60, 0x00, 0x80, 0x40, 0x20, 0x20, 0xe0, 0x00, 0x00, 0x00, 0xf0, 0x3c, 0x02,
    0x01, 0xc1, 0xf8, 0x0e, 0x00, 0x01, 0xc0, 0x00, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0xf0, 0x50, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x08,
    0x03, 0x00, 0x00, 0x0f, 0x06, 0x01, 0x00, 0x1e, 0x1f, 0x10, 0x00, 0x00, 0x1e, 0x1f, 0x08, 0xc0,
    0x3e, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1e, 0x11, 0x08, 0x04, 0x1e, 0x11, 0x00,
    0x08, 0x06, 0x01, 0x00, 0x1e, 0x19, 0x08, 0x00, 0x1e, 0x0b, 0x08, 0x00, 0x1f, 0x1b, 0x08, 0x00,
    0x18, 0x1f, 0x00, 0x00, 0x00, 0x1f, 0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x19, 0x08, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c,
    0x84, 0x84, 0x84, 0xcc, 0x38, 0x00, 0x00, 0x00, 0xf0, 0x18, 0x04, 0x05, 0x0f, 0x79, 0xe1, 0x00,
    0x00, 0x00, 0xc0, 0x78, 0x0c, 0x00, 0x00, 0x0c, 0x84, 0x84, 0xcc, 0xf8, 0x30, 0x00, 0x00, 0xe0,
    0xf8, 0x0c, 0x04, 0x04, 0x0c, 0xf8, 0x80, 0x00, 0x00, 0x00, 0xe0, 0x1c, 0x00, 0x00, 0x08, 0x0c,
    0x04, 0x04, 0xcc, 0x78, 0x00, 0x00, 0x00, 0xf0, 0x18, 0x0c, 0x04, 0x0c, 0x18, 0xf0, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
    0x10, 0x10, 0x10, 0x19, 0x0f, 0x00, 0x00, 0x00, 0x0f, 0x18, 0x10, 0x10, 0x18, 0x0f, 0x07, 0x00,
    0x20, 0x1e, 0x03, 0x00, 0x00, 0x00, 0x18, 0x10, 0x10, 0x10, 0x10, 0x1d, 0x0f, 0x00, 0x00, 0x03,
    0x0f, 0x18, 0x10, 0x10, 0x18, 0x0f, 0x00, 0x00, 0x38, 0x0f, 0x01, 0x00, 0x00, 0x00, 0x18, 0x1c,
    0x16, 0x13, 0x10, 0x10, 0x00, 0x00, 0x00, 0x07, 0x1c, 0x10, 0x10, 0x10, 0x0c, 0x07, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  };
  oled_write_raw_P(my_logo, sizeof(my_logo));
}

bool oled_task_user(void) {
  render_RIP();
  return false;
}
#endif
