// Copyright 2022 Jose Pablo Ramirez (@jpe230)
// SPDX-License-Identifier: GPL-2.0-or-later

#include "indicators.h"

const uint8_t key_frame[4] = {10, 30, 46, 61};

static const uint16_t cumsum_inds[IDLE_FRAMES+1] = {
        0, 8, 50, 82, 113, 141, 199, 261, 283, 294, 294, 294, 294, 294, 294,
        294, 330, 332, 377, 478, 588, 741, 844, 970, 1085, 1172, 1219, 1235, 1242, 1242,
        1243, 1243, 1244, 1318, 1368, 1466, 1491, 1627, 1797, 1900, 2019, 2094, 2215, 2311, 2375,
        2404, 2404, 2404, 2404, 2477, 2479, 2515, 2560, 2614, 2728, 2884, 2961, 3072, 3143, 3164,
        3167, 3167, 3167, 3167, 3169, 3171, 3221, 3221,
};

static const uint16_t change_inds[3221] = {
        173, 174, 175, 176, 177, 207, 208, 209, 135, 136, 137, 138, 139, 140, 141,
        142, 143, 144, 145, 146, 147, 148, 167, 168, 169, 170, 171, 172, 173, 174,
        175, 176, 177, 178, 179, 180, 206, 207, 208, 209, 210, 211, 212, 238, 239,
        240, 241, 242, 243, 244, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
        144, 145, 146, 147, 148, 149, 166, 167, 168, 169, 171, 172, 181, 213, 238,
        239, 240, 241, 242, 243, 244, 245, 134, 135, 136, 137, 138, 139, 140, 141,
        142, 143, 144, 145, 146, 147, 148, 149, 166, 167, 168, 171, 172, 181, 213,
        238, 239, 240, 241, 242, 243, 244, 245, 39, 102, 135, 136, 137, 138, 139,
        140, 141, 142, 143, 144, 145, 146, 147, 148, 167, 169, 170, 171, 173, 238,
        239, 240, 241, 242, 243, 244, 0, 2, 3, 4, 5, 7, 8, 10, 11,
        12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26,
        27, 28, 29, 30, 39, 62, 94, 96, 97, 98, 100, 102, 126, 134, 136,
        137, 140, 148, 158, 166, 180, 190, 198, 212, 222, 230, 244, 254, 262, 286,
        294, 318, 326, 350, 0, 2, 3, 4, 5, 7, 8, 10, 11, 12, 13,
        14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
        29, 30, 62, 64, 65, 66, 67, 94, 96, 97, 98, 99, 100, 102, 126,
        131, 134, 158, 163, 166, 190, 195, 198, 222, 227, 230, 254, 259, 262, 286,
        291, 294, 318, 323, 326, 350, 32, 33, 64, 65, 66, 67, 97, 99, 129,
        131, 161, 163, 193, 195, 225, 227, 257, 259, 289, 291, 321, 323, 32, 33,
        65, 97, 129, 161, 193, 225, 257, 289, 321, 136, 137, 138, 139, 140, 141,
        142, 143, 144, 145, 146, 147, 168, 169, 170, 171, 172, 173, 174, 175, 176,
        177, 178, 179, 206, 207, 208, 209, 210, 211, 238, 239, 240, 241, 242, 243,
        175, 176, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
        150, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181,
        182, 183, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
        213, 214, 108, 109, 110, 111, 112, 113, 114, 132, 133, 134, 135, 136, 137,
        138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152,
        153, 154, 155, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
        176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 196, 197, 198,
        199, 200, 201, 202, 203, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214,
        215, 216, 217, 218, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238,
        239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 38, 39,
        40, 42, 43, 44, 45, 46, 47, 48, 50, 51, 54, 55, 56, 65, 66,
        67, 90, 91, 92, 97, 108, 109, 110, 111, 112, 113, 114, 120, 121, 122,
        123, 124, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144,
        146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 164, 165, 168, 169, 171,
        172, 174, 182, 186, 187, 193, 194, 196, 197, 198, 199, 203, 207, 208, 210,
        211, 213, 217, 218, 220, 221, 223, 228, 229, 230, 231, 232, 233, 234, 235,
        236, 237, 238, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 261,
        262, 264, 265, 38, 39, 40, 42, 43, 44, 45, 46, 47, 48, 50, 51,
        54, 55, 56, 65, 66, 67, 89, 90, 91, 92, 93, 94, 95, 97, 111,
        112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 132, 133,
        134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
        149, 150, 151, 152, 153, 154, 160, 161, 162, 163, 165, 166, 167, 168, 169,
        170, 172, 179, 183, 184, 185, 186, 193, 194, 197, 198, 202, 205, 206, 207,
        208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 220, 221, 223, 229,
        230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244,
        245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 261, 262, 264, 265,
        266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 290, 291, 292, 293,
        294, 295, 296, 297, 320, 321, 62, 63, 84, 85, 86, 87, 88, 89, 90,
        91, 92, 93, 94, 95, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114,
        115, 116, 117, 118, 119, 120, 128, 129, 130, 131, 132, 133, 134, 135, 136,
        137, 139, 140, 141, 142, 147, 150, 151, 152, 153, 160, 161, 162, 163, 181,
        184, 185, 230, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 266,
        267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281,
        282, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 320,
        321, 322, 323, 324, 30, 31, 52, 53, 54, 55, 56, 57, 58, 59, 60,
        61, 62, 63, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84,
        85, 86, 87, 88, 89, 90, 91, 92, 93, 96, 97, 98, 99, 100, 101,
        102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
        128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 250, 251, 252, 253, 254,
        255, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283,
        284, 285, 286, 287, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302,
        303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 320, 321, 322, 323,
        324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 20, 21, 22, 23, 24,
        25, 26, 27, 28, 29, 30, 31, 41, 42, 43, 44, 45, 46, 47, 48,
        49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 64,
        65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
        80, 81, 82, 83, 84, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105,
        106, 146, 280, 281, 282, 283, 284, 285, 286, 287, 301, 302, 303, 304, 305,
        306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 323,
        324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338,
        339, 340, 341, 342, 343, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
        20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34,
        35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
        50, 51, 52, 53, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
        146, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 331, 332, 333, 334,
        335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349,
        350, 351, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12,
        13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 32, 33, 34, 35, 36,
        37, 38, 39, 40, 41, 42, 43, 64, 341, 342, 343, 344, 345, 346, 347,
        348, 349, 350, 351, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
        11, 12, 32, 33, 351, 0, 1, 2, 3, 4, 5, 6, 146, 146, 135,
        136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150,
        151, 152, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 177, 178, 179,
        180, 181, 182, 183, 184, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
        208, 209, 210, 211, 212, 213, 214, 215, 216, 230, 231, 232, 233, 234, 235,
        236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 137, 138,
        139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 168, 169, 170,
        171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 200, 201, 202,
        203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 237, 238, 239,
        240, 241, 242, 108, 109, 110, 111, 112, 113, 114, 132, 133, 134, 135, 136,
        137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151,
        152, 153, 154, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
        176, 177, 178, 181, 182, 183, 184, 185, 186, 195, 196, 197, 198, 199, 200,
        201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 213, 214, 215, 216,
        217, 218, 219, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
        240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 108, 109, 110, 111,
        112, 113, 114, 133, 134, 136, 144, 150, 154, 185, 195, 204, 211, 219, 231,
        234, 235, 243, 244, 247, 250, 34, 35, 36, 37, 38, 41, 42, 43, 44,
        45, 46, 47, 48, 49, 52, 53, 55, 64, 65, 89, 90, 91, 92, 122,
        123, 124, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141,
        142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 161, 164,
        166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 178, 182, 183, 184,
        185, 186, 193, 196, 203, 204, 205, 206, 207, 208, 209, 210, 211, 217, 218,
        225, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240,
        241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 252, 285, 288, 289, 313,
        314, 315, 316, 317, 323, 324, 327, 328, 329, 330, 331, 332, 333, 334, 335,
        336, 337, 338, 339, 340, 342, 343, 26, 27, 28, 29, 30, 31, 34, 35,
        36, 37, 38, 41, 42, 43, 44, 45, 46, 47, 48, 49, 52, 53, 55,
        64, 65, 89, 90, 91, 92, 95, 96, 97, 98, 99, 100, 101, 102, 103,
        104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 119,
        120, 121, 122, 123, 124, 125, 126, 129, 130, 131, 132, 133, 134, 135, 136,
        137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151,
        152, 153, 161, 165, 171, 172, 177, 183, 184, 185, 193, 197, 198, 199, 200,
        201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 216, 217, 224, 225, 226,
        227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241,
        242, 243, 244, 245, 246, 247, 248, 249, 250, 252, 281, 282, 283, 284, 285,
        286, 287, 288, 289, 313, 314, 315, 316, 317, 323, 324, 327, 328, 329, 330,
        331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 342, 343, 26, 27, 28,
        29, 30, 31, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
        97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
        112, 113, 114, 115, 116, 117, 119, 120, 121, 122, 123, 124, 125, 126, 224,
        225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
        240, 241, 242, 244, 245, 246, 247, 248, 256, 257, 258, 259, 260, 261, 262,
        263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277,
        278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 63, 64, 65, 66, 67,
        68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82,
        83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97,
        98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112,
        113, 114, 115, 116, 117, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265,
        266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280,
        281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295,
        296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310,
        311, 312, 313, 314, 315, 316, 317, 318, 319, 53, 54, 55, 56, 57, 58,
        59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73,
        74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88,
        89, 90, 91, 92, 93, 94, 95, 288, 289, 290, 291, 292, 293, 294, 295,
        296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310,
        311, 312, 313, 314, 315, 316, 317, 318, 319, 32, 33, 34, 35, 36, 37,
        38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
        53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67,
        68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82,
        83, 84, 85, 86, 87, 88, 288, 289, 290, 291, 292, 293, 294, 295, 296,
        297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311,
        312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326,
        327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341,
        342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 0, 1, 2, 3, 4,
        5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
        20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34,
        35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
        50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 320,
        321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335,
        336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350,
        351, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13,
        14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
        29, 30, 31, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331,
        332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346,
        347, 348, 349, 350, 351, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
        10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
        25, 26, 27, 28, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144,
        145, 146, 147, 148, 149, 150, 151, 152, 166, 167, 168, 169, 170, 171, 173,
        174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 198, 199, 200, 201,
        202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216,
        231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245,
        246, 247, 175, 176, 140, 141, 142, 143, 144, 145, 169, 170, 171, 172, 173,
        174, 175, 176, 177, 178, 179, 180, 181, 199, 200, 201, 202, 203, 204, 205,
        206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 137, 138, 139, 140, 141,
        142, 143, 144, 145, 166, 167, 168, 169, 170, 173, 174, 175, 176, 182, 183,
        196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 214, 215,
        216, 217, 218, 241, 242, 243, 244, 245, 246, 247, 136, 137, 138, 139, 140,
        141, 142, 143, 144, 145, 165, 166, 167, 168, 174, 175, 178, 179, 180, 181,
        182, 183, 184, 195, 196, 197, 204, 216, 219, 227, 228, 229, 230, 231, 232,
        233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247,
        248, 249, 250, 251, 20, 21, 22, 23, 49, 50, 51, 52, 78, 79, 80,
        107, 108, 109, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 165, 166,
        167, 168, 174, 175, 178, 179, 180, 181, 182, 183, 184, 193, 194, 195, 196,
        197, 204, 216, 219, 224, 225, 227, 228, 229, 230, 231, 232, 233, 234, 235,
        236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250,
        251, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269,
        270, 271, 272, 273, 274, 275, 276, 320, 321, 322, 323, 324, 325, 326, 327,
        328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 15, 16,
        17, 18, 20, 21, 22, 23, 44, 45, 46, 47, 49, 50, 51, 52, 73,
        74, 75, 76, 78, 79, 80, 102, 103, 104, 107, 108, 109, 131, 132, 133,
        136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 160, 161, 162, 165, 166,
        167, 168, 169, 173, 175, 181, 183, 184, 185, 186, 187, 188, 189, 190, 191,
        193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
        208, 216, 217, 218, 224, 225, 242, 243, 244, 245, 246, 247, 256, 257, 258,
        259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273,
        274, 275, 276, 279, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298,
        299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 320, 321,
        322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336,
        337, 338, 339, 340, 13, 14, 15, 16, 17, 18, 42, 43, 44, 45, 46,
        47, 70, 71, 72, 73, 74, 75, 76, 99, 100, 101, 102, 103, 104, 128,
        129, 130, 131, 132, 133, 160, 161, 162, 183, 184, 185, 186, 187, 188, 189,
        190, 191, 208, 215, 216, 217, 247, 249, 279, 281, 288, 289, 290, 291, 292,
        293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307,
        308, 309, 310, 311, 312, 313, 8, 9, 10, 11, 13, 14, 15, 16, 37,
        38, 39, 40, 42, 43, 44, 45, 66, 67, 68, 69, 70, 71, 72, 73,
        96, 97, 98, 99, 100, 101, 102, 128, 129, 130, 131, 156, 157, 158, 159,
        160, 185, 186, 187, 188, 189, 190, 191, 208, 216, 217, 220, 249, 252, 281,
        284, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301,
        302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 316, 320, 321,
        322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336,
        337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 3, 4, 5,
        6, 8, 9, 10, 11, 32, 33, 34, 35, 37, 38, 39, 40, 64, 66,
        67, 68, 69, 96, 97, 98, 156, 157, 158, 159, 188, 189, 191, 206, 208,
        220, 223, 252, 255, 284, 287, 316, 319, 320, 321, 322, 323, 324, 325, 326,
        327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341,
        342, 343, 344, 345, 346, 347, 348, 351, 0, 1, 2, 3, 4, 5, 6,
        32, 33, 34, 35, 64, 159, 191, 205, 206, 223, 255, 287, 319, 351, 0,
        1, 2, 205, 207, 207, 216, 138, 139, 140, 141, 142, 143, 144, 145, 167,
        168, 169, 170, 171, 172, 173, 174, 175, 177, 178, 179, 180, 181, 182, 197,
        198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
        213, 214, 215, 216, 217, 241, 242, 243, 244, 245, 246,
};

static const char change_vals[3221] = {
        0x18, 0x1C, 0xFC, 0xFC, 0xFC, 0x0F, 0x0F, 0x0F, 0xE0, 0xE0, 0xF0, 0xF0, 0xF0, 0xF8, 0xF8,
        0xFC, 0xFC, 0xFE, 0xFE, 0xFE, 0xFC, 0xFC, 0x03, 0x03, 0x03, 0x01, 0x01, 0x01, 0x00, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x0F,
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xF0, 0xF8, 0xF8, 0xF8, 0xFC, 0xFC, 0xFC, 0xFE, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0x1F,
        0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x00, 0xF0, 0xF0, 0xF0, 0xF8, 0xF8, 0xF8, 0xFC,
        0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0x00, 0x00, 0x03, 0x03, 0x01, 0x01, 0x00, 0x00,
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x00, 0x80, 0x80, 0x00, 0xE0, 0xE0, 0xE0, 0xE0,
        0xF0, 0xF0, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0x00, 0x03, 0x03, 0x03, 0x01, 0x03,
        0x07, 0x07, 0x07, 0x07, 0x07, 0x03, 0x80, 0x40, 0x20, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0xFC, 0x00, 0xFF, 0xFF, 0x08, 0x04, 0x04, 0x02, 0xFE, 0xFF, 0xFF, 0xC0,
        0xC0, 0xE0, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x08, 0x08, 0x04, 0xFC, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
        0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00,
        0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x80, 0x80, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0xFF,
        0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0xA0, 0x60, 0x80, 0xC0, 0xC0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xC0, 0xC0,
        0x80, 0x06, 0x0F, 0x0F, 0x0F, 0x0F, 0x03, 0x81, 0xC1, 0xC1, 0xE1, 0xFB, 0xFF, 0x7F, 0x3F,
        0x1F, 0x06, 0xF0, 0xF8, 0xFC, 0xFE, 0xFF, 0xFF, 0xFF, 0xF7, 0xF3, 0xF1, 0xF1, 0xF0, 0xF0,
        0xF0, 0xF0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xE0, 0xF8, 0xFC, 0xFE, 0xFE, 0xFF,
        0xFF, 0xFF, 0x3F, 0x3F, 0x1F, 0x1F, 0x1F, 0x3F, 0x3F, 0x7F, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE,
        0xFC, 0xF8, 0xC0, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x01, 0x00, 0x80, 0xC0, 0xC0,
        0xE0, 0xF0, 0xF8, 0xFC, 0xFF, 0xFF, 0xFF, 0x7F, 0x3F, 0x1F, 0x0F, 0x03, 0x80, 0xE0, 0xF0,
        0xF8, 0xF8, 0xFC, 0xFE, 0xFF, 0xBF, 0x9F, 0x9F, 0x8F, 0x87, 0x87, 0x83, 0x81, 0x81, 0x80,
        0x80, 0x80, 0x80, 0x80, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F,
        0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x80, 0x40,
        0x40, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x40, 0x40, 0x80, 0xC0, 0x18,
        0x04, 0x01, 0x04, 0xB0, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x20,
        0x08, 0x03, 0x00, 0xE0, 0xF0, 0xF8, 0xFC, 0xFE, 0xFE, 0xFE, 0x7E, 0x3E, 0x3F, 0xBF, 0x7F,
        0x7E, 0xFE, 0xFE, 0xFE, 0xFE, 0xFD, 0xF8, 0xF0, 0xC0, 0x00, 0x00, 0x43, 0x13, 0x0B, 0x07,
        0x02, 0x80, 0x7F, 0x07, 0x00, 0x02, 0x01, 0x00, 0xC0, 0xE0, 0xF0, 0xFE, 0x8F, 0x87, 0x83,
        0x81, 0x80, 0xC0, 0xA0, 0x10, 0x08, 0x04, 0x00, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
        0x8F, 0x4F, 0x2F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x00, 0x40,
        0x60, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x60, 0x30, 0x18, 0x0C, 0x02, 0x00, 0x80,
        0x40, 0x40, 0x20, 0x10, 0x08, 0x08, 0x04, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40,
        0xC0, 0xE0, 0xF0, 0xF8, 0xF8, 0xFC, 0xFE, 0xFE, 0x7D, 0x7C, 0x7C, 0x7C, 0xFC, 0xFC, 0xF8,
        0xF8, 0xF8, 0xF0, 0xE0, 0x80, 0x00, 0x04, 0x02, 0x01, 0x01, 0x00, 0x07, 0x07, 0x07, 0x07,
        0x07, 0x01, 0xFF, 0x3F, 0x1F, 0x07, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xFC, 0xFF, 0xCF, 0xCF,
        0xC7, 0xC3, 0xC3, 0xC1, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
        0x87, 0x87, 0x47, 0x27, 0x20, 0x10, 0x18, 0x08, 0x04, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00,
        0x80, 0x40, 0x40, 0x20, 0x10, 0x08, 0x08, 0x04, 0x02, 0x02, 0x01, 0xC0, 0x60, 0x30, 0x18,
        0x0C, 0x04, 0x02, 0x01, 0x06, 0x01, 0x80, 0x40, 0x80, 0x80, 0x40, 0x20, 0x30, 0x18, 0x0C,
        0x04, 0x02, 0x01, 0x00, 0x00, 0x80, 0x80, 0x40, 0x60, 0x20, 0x10, 0x08, 0x0C, 0x04, 0x02,
        0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x30, 0x10, 0x08, 0x0C, 0x04, 0xC2, 0xF1,
        0xF1, 0xF8, 0xF8, 0xFC, 0x7C, 0xF8, 0xF0, 0xE0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F,
        0x0F, 0x00, 0x03, 0x07, 0x07, 0x07, 0x07, 0x00, 0x80, 0x80, 0x40, 0x60, 0x20, 0x30, 0x00,
        0x00, 0x00, 0x00, 0x80, 0x80, 0x40, 0x60, 0x20, 0x10, 0x18, 0x08, 0x04, 0x06, 0x02, 0x01,
        0x01, 0x00, 0x00, 0x80, 0x80, 0x40, 0x20, 0x10, 0x18, 0x0C, 0x04, 0x02, 0x03, 0x01, 0x18,
        0x0C, 0x06, 0x03, 0x01, 0x80, 0xC0, 0x80, 0x80, 0xC0, 0x60, 0x30, 0x18, 0x18, 0x0C, 0x06,
        0x03, 0x01, 0x00, 0x80, 0x80, 0xC0, 0x60, 0x20, 0x30, 0x18, 0x0C, 0x04, 0x06, 0x03, 0x01,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x60, 0x30, 0x30, 0x18, 0x0C,
        0x04, 0x06, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xF0, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0xC0, 0x60,
        0x60, 0x30, 0x10, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC0,
        0x60, 0x60, 0x30, 0x18, 0x18, 0x0C, 0x06, 0x06, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x80,
        0xC0, 0x60, 0x30, 0x18, 0x18, 0x0C, 0x06, 0x03, 0x01, 0x01, 0x80, 0x80, 0xC0, 0x60, 0x70,
        0x30, 0x18, 0x0C, 0x0E, 0x07, 0x03, 0x01, 0x80, 0x80, 0xC0, 0xE0, 0x60, 0x30, 0x18, 0x1C,
        0x0C, 0x06, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0,
        0x60, 0x70, 0x30, 0x18, 0x1C, 0x0C, 0x06, 0x07, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0xC0, 0xE0, 0x60, 0x30, 0x38, 0x18, 0x0C, 0x0C, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0xC0, 0x60, 0x70, 0x30, 0x18, 0x0C,
        0x0E, 0x06, 0x03, 0x03, 0x01, 0x80, 0xC0, 0xE0, 0x60, 0x70, 0x38, 0x1C, 0x0C, 0x0E, 0x07,
        0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xE0, 0x60,
        0x70, 0x38, 0x1C, 0x0C, 0x0E, 0x07, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0xC0, 0xE0, 0x70, 0x30, 0x38, 0x1C, 0x0C,
        0x0E, 0x07, 0xC0, 0xE0, 0xE0, 0x70, 0x38, 0x3C, 0x1C, 0x0E, 0x0F, 0x07, 0x03, 0x01, 0x01,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x80, 0x3C, 0x1E, 0x0E, 0x07, 0x07, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFC, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
        0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0,
        0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xC0, 0xC0, 0x80, 0x07, 0x07, 0x07,
        0x07, 0x07, 0xE1, 0xE1, 0xE1, 0xE1, 0xF1, 0xFF, 0xFF, 0xFF, 0xBF, 0x1F, 0x38, 0x78, 0xFC,
        0xFC, 0xF8, 0xF0, 0xE1, 0xE0, 0xE1, 0xF1, 0xFF, 0xFF, 0xFF, 0x7F, 0x3F, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xF0, 0xFC, 0xFE, 0xFE, 0xFF,
        0xFF, 0xFF, 0x7F, 0x3F, 0x3F, 0x1F, 0x1F, 0x1F, 0x3F, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
        0xFC, 0xF8, 0xF0, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0xF8, 0xF8, 0xF8, 0xF8,
        0xF8, 0xF8, 0xFC, 0xFF, 0xFF, 0xBF, 0x9F, 0x1F, 0x07, 0x60, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0,
        0xF0, 0xF0, 0x80, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x83, 0xC7, 0xFF, 0xFF, 0xFF, 0xFF,
        0xFF, 0xFE, 0x30, 0x03, 0x07, 0x0F, 0x1F, 0x1F, 0x1F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F,
        0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x1F, 0x1F, 0x1F, 0x0F, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0xF8, 0xFC, 0xFE, 0x3F, 0xFE, 0xE0, 0x0F, 0x00, 0x81, 0xD7, 0x00, 0x0F,
        0x1F, 0x1F, 0x1F, 0x1F, 0x0F, 0x01, 0x80, 0x80, 0x40, 0x40, 0x40, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x40, 0x40, 0x80, 0x02, 0x01, 0x01, 0x02, 0x08, 0xE0, 0x40,
        0x20, 0x0F, 0xF8, 0x08, 0x08, 0x08, 0xC8, 0xF8, 0xF8, 0xF8, 0xFC, 0xFC, 0xFC, 0x7E, 0x7E,
        0x7E, 0x3E, 0x7E, 0x7E, 0xFE, 0xFC, 0xFC, 0xFC, 0xFC, 0xFA, 0xF1, 0x80, 0x00, 0xFF, 0x00,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x01, 0x60, 0xF0, 0xF0, 0xF0, 0xF0, 0xF8, 0xBF, 0x9F, 0x1F,
        0x07, 0x00, 0xFF, 0x00, 0xE0, 0xC1, 0x81, 0x81, 0x81, 0x81, 0x81, 0xC3, 0xFF, 0xFE, 0x00,
        0x01, 0x02, 0x02, 0x02, 0x03, 0x03, 0x07, 0x07, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
        0x0F, 0x0F, 0x0F, 0x0F, 0x07, 0x07, 0x07, 0x01, 0x08, 0x10, 0x40, 0xFF, 0x40, 0x80, 0x80,
        0x40, 0x20, 0x18, 0x07, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x02, 0x04, 0x0C, 0x18, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
        0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x20, 0x20, 0x20, 0x20, 0x20, 0x10,
        0x10, 0x08, 0x08, 0x0C, 0x04, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xE0, 0xF0,
        0xF8, 0xF8, 0xF8, 0xF8, 0x7C, 0x7C, 0x7C, 0x7C, 0xFC, 0xF8, 0xF8, 0xF8, 0xF8, 0xF0, 0xE0,
        0xC0, 0x00, 0x00, 0x00, 0x03, 0x00, 0xF0, 0x1F, 0x0F, 0x00, 0x00, 0x00, 0x78, 0xF8, 0xF8,
        0xF8, 0xF8, 0xF0, 0xC0, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0xE3, 0x7E, 0x00, 0x40, 0x40, 0x40,
        0x40, 0x40, 0x40, 0x40, 0x41, 0x43, 0x43, 0x43, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
        0x47, 0x07, 0x87, 0x83, 0x83, 0x81, 0x80, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x02, 0x02,
        0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0xC0, 0x40, 0x40, 0x60, 0x20, 0x30, 0x10, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x03, 0x03, 0x07, 0x07, 0x07, 0x07, 0x07,
        0x07, 0x07, 0x07, 0x07, 0x03, 0x03, 0x01, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
        0x18, 0x08, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
        0x10, 0x30, 0x30, 0x20, 0x20, 0x20, 0x60, 0x40, 0x40, 0xC0, 0x80, 0x18, 0x18, 0x18, 0x18,
        0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x08, 0x08, 0x08, 0x08, 0x08,
        0x0C, 0x0C, 0x0C, 0x0C, 0x04, 0x04, 0x06, 0x06, 0x02, 0x03, 0x03, 0x01, 0x01, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x04, 0x04, 0x04, 0x0C, 0x0C, 0x0C, 0x08, 0x18, 0x80, 0x80, 0x80, 0x80, 0x80, 0xC0,
        0xC0, 0xC0, 0x40, 0x60, 0x60, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
        0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x10, 0x10, 0x10, 0x30,
        0x30, 0x30, 0x30, 0x30, 0x20, 0x20, 0x60, 0x60, 0x60, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
        0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0,
        0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xE0, 0xE0, 0xE0, 0xE0, 0x60, 0x60, 0x60,
        0x60, 0x60, 0x70, 0x70, 0x70, 0x30, 0x30, 0x30, 0x38, 0x38, 0x18, 0x18, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0,
        0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xC0, 0xC0, 0xC0, 0xC0,
        0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
        0x80, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
        0x07, 0x07, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0xC0, 0x80, 0xC0, 0xE0, 0xE0, 0xE0, 0xE0, 0x20, 0xE0, 0xF8, 0xFF, 0xFF, 0xFF,
        0x3F, 0x07, 0x01, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x18, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3C,
        0x3C, 0x3C, 0x3C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3C, 0x3C, 0xC0, 0xF0, 0xFC, 0xFE, 0xFC,
        0xFE, 0xFE, 0x7E, 0x0C, 0xC0, 0xF0, 0xFE, 0xFF, 0xFF, 0x3F, 0x0F, 0x01, 0x00, 0xC0, 0xC0,
        0xF8, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xF8, 0xF8, 0xF8, 0xF8, 0xFF, 0xFF,
        0xF8, 0xF8, 0xF8, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x80, 0xF0, 0xFE, 0xFF, 0xFF,
        0xFF, 0xFF, 0xFF, 0x3F, 0x07, 0xC0, 0xF0, 0xFE, 0xFF, 0x07, 0x00, 0xE0, 0xE0, 0xE0, 0xE0,
        0xE0, 0xE0, 0xE0, 0xF8, 0xFE, 0xFF, 0xF8, 0xFF, 0xF8, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F,
        0x1F, 0x01, 0x01, 0x01, 0x80, 0x30, 0x0C, 0x01, 0x80, 0x30, 0x04, 0x01, 0xC0, 0x10, 0x06,
        0xC0, 0x18, 0x06, 0x60, 0x98, 0xF3, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x7C, 0x0C, 0x60, 0x88,
        0xF3, 0xFC, 0x0F, 0x01, 0xC0, 0xC0, 0xC0, 0xF0, 0xC0, 0xC0, 0x00, 0x80, 0x20, 0x0C, 0xF1,
        0xFE, 0xF9, 0xF8, 0x00, 0x0C, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x07, 0x00, 0x00, 0x00,
        0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
        0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x80, 0x70,
        0x0C, 0x03, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x30, 0x0E, 0x01, 0x00, 0x00, 0x00, 0x00, 0xC0,
        0x38, 0x06, 0x01, 0x00, 0x00, 0x00, 0xC0, 0x38, 0x07, 0x00, 0x00, 0x00, 0xE0, 0x18, 0x07,
        0x00, 0x00, 0xC0, 0xF0, 0xF8, 0xF8, 0xF8, 0xF8, 0x78, 0x18, 0x60, 0x1C, 0x03, 0x00, 0x00,
        0xC0, 0xF8, 0xFE, 0x7F, 0x03, 0xC0, 0xFC, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x00, 0x00, 0x00, 0x00, 0x78, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7D, 0x7C, 0x7C, 0x7C,
        0x7C, 0xFC, 0x78, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x07, 0x07, 0xFF, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0xFF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0xC0, 0x38, 0x07, 0x01, 0x00, 0x00, 0xE0, 0x38, 0x07, 0x01, 0x00,
        0x00, 0x80, 0xE0, 0x1C, 0x07, 0x00, 0x00, 0x00, 0x80, 0x70, 0x1C, 0x03, 0x00, 0x00, 0x80,
        0x70, 0x0E, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x78, 0x7C, 0x7C, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x3F, 0xC0, 0x78, 0x1E, 0x03, 0x00, 0x00, 0x00, 0x00, 0xC0,
        0x78, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x38, 0x0F, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x3C, 0x0F, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80,
        0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0x00, 0x00, 0x7C, 0x78, 0x78, 0xFF, 0x00, 0xFF, 0x00,
        0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x30, 0x30,
        0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
        0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3F, 0xC0, 0xF8, 0x1E,
        0x07, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x78, 0x1F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0xFF, 0x78, 0x78,
        0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x3F, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x7C, 0x78, 0x7C, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

uint16_t index_start2 = 0;
uint16_t index_end2 = 0;
void change_frame_up(uint8_t frame_number){
// for n changes this frame, change those bytes by change_inds and change_vals
        index_start2 = cumsum_inds[frame_number-1];
        index_end2 = cumsum_inds[frame_number];
        if (index_start2 != index_end2){  // if a change in buffer
                for (uint16_t i=index_start2; i < index_end2; i++){
                        oled_write_raw_byte(change_vals[i], change_inds[i]);
                }
        }
}
