/** @file config.h
 *  @brief config header that includes function prototypes and external variables.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Mario Corona (mariocc@comunidad.unam.mx) 2021
 *
 */

#pragma once

/* Select hand configuration */
#define MASTER_LEFT

/* Comment this definition out if you want the main display to be output in horizontal mode */
#define OLED_VERTICAL

#ifdef RGB_MATRIX_ENABLE
    #define RGB_MATRIX_MAXIMUM_BRIGHTNESS 120
    #define RGB_MATRIX_HUE_STEP 10
    #define RGB_MATRIX_SAT_STEP 10
    #define RGB_MATRIX_VAL_STEP 10
    #define RGB_MATRIX_SPD_STEP 10
//    #define RGB_MATRIX_KEYPRESSES
    #define RGB_MATRIX_FRAMEBUFFER_EFFECTS

    /* BEGIN: Disable RGB Effects */
//    #undef ENABLE_RGB_MATRIX_SOLID_COLOR
//    #undef ENABLE_RGB_MATRIX_ALPHAS_MODS
//    #undef ENABLE_RGB_MATRIX_GRADIENT_UP_DOWN
//    #undef ENABLE_RGB_MATRIX_BREATHING
//    #undef ENABLE_RGB_MATRIX_BAND_SAT
//    #undef ENABLE_RGB_MATRIX_BAND_VAL
//    #undef ENABLE_RGB_MATRIX_BAND_PINWHEEL_SAT
//    #undef ENABLE_RGB_MATRIX_BAND_PINWHEEL_VAL
//    #undef ENABLE_RGB_MATRIX_BAND_SPIRAL_SAT
//    #undef ENABLE_RGB_MATRIX_BAND_SPIRAL_VAL
//    #undef ENABLE_RGB_MATRIX_CYCLE_ALL
//    #undef ENABLE_RGB_MATRIX_CYCLE_LEFT_RIGHT
//    #undef ENABLE_RGB_MATRIX_CYCLE_UP_DOWN
//    #undef ENABLE_RGB_MATRIX_CYCLE_OUT_IN
//    #undef ENABLE_RGB_MATRIX_CYCLE_OUT_IN_DUAL
#    undef ENABLE_RGB_MATRIX_RAINBOW_MOVING_CHEVRON
#    undef ENABLE_RGB_MATRIX_CYCLE_PINWHEEL
#    undef ENABLE_RGB_MATRIX_CYCLE_SPIRAL
//    #undef ENABLE_RGB_MATRIX_DUAL_BEACON
#    undef ENABLE_RGB_MATRIX_RAINBOW_BEACON
#    undef ENABLE_RGB_MATRIX_RAINBOW_PINWHEELS
#    undef ENABLE_RGB_MATRIX_RAINDROPS
//    #undef ENABLE_RGB_MATRIX_JELLYBEAN_RAINDROPS

/* BEGIN: RGB_MATRIX_FRAMEBUFFER_EFFECTS */
//    #undef ENABLE_RGB_MATRIX_TYPING_HEATMAP
//    #undef ENABLE_RGB_MATRIX_DIGITAL_RAIN
/* END: RGB_MATRIX_FRAMEBUFFER_EFFECTS */

/* BEGIN: RGB_MATRIX_KEYPRESSES */
//    #undef ENABLE_RGB_MATRIX_SOLID_REACTIVE_SIMPLE
//    #undef ENABLE_RGB_MATRIX_SOLID_REACTIVE
//    #undef ENABLE_RGB_MATRIX_SOLID_REACTIVE_WIDE
//    #undef ENABLE_RGB_MATRIX_SOLID_REACTIVE_MULTIWIDE
//    #undef ENABLE_RGB_MATRIX_SOLID_REACTIVE_CROSS
//    #undef ENABLE_RGB_MATRIX_SOLID_REACTIVE_MULTICROSS
//    #undef ENABLE_RGB_MATRIX_SOLID_REACTIVE_NEXUS
//    #undef ENABLE_RGB_MATRIX_SOLID_REACTIVE_MULTINEXUS
//    #undef ENABLE_RGB_MATRIX_SPLASH
//    #undef ENABLE_RGB_MATRIX_MULTISPLASH
//    #undef ENABLE_RGB_MATRIX_SOLID_SPLASH
//    #undef ENABLE_RGB_MATRIX_SOLID_MULTISPLASH
/* END: RGB_MATRIX_KEYPRESSES */
/* END: Disable RGB Effects */
#endif

/* To tell the compiler to use custom font */
#define OLED_FONT_H "keyboards/crkbd/keymaps/mcrown/glcdfont.c"
