# ninjonas Keymap for [Corne Keyboard (crkbd)](https://github.com/foostan/crkbd)

## Keymap
This keymap is designed based off my typing habits and is subject to change. Information about custom user macros and tap dances can be found [here](../../../../users/ninjonas).

More information about the crkbd keyboard can be found [here](https://thomasbaart.nl/2018/11/26/corne-keyboard-helidox-build-log/)

### QWERTY
```c
  //,----------------------------------------------------.      ,----------------------------------------------------.
  //      Tab,       Q,       W,       E,       R,      T,              Y,       U,       I,       O,       P,     \
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
  //      ESC,       A,       S,       D,       F,      G,              H,       J,       K,       L,       ;,     '
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
  //   LShift,       Z,       X,       C,       V,      B,              N,       M,       ,,       .,       /,     =
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
                                 //    Cmd,    Ctrl,  Space,          Enter,  BackSP, Del
                                 //`---------------------'      `---------------------'
```

### DVORAK
```c
  //,----------------------------------------------------.      ,----------------------------------------------------.
  //      Tab,       ',       ,,       .,       P,      Y,              F,       G,       C,       R,       L,     \
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
  //      ESC,       A,       O,       E,       U,      I,              D,       H,       T,       N,       S,     /
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
  //   LShift,       ;,       Q,       J,       K,      X,              B,       M,       W,       V,       Z,     =
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
                                 //    Cmd,    Ctrl,  Space,          Enter,  BackSP, Del
                                 //`---------------------'      `---------------------'
```

### COLEMAK
```c
  //,----------------------------------------------------.      ,----------------------------------------------------.
  //      Tab,       Q,       W,       F,       P,      G,              J,       L,       U,       Y,       ;,     \
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
  //      ESC,       A,       R,       S,       T,      D,              H,       N,       E,       I,       O,     '
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
  //   LShift,       Z,       X,       C,       V,      B,              K,       M,       ,,       .,       /,     =
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
                                 //    Cmd,    Ctrl,  Space,          Enter,  BackSP, Del
                                 //`---------------------'      `---------------------'
```

### LOWER
```c
  //,----------------------------------------------------.      ,----------------------------------------------------.
  //         ,        , KC_BRIU,    Play,    Mute, K_CSCN,           PgUp,    Home,      Up,     End,        ,  K_MDSH
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
  //         ,        , KC_BRID,    Next,   VolUp,       ,           PgDn,    Left,    Down,   Right,  K_LOCK,
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
  //         ,        ,        ,    Prev,   VolDn,      [,              ],        ,        ,  M_CODE,  M_XXX1, M_PYNV,
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
                                 //     ,        ,       ,               ,        ,
                                 //`---------------------'      `---------------------'
```

### RAISE
```c
  //,----------------------------------------------------.      ,----------------------------------------------------.
  //        `,       1,       2,       3,       4,      5,              6,       7,       8,       9,       0,      -
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
  //        ~,       !,       @,       #,       $,      %,              ^,       &,       *,       (,       ),      _
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
  //      F11,      F1,      F2,      F3,      F4,     F5,             F6,      F7,      F8,      F9,     F10,    F12
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
                                 //     ,        ,       ,               ,        ,
                                 //`---------------------'      `---------------------'
```

### ADJUST
```c
  //,----------------------------------------------------.      ,----------------------------------------------------.
  //   M_MAKE, EE_CLR ,        ,        ,        ,        ,       RGB_TOG,        ,        , COLEMAK,  DVORAK, QWERTY,
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
  //   M_VRSN,  M_MALL,        , RGB_SAI, RGB_HUI, RGB_VAI,              ,        ,        ,        ,        ,        ,
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
  //   M_FLSH,        ,        , RGB_SAD, RGB_HUD, RGB_VAD,       RGB_M_P, RGB_M_B,RGB_M_SW,        ,        ,        ,
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
                                 //     ,        ,       ,               ,        ,
                                 //`---------------------'      `---------------------'
```

<!--
### TEMPLATE
```c
  //,----------------------------------------------------.      ,----------------------------------------------------.
  //         ,        ,        ,        ,        ,       ,               ,        ,        ,        ,        ,
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
  //         ,        ,        ,        ,        ,       ,               ,        ,        ,        ,        ,
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
  //         ,        ,        ,        ,        ,       ,               ,        ,        ,        ,        ,
  //|--------+--------+--------+--------+--------+-------|      |--------+--------+--------+--------+--------+-------|
                                 //     ,        ,       ,               ,        ,
                                 //`---------------------'      `---------------------'
```
-->