# ollyhayes's keymap for [Corne Keyboard (crkbd)](https://github.com/foostan/crkbd)

## Keymap

After many years of changing my keymap often and reperatedly, I finally came to a stable version. I've been using this for a while now with only small tweaks every so often.

All layers are activated only whilst the layer key is held, except the default layers.

Lots of keys are repeated on both sides. I find this really useful for two reasons:

* I like to have the option to use the opposite hand to hold modifiers shift/ctrl etc as the hand pressing the key, I find this really comfortable.
* When using the mouse, I like to be able to do common things with just my left hand.

### Colemak

The base layer:

![colemak](https://i.imgur.com/uxLJzul.png)

### Navigation

All things for moving the cursor around, inspired by vim.

* `c←` is ctrl+left
* `↓↓↓↓` is ↓ pressed four times

![navigation](https://i.imgur.com/xfkA0ze.png)

### Symbols

The shifted number row and all brackets and other symbols.

* `a/t` is alt-tab for window switching in windows/linux. Using some special code to release alt when the punc key is released, this works quite nicely.

![symbols](https://i.imgur.com/t9Jygs1.png)

### Specials

Some extra symbols (linux only for now) that work by sending UTF sequences. Layer activated by holding both punctuation layer keys.

![specials](https://i.imgur.com/AtPWKrA.png)

### Numbers

Numbpads (left version is reversed so 1, 2, 3 are easy to reach with one hand (like on a regular keyboard).

Also the keys to switch the default layer are here.

![numbers](https://i.imgur.com/9XXcAXK.png)

### Functions

Function keys, nothing too interesting.

![functions](https://i.imgur.com/ttrw3FJ.png)

### Games (default layer)

Used for some games, qwerty with space bar and alt for the left hand.

![games](https://i.imgur.com/zVvHWKd.png)

### Qwerty (default layer)

Mostly for guests.

![qwerty](https://i.imgur.com/Bqs1bjV.png)
