#include QMK_KEYBOARD_H

const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {

  /* Qwerty
   * ,-----------------------------------------------------------------------------------------.
   * |  `  |  1  |  2  |  3  |  4  |  5  |  6  |  7  |  8  |  9  |  0  |  -  |  =  | \ | Del   |
   * |-----------------------------------------------------------------------------------------+
   * | Tab    |  Q  |  W  |  E  |  R  |  T  |  Y  |  U  |  I  |  O  |  P  |  [  |  ]  | Bkspc  |
   * |-----------------------------------------------------------------------------------------+
   * |   Fn    |  A  |  S  |  D  |  F  |  G  |  H  |  J  |  K  |  L  |  ;  |  '  |    Enter    |
   * |-----------------------------------------------------------------------------------------+
   * | Shift     |  Z  |  X  |  C  |  V  |  B  |  N  |  M  |  ,  |  .  | ?/ |    Shift   | ESC |
   * |-----------------------------------------------------------------------------------------+
   * | Ctrl |  Alt  |  Cmd  |              Space                |  Cmd |  Alt  |  Ctrl  |  Fn  |
   * `-----------------------------------------------------------------------------------------'
   */

  LAYOUT_60_2_function(
      KC_GRAVE, KC_1, KC_2, KC_3, KC_4, KC_5, KC_6, KC_7, KC_8, KC_9, KC_0, KC_MINS, KC_EQL, KC_BSLS, KC_DEL,
      KC_TAB, KC_Q, KC_W, KC_E, KC_R, KC_T, KC_Y, KC_U, KC_I, KC_O, KC_P, KC_LBRC, KC_RBRC, KC_BSPC,
      MO(1), KC_A, KC_S, KC_D, KC_F, KC_G, KC_H, KC_J, KC_K, KC_L, KC_SCLN, KC_QUOT, KC_ENT,
      KC_LSFT, KC_Z, KC_X, KC_C, KC_V, KC_B, KC_N, KC_M, KC_COMM, KC_DOT, KC_SLSH, KC_RSFT, KC_ESCAPE,
      KC_LCTL, KC_LALT, KC_LGUI,       KC_SPC,        KC_RGUI, KC_RALT, KC_RCTL, MO(1)
      ),

  /* FN Layer
   * ,-----------------------------------------------------------------------------------------.
   * |     |  F1 |  F2 |  F3 |  F4 |  F5 |  F6 |  F7 |  F8 |  F9 | F10 | F11 | F12 |Vol- |Vol+ |
   * |-----------------------------------------------------------------------------------------+
   * |        |RBB T|RGB M| Hue-| Hue+| Sat-| Sat+| Val-| Val+|      |     | Mute| Prev | Next |
   * |-----------------------------------------------------------------------------------------+
   * |         |     |     |     |     |     | Left| Down| Up |Right|      |      | Play/Pause |
   * |-----------------------------------------------------------------------------------------+
   * |           |     |     |     |     |     |     |     |Scr- |Scr+ |     |     |     |QK_BOOT|
   * |-----------------------------------------------------------------------------------------+
   * |      |       |       |                                   |      |       |       |       |
   * `-----------------------------------------------------------------------------------------'
   */

  LAYOUT_60_2_function(
      _______, KC_F1,   KC_F2,   KC_F3,   KC_F4,   KC_F5,   KC_F6,   KC_F7,   KC_F8,   KC_F9,  KC_F10, KC_F11, KC_F12, KC_VOLD, KC_VOLU,
      _______, RGB_TOG, RGB_MOD, RGB_HUD, RGB_HUI, RGB_SAD, RGB_SAI, RGB_VAD, RGB_VAI, _______, _______, KC_MUTE, KC_MRWD, KC_MFFD,
      _______, _______, _______, _______, _______, _______, KC_LEFT, KC_DOWN, KC_UP, KC_RIGHT, _______, _______, KC_MPLY,
      _______,  _______, _______, _______, _______, _______, _______, KC_BRID, KC_BRIU, _______, _______, _______, QK_BOOT,
      _______, _______, _______, _______, _______, _______, _______, _______
      ),
};
