/* Copyright (C) 2020 Nathan Friend
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include QMK_KEYBOARD_H
#include "version.h"
#include "keymap_german.h"
#include "keymap_nordic.h"
#include "keymap_french.h"
#include "keymap_spanish.h"
#include "keymap_hungarian.h"

#define KC_MAC_UNDO LGUI(KC_Z)
#define KC_MAC_CUT LGUI(KC_X)
#define KC_MAC_COPY LGUI(KC_C)
#define KC_MAC_PASTE LGUI(KC_V)
#define KC_PC_UNDO LCTL(KC_Z)
#define KC_PC_CUT LCTL(KC_X)
#define KC_PC_COPY LCTL(KC_C)
#define KC_PC_PASTE LCTL(KC_V)
#define ___ KC_TRNS

/* Shortcut for Option+Ctrl */
#define OC(keycode) LALT(LCTL(keycode))

enum layer_names {

    /* Base layers */
    _COLEMAK,
    _QWERTY,
    _DVORAK,

    /* Keys the base layers share */
    _COMMON,

    /* OS layers */
    _MAC,
    _WINDOWS,

    /* Symbols */
    _NUMPAD,
    _SYMBOLS,

    /* Window management */
    _WM_MAC,
    _WM_WINDOWS,

    /* Navigation */
    _ARROWS_MAC,
    _ARROWS_WINDOWS,

    _MISC
};

enum custom_keycodes {
    RGB_SLD = SAFE_RANGE, /* Can always be here */
    HSV_0_255_255,
    HSV_120_255_128,
    HSV_240_255_255,
    MAC_MODE,
    WINDOWS_MODE,
    DYNAMIC_MACRO_RANGE, /* This needs to be last! */
};

const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {
    /* clang-format off */

    [_COLEMAK] = LAYOUT_ergodox(
        /* Left hand */

        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/   KC_Q,   /**/   KC_W,   /**/   KC_F,   /**/   KC_P,   /**/   KC_G,   /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/   KC_A,   /**/   KC_R,   /**/   KC_S,   /**/   KC_T,   /**/   KC_D,   /*===============*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/   KC_Z,   /**/   KC_X,   /**/   KC_C,   /**/   KC_V,   /**/   KC_B,   /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
            /**/       /**/           /**/           /**/           /**/           /**/
            /**/  ___, /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
            /**/       /**/           /**/           /**/           /**/           /**/
            /*=======================================================================*/
                                                                                               /*==============================*/
                                                                                               /**/           /**/           /**/
                                                                                               /**/ _______,  /**/ _______,  /**/
                                                                                               /**/           /**/           /**/
                                                                                /*=============================================*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /**/ _______,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /*===============*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/ _______,  /**/ _______,  /**/ _______,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /*=============================================*/

        /* Right hand */

                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/   KC_J,   /**/   KC_L,   /**/   KC_U,   /**/   KC_Y,   /**/ KC_SCLN,  /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*===============*/   KC_H,   /**/   KC_N,   /**/   KC_E,   /**/   KC_I,   /**/   KC_O,   /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/   KC_K,   /**/   KC_M,   /**/ KC_COMMA, /**/  KC_DOT,  /**/ KC_SLASH, /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/  ___, /**/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /*=======================================================================*/
        /*==============================*/
        /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/
        /*=============================================*/
        /**/           /**/           /**/           /**/
        /**/ _______,  /**/           /**/           /**/
        /**/           /**/           /**/           /**/
        /*===============*/           /**/           /**/
        /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______   /**/
        /**/           /**/           /**/           /**/
        /*=============================================*/
    ),

    [_QWERTY] = LAYOUT_ergodox(
        /* Left hand */

        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/   KC_Q,   /**/   KC_W,   /**/   KC_E,   /**/   KC_R,   /**/   KC_T,   /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/   KC_A,   /**/   KC_S,   /**/   KC_D,   /**/   KC_F,   /**/   KC_G,   /*===============*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/   KC_Z,   /**/   KC_X,   /**/   KC_C,   /**/   KC_V,   /**/   KC_B,   /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
            /**/       /**/           /**/           /**/           /**/           /**/
            /**/  ___, /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
            /**/       /**/           /**/           /**/           /**/           /**/
            /*=======================================================================*/
                                                                                               /*==============================*/
                                                                                               /**/           /**/           /**/
                                                                                               /**/ _______,  /**/ _______,  /**/
                                                                                               /**/           /**/           /**/
                                                                                /*=============================================*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /**/ _______,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /*===============*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/ _______,  /**/ _______,  /**/ _______,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /*=============================================*/

        /* Right hand */

                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/   KC_Y,   /**/   KC_U,   /**/   KC_I,   /**/   KC_O,   /**/   KC_P,   /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*===============*/   KC_H,   /**/   KC_J,   /**/   KC_K,   /**/   KC_L,   /**/ KC_SCLN,  /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/   KC_N,   /**/   KC_M,   /**/ KC_COMMA, /**/  KC_DOT,  /**/ KC_SLASH, /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/  ___, /**/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /*=======================================================================*/
        /*==============================*/
        /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/
        /*=============================================*/
        /**/           /**/           /**/           /**/
        /**/ _______,  /**/           /**/           /**/
        /**/           /**/           /**/           /**/
        /*===============*/           /**/           /**/
        /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______   /**/
        /**/           /**/           /**/           /**/
        /*=============================================*/
    ),

    [_DVORAK] = LAYOUT_ergodox(
        /* Left hand */

        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ KC_QUOTE, /**/ KC_COMMA, /**/  KC_DOT,  /**/   KC_P,   /**/   KC_Y,   /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/   KC_A,   /**/   KC_O,   /**/   KC_E,   /**/   KC_U,   /**/   KC_I,   /*===============*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ KC_SCLN,  /**/   KC_Q,   /**/   KC_J,   /**/   KC_K,   /**/   KC_X,   /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
            /**/       /**/           /**/           /**/           /**/           /**/
            /**/  ___, /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
            /**/       /**/           /**/           /**/           /**/           /**/
            /*=======================================================================*/
                                                                                               /*==============================*/
                                                                                               /**/           /**/           /**/
                                                                                               /**/ _______,  /**/ _______,  /**/
                                                                                               /**/           /**/           /**/
                                                                                /*=============================================*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /**/ _______,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /*===============*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/ _______,  /**/ _______,  /**/ _______,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /*=============================================*/

        /* Right hand */

                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/   KC_F,   /**/   KC_G,   /**/   KC_C,   /**/   KC_R,   /**/   KC_L,   /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*===============*/   KC_D,   /**/   KC_H,   /**/   KC_T,   /**/   KC_N,   /**/   KC_S,   /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/   KC_B,   /**/   KC_M,   /**/   KC_W,   /**/   KC_V,   /**/   KC_Z,   /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/  ___, /**/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /*=======================================================================*/
        /*==============================*/
        /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/
        /*=============================================*/
        /**/           /**/           /**/           /**/
        /**/ _______,  /**/           /**/           /**/
        /**/           /**/           /**/           /**/
        /*===============*/           /**/           /**/
        /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______   /**/
        /**/           /**/           /**/           /**/
        /*=============================================*/
    ),

    [_COMMON] = LAYOUT_ergodox(
        /* Left hand */

        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ KC_ESCAPE,/**/   KC_1,   /**/   KC_2,   /**/   KC_3,   /**/   KC_4,   /**/   KC_5,   /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ KC_TAB,   /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/MO(_SYMBOLS),   _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /*===============*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/KC_LSFT,   /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/LT(_NUMPAD,KC_TAB),
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
            /**/       /**/           /**/           /**/           /**/           /**/
            /**/  ___, /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
            /**/       /**/           /**/           /**/           /**/           /**/
            /*=======================================================================*/
                                                                                               /*==============================*/
                                                                                               /**/           /**/           /**/
                                                                                               /**/ KC_SPACE, /**/ _______,  /**/
                                                                                               /**/           /**/           /**/
                                                                                /*=============================================*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /**/ KC_AUDIO_VOL_DOWN,
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /*===============*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/ KC_BSPC,  /**/ _______,  /**/ KC_ENTER, /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /*=============================================*/

        /* Right hand */

                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/   KC_6,   /**/   KC_7,   /**/   KC_8,   /**/   KC_9,   /**/   KC_0,   /**/  KC_F12,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ KC_HYPR,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ KC_BSLS,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*===============*/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/MO(_SYMBOLS),//
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/  KC_MEH,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/KC_RSFT,   /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/TT(_MISC),
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /*=======================================================================*/
          /*==============================*/
          /**/           /**/           /**/
          /**/ _______,  /**/ KC_CAPS,  /**/
          /**/           /**/           /**/
          /*=============================================*/
          /**/           /**/           /**/           /**/
         KC_AUDIO_VOL_UP,/**/           /**/           /**/
          /**/           /**/           /**/           /**/
          /*===============*/           /**/           /**/
          /**/           /**/           /**/           /**/
          /**/ KC_ESCAPE,/**/ KC_ENTER, /**/  KC_SPACE /**/
          /**/           /**/           /**/           /**/
          /*=============================================*/
    ),

    [_MAC] = LAYOUT_ergodox(
        /* Left hand */

        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/LCTL(LGUI(LSFT(KC_4))),
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______  ,/**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/LALT(KC_BSPC),
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /*===============*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
            /**/       /**/           /**/           /**/           /**/           /**/
              KC_LCTL, /**/ KC_LGUI,  /**/  KC_LALT, /**/MO(_WM_MAC),   MO(_ARROWS_MAC),
            /**/       /**/           /**/           /**/           /**/           /**/
            /*=======================================================================*/
                                                                                               /*==============================*/
                                                                                               /**/           /**/           /**/
                                                                                               /**/ _______,  /**/LCTL(LGUI(KC_Q)),
                                                                                               /**/           /**/           /**/
                                                                                /*=============================================*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /**/ _______,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /*===============*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/ _______,  /**/ KC_LGUI,  /**/ _______,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /*=============================================*/

        /* Right hand */

                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                  RGUI(RSFT(KC_7)),/**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*===============*/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  MO(_ARROWS_MAC),  MO(_WM_MAC),/**/ KC_LALT,  /**/ KC_LGUI,  /**/  ___, /**/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /*=======================================================================*/
          /*==============================*/
          /**/           /**/           /**/
        LCTL(LGUI(KC_Q)),/**/ KC_CAPS,  /**/
          /**/           /**/           /**/
          /*=============================================*/
          /**/           /**/           /**/           /**/
          /**/ _______,  /**/           /**/           /**/
          /**/           /**/           /**/           /**/
          /*===============*/           /**/           /**/
          /**/           /**/           /**/           /**/
          /**/ _______,  /**/ _______,  /**/ _______   /**/
          /**/           /**/           /**/           /**/
          /*=============================================*/
    ),

    [_WINDOWS] = LAYOUT_ergodox(
        /* Left hand */

        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/LGUI(LSFT(KC_S)),
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/LCTL(KC_BSPC),
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /*===============*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
            /**/       /**/           /**/           /**/           /**/           /**/
              KC_LGUI, /**/ KC_LCTL,  /**/  KC_LALT,   MO(_WM_WINDOWS), MO(_ARROWS_WINDOWS),
            /**/       /**/           /**/           /**/           /**/           /**/
            /*=======================================================================*/
                                                                                               /*==============================*/
                                                                                               /**/           /**/           /**/
                                                                                               /**/ _______,  /**/LGUI(KC_L),/**/
                                                                                               /**/           /**/           /**/
                                                                                /*=============================================*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /**/ _______,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /*===============*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/ _______,  /**/ KC_LCTL,  /**/ _______,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /*=============================================*/

        /* Right hand */

                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                  LALT(KC_PSCR),   /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*===============*/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                              MO(_ARROWS_WINDOWS), MO(_WM_WINDOWS),  KC_RALT,  /**/ KC_RCTL,  /**/  ___, /**/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /*=======================================================================*/
        /*==============================*/
        /**/           /**/           /**/
        /**/LGUI(KC_L),/**/ _______,  /**/
        /**/           /**/           /**/
        /*=============================================*/
        /**/           /**/           /**/           /**/
        /**/ _______,  /**/           /**/           /**/
        /**/           /**/           /**/           /**/
        /*===============*/           /**/           /**/
        /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______   /**/
        /**/           /**/           /**/           /**/
        /*=============================================*/
    ),

    [_NUMPAD] = LAYOUT_ergodox(
        /* Left hand */

        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /*===============*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
            /**/       /**/           /**/           /**/           /**/           /**/
            /**/  ___, /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
            /**/       /**/           /**/           /**/           /**/           /**/
            /*=======================================================================*/
                                                                                               /*==============================*/
                                                                                               /**/           /**/           /**/
                                                                                               /**/ _______,  /**/ _______,  /**/
                                                                                               /**/           /**/           /**/
                                                                                /*=============================================*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /**/ _______,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /*===============*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/ _______,  /**/ _______,  /**/ _______,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /*=============================================*/

        /* Right hand */

                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/ XXXXXXX,  /**/ KC_ESCAPE, LALT(KC_KP_MINUS),  KC_PERC, /**/KC_KP_SLASH,    _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/ XXXXXXX,  /**/ KC_KP_7,  /**/ KC_KP_8,  /**/ KC_KP_9,  /**/KC_KP_ASTERISK, _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*===============*/ KC_COLN,  /**/ KC_KP_4,  /**/ KC_KP_5,  /**/ KC_KP_6,  /**/KC_KP_MINUS,    _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/ KC_COMMA, /**/ KC_KP_1,  /**/ KC_KP_2,  /**/ KC_KP_3,  /**/KC_KP_PLUS,/**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /**/  KC_0,    /**/   KC_0,   /**/  KC_DOT,  /**/KC_KP_ENTER,     ___, /**/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /*=======================================================================*/
        /*==============================*/
        /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/
        /*=============================================*/
        /**/           /**/           /**/           /**/
        /**/ _______,  /**/           /**/           /**/
        /**/           /**/           /**/           /**/
        /*===============*/           /**/           /**/
        /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ KC_0      /**/
        /**/           /**/           /**/           /**/
        /*=============================================*/
    ),

    [_SYMBOLS] = LAYOUT_ergodox(
        /* Left hand */

        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/  KC_F1,   /**/  KC_F2,   /**/  KC_F3,   /**/  KC_F4,   /**/  KC_F5,   /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ KC_EXLM,  /**/  KC_AT,   /**/ KC_LCBR,  /**/ KC_RCBR,  /**/ KC_PERC,  /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
       LGUI(KC_BSPC),  /**/ KC_HASH,  /**/ KC_UNDS,  /**/ KC_LPRN,  /**/ KC_RPRN,  /**/ KC_AMPR,  /*===============*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ KC_BSLS,  /**/ KC_SLASH, /**/KC_LBRC,        KC_RBRC,  /**/ KC_TILD,  /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
            /**/       /**/           /**/           /**/           /**/           /**/
            /**/  ___, /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
            /**/       /**/           /**/           /**/           /**/           /**/
            /*=======================================================================*/
                                                                                               /*==============================*/
                                                                                               /**/           /**/           /**/
                                                                                               /**/ _______,  /**/ _______,  /**/
                                                                                               /**/           /**/           /**/
                                                                                /*=============================================*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /**/ _______,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /*===============*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/ _______,  /**/ _______,  /**/ _______,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /*=============================================*/

        /* Right hand */

                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/  KC_F6,   /**/   KC_F7,  /**/  KC_F8,   /**/  KC_F9,   /**/  KC_F10,  /**/  KC_F11,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/ KC_CIRC,  /**/KC_KP_PLUS,/**/KC_KP_MINUS,    KC_GRAVE, /**/ KC_SCLN,  /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*===============*/ KC_PIPE,  /**/ KC_EQUAL, /**/ KC_QUOTE, /**/ KC_COLN,  /**/ KC_DQUO,  /**/LGUI(KC_DELETE),
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/  KC_DLR,  /**/ KC_ASTR,  /**/  KC_LABK, /**/ KC_RABK,  /**/ KC_SLASH, /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/  ___, /**/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /*=======================================================================*/
        /*==============================*/
        /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/
        /*=============================================*/
        /**/           /**/           /**/           /**/
        /**/ _______,  /**/           /**/           /**/
        /**/           /**/           /**/           /**/
        /*===============*/           /**/           /**/
        /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______   /**/
        /**/           /**/           /**/           /**/
        /*=============================================*/
    ),

    [_WM_MAC] = LAYOUT_ergodox(
        /* Left hand */

        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______,  /**/  OC(KC_C), /**/ _______,  /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ OC(KC_U), OC(LGUI(KC_LEFT)),OC(KC_ENTER),OC(LGUI(KC_RIGHT)), OC(KC_I),/**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ OC(KC_J),    OC(KC_LEFT),  OC(KC_BSPC),    OC(KC_RIGHT),    OC(KC_K), /*===============*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/   KC_UP,  /**/ OC(KC_E), /**/ OC(KC_F), /**/ OC(KC_T), /**/ OC(KC_G), /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
            /**/       /**/           /**/           /**/           /**/           /**/
            /**/KC_LEFT,     KC_DOWN, /**/ KC_RIGHT, /**/ _______,  /**/ _______,  /**/
            /**/       /**/           /**/           /**/           /**/           /**/
            /*=======================================================================*/
                                                                                               /*==============================*/
                                                                                               /**/           /**/           /**/
                                                                                               /**/ _______,  /**/ _______,  /**/
                                                                                               /**/           /**/           /**/
                                                                                /*=============================================*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /**/ _______,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /*===============*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/ _______,  /**/ _______,  /**/ _______,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /*=============================================*/

        /* Right hand */

                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/ _______,  /**/ _______,  /**/  OC(KC_C), /**/ _______,  /**/ _______, /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/ OC(KC_U), OC(LGUI(KC_LEFT)),OC(KC_ENTER),OC(LGUI(KC_RIGHT)), OC(KC_I),/**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*===============*/ OC(KC_J),    OC(KC_LEFT),  OC(KC_BSPC),    OC(KC_RIGHT),    OC(KC_K), /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/ OC(KC_D), /**/ OC(KC_E), /**/ OC(KC_F), /**/ OC(KC_T), /**/  KC_UP,   /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /**/ _______,  /**/ _______,  /**/ KC_LEFT,  /**/  KC_DOWN, /**/KC_RIGHT,//
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /*=======================================================================*/
        /*==============================*/
        /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/
        /*=============================================*/
        /**/           /**/           /**/           /**/
        /**/ _______,  /**/           /**/           /**/
        /**/           /**/           /**/           /**/
        /*===============*/           /**/           /**/
        /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______   /**/
        /**/           /**/           /**/           /**/
        /*=============================================*/
    ),

    [_ARROWS_MAC] = LAYOUT_ergodox(
        /* Left hand */

        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/LGUI(KC_Q),/**/LGUI(KC_W),/**/LGUI(KC_F),/**/LGUI(KC_P),/**/LGUI(KC_G),/**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ KC_LCTL,  /**/ KC_LGUI,  /**/ KC_LSFT,  /**/ KC_LALT,  /**/LGUI(KC_D),/*===============*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/LGUI(KC_Z),/**/LGUI(KC_X),/**/LGUI(KC_C),/**/LGUI(KC_V),/**/LGUI(KC_B),/**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
            /**/       /**/           /**/           /**/           /**/           /**/
            /**/  ___, /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
            /**/       /**/           /**/           /**/           /**/           /**/
            /*=======================================================================*/
                                                                                               /*==============================*/
                                                                                               /**/           /**/           /**/
                                                                                               /**/ _______,  /**/ _______,  /**/
                                                                                               /**/           /**/           /**/
                                                                                /*=============================================*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /**/ _______,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /*===============*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/ _______,  /**/ _______,  /**/ _______,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /*=============================================*/

        /* Right hand */

                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/RGUI(KC_J),/**/ KC_BSPC,  /**/  KC_UP,   /**/ KC_DELETE,  RGUI(KC_SCLN),    _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*===============*/RGUI(KC_H),/**/ KC_LEFT,  /**/ KC_DOWN,  /**/ KC_RIGHT, /**/ KC_ENTER, /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/RGUI(KC_K),/**/RGUI(KC_M),  RGUI(KC_COMMA), RGUI(KC_DOT), RGUI(KC_SLASH),   _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/  ___, /**/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /*=======================================================================*/
        /*==============================*/
        /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/
        /*=============================================*/
        /**/           /**/           /**/           /**/
        /**/ _______,  /**/           /**/           /**/
        /**/           /**/           /**/           /**/
        /*===============*/           /**/           /**/
        /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______   /**/
        /**/           /**/           /**/           /**/
        /*=============================================*/
    ),

    [_ARROWS_WINDOWS] = LAYOUT_ergodox(
        /* Left hand */

        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/LCTL(KC_Q),/**/LCTL(KC_W),/**/LCTL(KC_F),/**/LCTL(KC_P),/**/LCTL(KC_G),/**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ KC_LGUI,  /**/ KC_HYPR,  /**/ KC_LSFT,  /**/ KC_LCTL,  /**/LCTL(KC_D),/*===============*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/LCTL(KC_Z),/**/LCTL(KC_X),/**/LCTL(KC_C),/**/LCTL(KC_V),/**/LCTL(KC_B),/**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
            /**/       /**/           /**/           /**/           /**/           /**/
            /**/  ___, /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
            /**/       /**/           /**/           /**/           /**/           /**/
            /*=======================================================================*/
                                                                                               /*==============================*/
                                                                                               /**/           /**/           /**/
                                                                                               /**/ _______,  /**/ _______,  /**/
                                                                                               /**/           /**/           /**/
                                                                                /*=============================================*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /**/ _______,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /*===============*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/ _______,  /**/ _______,  /**/ _______,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /*=============================================*/

        /* Right hand */

                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/RCTL(KC_J),/**/ KC_BSPC,  /**/  KC_UP,   /**/ KC_DELETE,  RCTL(KC_SCLN),    _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*===============*/RCTL(KC_H),/**/ KC_LEFT,  /**/ KC_DOWN,  /**/ KC_RIGHT, /**/ KC_ENTER, /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/RCTL(KC_K),/**/RCTL(KC_M),  RCTL(KC_COMMA), RCTL(KC_DOT), RCTL(KC_SLASH),   _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/  ___, /**/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /*=======================================================================*/
        /*==============================*/
        /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/
        /*=============================================*/
        /**/           /**/           /**/           /**/
        /**/ _______,  /**/           /**/           /**/
        /**/           /**/           /**/           /**/
        /*===============*/           /**/           /**/
        /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______   /**/
        /**/           /**/           /**/           /**/
        /*=============================================*/
    ),

    [_MISC] = LAYOUT_ergodox(
        /* Left hand */

        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/  KC_F14,  /**/  KC_F15,  /**/ _______,  /**/ _______,  /**/ _______,  /**/   QK_BOOT,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______,  /**/ KC_MS_UP, /**/ _______,  /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/KC_MS_LEFT,/**/KC_MS_DOWN,/**/KC_MS_RIGHT,    _______,  /*===============*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
            /**/       /**/           /**/           /**/           /**/           /**/
            /**/  ___, /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
            /**/       /**/           /**/           /**/           /**/           /**/
            /*=======================================================================*/
                                                                                               /*==============================*/
                                                                                               /**/           /**/           /**/
                                                                                               /**/ RGB_MOD,  /**/HSV_0_255_255,
                                                                                               /**/           /**/           /**/
                                                                                /*=============================================*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /**/HSV_120_255_128,
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /*===============*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/KC_MS_BTN1,/**/KC_MS_BTN2,/**/HSV_240_255_255,
                                                                                /**/           /**/           /**/           /**/
                                                                                /*=============================================*/

        /* Right hand */

                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/KC_MEDIA_EJECT,
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*===============*/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/ _______,  /**/ _______,  /**/ _______,  /**/ _______,  /**/DF(_DVORAK),   DF(_QWERTY),   DF(_COLEMAK),//
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /**/ _______,  /**/ _______,     WINDOWS_MODE,    MAC_MODE, /**/  ___, /**/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /*=======================================================================*/
        /*==============================*/
        /**/           /**/           /**/
        /**/ RGB_TOG,  /**/ RGB_SLD,  /**/
        /**/           /**/           /**/
        /*=============================================*/
        /**/           /**/           /**/           /**/
        /**/ RGB_VAI,  /**/           /**/           /**/
        /**/           /**/           /**/           /**/
        /*===============*/           /**/           /**/
        /**/           /**/           /**/           /**/
        /**/ RGB_VAD,  /**/ RGB_HUD,  /**/ RGB_HUI   /**/
        /**/           /**/           /**/           /**/
        /*=============================================*/
    ),

    /* clang-format on */
};

bool suspended = false;

bool process_record_user(uint16_t keycode, keyrecord_t *record) {
    switch (keycode) {
        case QK_CLEAR_EEPROM:
            if (record->event.pressed) {
                eeconfig_init();
            }
            return false;
            break;
        case RGB_SLD:
            if (record->event.pressed) {
                rgblight_mode(1);
            }
            return false;
            break;
        case HSV_0_255_255:
            if (record->event.pressed) {
#ifdef RGBLIGHT_ENABLE
                rgblight_enable();
                rgblight_mode(1);
                rgblight_sethsv(0, 255, 255);
#endif
            }
            return false;
            break;
        case HSV_120_255_128:
            if (record->event.pressed) {
#ifdef RGBLIGHT_ENABLE
                rgblight_enable();
                rgblight_mode(1);
                rgblight_sethsv(120, 255, 128);
#endif
            }
            return false;
            break;
        case HSV_240_255_255:
            if (record->event.pressed) {
#ifdef RGBLIGHT_ENABLE
                rgblight_enable();
                rgblight_mode(1);
                rgblight_sethsv(240, 255, 255);
#endif
            }
            return false;
            break;
        case MAC_MODE:
            if (record->event.pressed) {
                layer_on(_MAC);
                layer_off(_WINDOWS);
            }
            return false;
            break;
        case WINDOWS_MODE:
            if (record->event.pressed) {
                layer_on(_WINDOWS);
                layer_off(_MAC);
            }
            return false;
            break;
    }
    return true;
}

layer_state_t layer_state_set_user(layer_state_t state) {
    uint8_t layer = get_highest_layer(state);

    ergodox_board_led_off();
    ergodox_right_led_1_off();
    ergodox_right_led_2_off();
    ergodox_right_led_3_off();

    if (layer == _ARROWS_MAC || layer == _ARROWS_WINDOWS) {
        ergodox_right_led_1_on();
    } else if (layer == _SYMBOLS) {
        ergodox_right_led_2_on();
    } else if (layer == _NUMPAD) {
        ergodox_right_led_1_on();
        ergodox_right_led_2_on();
    } else if (layer == _WM_MAC || layer == _WM_WINDOWS) {
        ergodox_right_led_2_on();
        ergodox_right_led_3_on();
    } else if (layer == _MISC) {
        ergodox_right_led_1_on();
        ergodox_right_led_2_on();
        ergodox_right_led_3_on();
    } else if (layer == _WINDOWS) {
        ergodox_right_led_3_on();
    } else if (layer == _MAC) {
        /* do nothing */
    }

    return state;
};

void keyboard_post_init_user(void) {
    /* This layer is always on */
    layer_on(_COMMON);

    /* Default to Mac layout */
    layer_on(_MAC);
}
