#include QMK_KEYBOARD_H

#include "debug.h"
#include "action_layer.h"

#define BASE   0  // Base layer - QWERTY
#define SPEC   1  // Special keys favoring programming in c-like languages
#define NUM    2  // Numeric layer with number row functional keys

#define ___     KC_TRNS
#define BSLASH  LSFT(KC_SLSH)


const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {

    [BASE] = LAYOUT_ergodox(

    // Left side
        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/  KC_VOLU, /**/   KC_1,   /**/   KC_2,   /**/   KC_3,   /**/   KC_4,   /**/   KC_5,   /**/  KC_F11,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/  KC_VOLD, /**/   KC_Q,   /**/    KC_W,  /**/   KC_E,   /**/   KC_R,   /**/   KC_T,   /**/  KC_ESC,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/  KC_MPLY, /**/   KC_A,   /**/   KC_S,   /**/   KC_D,   /**/   KC_F,   /**/   KC_G,   /*===============*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/  KC_MUTE, /**/   KC_Z,   /**/    KC_X,  /**/   KC_C,   /**/   KC_V,   /**/   KC_B,   /**/  KC_BSPC, /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
            /**/       /**/           /**/           /**/           /**/           /**/
            /**/  ___, /**/   ___,    /**/    ___,   /**/  KC_RALT, /**/ KC_LCTL,  /**/
            /**/       /**/           /**/           /**/           /**/           /**/
            /*=======================================================================*/


                                                                                               /*==============================*/
                                                                                               /**/           /**/           /**/
                                                                                               /**/    ___,   /**/  KC_DEL,  /**/
                                                                                               /**/           /**/           /**/
                                                                                /*=============================================*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /**/  KC_LALT, /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /*===============*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/ KC_SPACE, /**/  KC_LGUI, /**/ KC_LCTL,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /*=============================================*/

    // Right side
        //
                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/  KC_F12,  /**/   KC_1,   /**/   KC_2,   /**/   KC_3,   /**/   KC_4,   /**/   KC_5,   /**/    ___,   /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/    ___,   /**/   KC_Y,   /**/   KC_U,   /**/   KC_I,   /**/   KC_O,   /**/   KC_P,   /**/    ___,   /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*===============*/   KC_H,   /**/   KC_J,   /**/   KC_K,   /**/   KC_L,   /**/  KC_SCLN, /**/    ___,   /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/  KC_ENT,  /**/   KC_N,   /**/   KC_M,   /**/  KC_COMM, /**/  KC_DOT,  /**/  KC_SLSH, /**/    ___,   /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /**/  MO(NUM), /**/   ___,    /**/    ___,   /**/    ___,   /**/  ___, /**/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /*=======================================================================*/

        /*==============================*/
        /**/           /**/           /**/
        /**/    ___,   /**/    ___,   /**/
        /**/           /**/           /**/
        /*=============================================*/
        /**/           /**/           /**/           /**/
        /**/    ___,   /**/           /**/           /**/
        /**/           /**/           /**/           /**/
        /*===============*/           /**/           /**/
        /**/           /**/           /**/           /**/
        /**/    ___,   /**/  KC_RSFT, /**/ MO(SPEC)  /**/
        /**/           /**/           /**/           /**/
        /*=============================================*/
    ),


    [SPEC] = LAYOUT_ergodox(

    // Left side
        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/    ___,   /**/  KC_EXLM, /**/   KC_AT,  /**/  KC_HASH, /**/  KC_DLR,  /**/  KC_PERC, /**/    ___,   /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/    ___,   /**/  KC_GRV,  /**/  KC_QUOT, /**/  KC_LCBR, /**/  KC_RCBR, /**/  KC_PLUS, /**/  KC_ESC,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/    ___,   /**/  KC_TAB,  /**/  KC_ASTR, /**/  KC_LPRN, /**/  KC_RPRN, /**/ KC_EQUAL, /*===============*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/    ___,   /**/  KC_HASH, /**/  KC_PERC, /**/  KC_LBRC, /**/  KC_RBRC, /**/ KC_MINUS, /**/  KC_BSPC, /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
            /**/       /**/           /**/           /**/           /**/           /**/
            /**/  ___, /**/   ___,    /**/    ___,   /**/  KC_LALT, /**/ KC_LCTL,  /**/
            /**/       /**/           /**/           /**/           /**/           /**/
            /*=======================================================================*/


                                                                                               /*==============================*/
                                                                                               /**/           /**/           /**/
                                                                                               /**/    ___,   /**/  KC_DEL,  /**/
                                                                                               /**/           /**/           /**/
                                                                                /*=============================================*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /**/  KC_LALT, /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /*===============*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/ KC_SPACE, /**/  KC_LGUI, /**/ KC_LCTL,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /*=============================================*/

    // Right side
        //
                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/    ___,   /**/  KC_CIRC, /**/  KC_AMPR, /**/  KC_ASTR, /**/  KC_LPRN, /**/  KC_RPRN, /**/    ___,   /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/    ___,   /**/  KC_AMPR, /**/  KC_HOME, /**/   KC_UP,  /**/  KC_END,  /**/  KC_CIRC, /**/   KC_F7,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*===============*/  KC_EXLM, /**/  KC_LEFT, /**/  KC_DOWN, /**/ KC_RIGHT, /**/  KC_COLN, /**/   KC_F8,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/  KC_ENT,  /**/  KC_PIPE, /**/  KC_UNDS, /**/   KC_LT,  /**/   KC_GT,  /**/  KC_BSLS, /**/   KC_F9,  /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /**/    ___,   /**/   ___,    /**/    ___,   /**/    ___,   /**/KC_F10,/**/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /*=======================================================================*/

        /*==============================*/
        /**/           /**/           /**/
        /**/    ___,   /**/    ___,   /**/
        /**/           /**/           /**/
        /*=============================================*/
        /**/           /**/           /**/           /**/
        /**/    ___,   /**/           /**/           /**/
        /**/           /**/           /**/           /**/
        /*===============*/           /**/           /**/
        /**/           /**/           /**/           /**/
        /**/    ___,   /**/  KC_RSFT, /**/    ___    /**/
        /**/           /**/           /**/           /**/
        /*=============================================*/
    ),

    [NUM] = LAYOUT_ergodox(

    // Left side
        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/    ___,   /**/   KC_F1,  /**/   KC_F2,  /**/   KC_F3,  /**/   KC_F4,  /**/   KC_F5,  /**/  KC_F11,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/    ___,   /**/  KC_EXLM, /**/   KC_AT,  /**/  KC_HASH, /**/  KC_DLR,  /**/  KC_PERC, /**/  KC_ESC,  /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/    ___,   /**/   KC_1,   /**/   KC_2,   /**/   KC_3,   /**/   KC_4,   /**/   KC_5,   /*===============*/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*==========================================================================================*/           /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /**/    ___,   /**/  KC_HASH, /**/  KC_PERC, /**/  KC_LBRC, /**/  KC_RBRC, /**/ KC_MINUS, /**/  KC_BSPC, /**/
        /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
        /*=========================================================================================================*/
            /**/       /**/           /**/           /**/           /**/           /**/
            /**/  ___, /**/   ___,    /**/    ___,   /**/  KC_LALT, /**/ KC_LCTL,  /**/
            /**/       /**/           /**/           /**/           /**/           /**/
            /*=======================================================================*/


                                                                                               /*==============================*/
                                                                                               /**/           /**/           /**/
                                                                                               /**/    ___,   /**/  KC_DEL,  /**/
                                                                                               /**/           /**/           /**/
                                                                                /*=============================================*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /**/  KC_LALT, /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/           /**/           /*===============*/
                                                                                /**/           /**/           /**/           /**/
                                                                                /**/ KC_SPACE, /**/  KC_LGUI, /**/ KC_LCTL,  /**/
                                                                                /**/           /**/           /**/           /**/
                                                                                /*=============================================*/

    // Right side
        //
                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/  KC_F12,  /**/   KC_F6,  /**/   KC_F7,  /**/   KC_F8,  /**/   KC_F9,  /**/  KC_F10,  /**/    ___,   /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/    ___,   /**/  KC_CIRC, /**/  KC_AMPR, /**/  KC_ASTR, /**/  KC_LPRN, /**/  KC_RPRN, /**/    ___,   /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*===============*/   KC_6,   /**/   KC_7,   /**/   KC_8,   /**/   KC_9,   /**/   KC_0,   /**/    ___,   /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/           /*==========================================================================================*/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /**/  KC_ENT,  /**/  KC_PIPE, /**/  KC_UNDS, /**/  KC_COMM, /**/  KC_DOT,  /**/  KC_BSLS, /**/    ___,   /**/
                    /**/           /**/           /**/           /**/           /**/           /**/           /**/           /**/
                    /*=========================================================================================================*/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /**/    ___,   /**/   ___,    /**/    ___,   /**/    ___,   /**/  ___, /**/
                                                  /**/           /**/           /**/           /**/           /**/       /**/
                                                  /*=======================================================================*/

        /*==============================*/
        /**/           /**/           /**/
        /**/    ___,   /**/    ___,   /**/
        /**/           /**/           /**/
        /*=============================================*/
        /**/           /**/           /**/           /**/
        /**/    ___,   /**/           /**/           /**/
        /**/           /**/           /**/           /**/
        /*===============*/           /**/           /**/
        /**/           /**/           /**/           /**/
        /**/    ___,   /**/  KC_RSFT, /**/    ___    /**/
        /**/           /**/           /**/           /**/
        /*=============================================*/
    ),

};
