#include QMK_KEYBOARD_H

const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {
  [0] = LAYOUT_ergodox(KC_GRAVE,KC_1,KC_2,KC_3,KC_4,KC_5,KC_MINUS,KC_TAB,KC_Q,KC_W,KC_E,KC_R,KC_T,KC_LPRN,KC_ESCAPE,KC_A,KC_S,KC_D,KC_F,KC_G,KC_LSFT,KC_Z,KC_X,KC_C,KC_V,KC_B,KC_RPRN,KC_LCTL,KC_LGUI,KC_LALT,KC_LGUI,KC_LALT,KC_INSERT,MO(1),KC_HOME,KC_SPACE,KC_DELETE,KC_END,KC_EQUAL,KC_6,KC_7,KC_8,KC_9,KC_0,KC_BSPC,KC_LBRC,KC_Y,KC_U,KC_I,KC_O,KC_P,KC_BSLS,KC_H,KC_J,KC_K,KC_L,KC_SCLN,KC_QUOTE,KC_RBRC,KC_N,KC_M,KC_COMMA,KC_DOT,KC_SLASH,KC_RSFT,KC_LEFT,KC_DOWN,KC_UP,KC_RIGHT,KC_RCTL,MO(1),TG(2),KC_PGUP,KC_PGDN,KC_BSPC,KC_ENTER),

  [1] = LAYOUT_ergodox(KC_TILD,KC_F1,KC_F2,KC_F3,KC_F4,KC_F5,KC_F6,KC_GRAVE,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_CAPS,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_MEDIA_PLAY_PAUSE,KC_TRANSPARENT,KC_TRANSPARENT,KC_F7,KC_F8,KC_F9,KC_F10,KC_F11,KC_F12,KC_BSPC,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,LCTL(LGUI(KC_Q)),KC_MEDIA_PREV_TRACK,KC_MEDIA_NEXT_TRACK,KC_AUDIO_VOL_DOWN,KC_AUDIO_VOL_UP),

  [2] = LAYOUT_ergodox(KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_NUM,KC_KP_SLASH,KC_KP_ASTERISK,KC_KP_MINUS,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_KP_7,KC_KP_8,KC_KP_9,KC_KP_PLUS,KC_TRANSPARENT,KC_TRANSPARENT,KC_KP_4,KC_KP_5,KC_KP_6,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_KP_1,KC_KP_2,KC_KP_3,KC_ENTER,KC_TRANSPARENT,KC_KP_DOT,KC_KP_0,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT,KC_TRANSPARENT),

};

layer_state_t layer_state_set_user(layer_state_t state) {

    uint8_t layer = get_highest_layer(state);

    ergodox_led_all_off();
    ergodox_board_led_1_off();
    ergodox_board_led_2_off();
    ergodox_board_led_3_off();
    switch (layer) {
      case 1:
        ergodox_board_led_1_on();
        break;
      case 2:
        ergodox_board_led_2_on();
        break;
      case 3:
        ergodox_board_led_2_on();
        break;
      case 4:
        ergodox_board_led_1_on();
        ergodox_board_led_2_on();
        break;
      case 5:
        ergodox_board_led_1_on();
        ergodox_board_led_3_on();
        break;
      case 6:
        ergodox_board_led_2_on();
        ergodox_board_led_3_on();
        break;
      case 7:
        ergodox_board_led_1_on();
        ergodox_board_led_2_on();
        ergodox_board_led_3_on();
        break;
      default:
        break;
    }
    return state;

};
