#pragma once

#include "quantum.h"

// layout with all the switches supported by the PCB
#define LAYOUT_all( \
	K000, K001, K002, K003,       K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015, \
	K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
	K200,       K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, K214, K215, \
	K300,       K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313,             \
	K400, K401, K402, K403, K404, K405, K406, K407, K408, K409, K410, K411,       K413, K414,       \
	K500, K501, K502,             K505,                         K510, K511, K512, K513, K514, K515  \
) { \
	{ K000,  K001,  K002,  K003,  KC_NO, K005,  K006,  K007,  K008,  K009,  K010,  K011,  K012,  K013,  K014,  K015 }, \
	{ K100,  K101,  K102,  K103,  K104,  K105,  K106,  K107,  K108,  K109,  K110,  K111,  K112,  K113,  K114,  K115 }, \
	{ K200,  KC_NO, K202,  K203,  K204,  K205,  K206,  K207,  K208,  K209,  K210,  K211,  K212,  K213,  K214,  K215 }, \
	{ K300,  KC_NO, K302,  K303,  K304,  K305,  K306,  K307,  K308,  K309,  K310,  K311,  K312,  K313,  KC_NO, KC_NO }, \
	{ K400,  K401,  K402,  K403,  K404,  K405,  K406,  K407,  K408,  K409,  K410,  K411,  KC_NO, K413,  K414,  KC_NO }, \
	{ K500,  K501,  K502,  KC_NO, KC_NO, K505,  KC_NO, KC_NO, KC_NO, KC_NO, K510,  K511,  K512,  K513,  K514,  K515 }  \
}

#define LAYOUT_75_ansi( \
	K000, K001, K002, K003,       K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015, \
	K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112,       K114, K115, \
	K200,       K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, K214, K215, \
	K300,       K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313,             \
	K400,       K402, K403, K404, K405, K406, K407, K408, K409, K410, K411,       K413, K414,       \
	K500, K501, K502,             K505,                         K510,       K512, K513, K514, K515  \
) { \
	{ K000,  K001,  K002,  K003,  KC_NO, K005,  K006,  K007,  K008,  K009,  K010,  K011,  K012,  K013,  K014,  K015 }, \
	{ K100,  K101,  K102,  K103,  K104,  K105,  K106,  K107,  K108,  K109,  K110,  K111,  K112, KC_NO,  K114,  K115 }, \
	{ K200,  KC_NO, K202,  K203,  K204,  K205,  K206,  K207,  K208,  K209,  K210,  K211,  K212,  K213,  K214,  K215 }, \
	{ K300,  KC_NO, K302,  K303,  K304,  K305,  K306,  K307,  K308,  K309,  K310,  K311,  K312,  K313,  KC_NO, KC_NO }, \
	{ K400,  KC_NO, K402,  K403,  K404,  K405,  K406,  K407,  K408,  K409,  K410,  K411,  KC_NO, K413,  K414,  KC_NO }, \
	{ K500,  K501,  K502,  KC_NO, KC_NO, K505,  KC_NO, KC_NO, KC_NO, KC_NO, K510,  KC_NO,  K512,  K513,  K514,  K515 }  \
}

// Ansi layout with a 7u space bar
#define LAYOUT_75_ansi_7u( \
	K000, K001, K002, K003,       K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015, \
	K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112,       K114, K115, \
	K200,       K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, K214, K215, \
	K300,       K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313,             \
	K400,       K402, K403, K404, K405, K406, K407, K408, K409, K410, K411,       K413, K414,       \
	K500, K501,                   K505,                         K510,       K512, K513, K514, K515  \
) { \
	{ K000,  K001,  K002,  K003,  KC_NO, K005,  K006,  K007,  K008,  K009,  K010,  K011,  K012,  K013,  K014,  K015 }, \
	{ K100,  K101,  K102,  K103,  K104,  K105,  K106,  K107,  K108,  K109,  K110,  K111,  K112, KC_NO,  K114,  K115 }, \
	{ K200,  KC_NO, K202,  K203,  K204,  K205,  K206,  K207,  K208,  K209,  K210,  K211,  K212,  K213,  K214,  K215 }, \
	{ K300,  KC_NO, K302,  K303,  K304,  K305,  K306,  K307,  K308,  K309,  K310,  K311,  K312,  K313,  KC_NO, KC_NO }, \
	{ K400,  KC_NO, K402,  K403,  K404,  K405,  K406,  K407,  K408,  K409,  K410,  K411,  KC_NO, K413,  K414,  KC_NO }, \
	{ K500,  K501,  KC_NO, KC_NO, KC_NO, K505,  KC_NO, KC_NO, KC_NO, KC_NO, K510,  KC_NO,  K512,  K513,  K514,  K515 }  \
}

// ANSI layout with split backspace
#define LAYOUT_75_ansi_splitbs( \
	K000, K001, K002, K003,       K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015, \
	K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
	K200,       K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, K214, K215, \
	K300,       K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313,             \
	K400      , K402, K403, K404, K405, K406, K407, K408, K409, K410, K411,       K413, K414,       \
	K500, K501, K502,             K505,                         K510,       K512, K513, K514, K515  \
) { \
	{ K000,  K001,  K002,  K003,  KC_NO, K005,  K006,  K007,  K008,  K009,  K010,  K011,  K012,  K013,  K014,  K015 }, \
	{ K100,  K101,  K102,  K103,  K104,  K105,  K106,  K107,  K108,  K109,  K110,  K111,  K112,  K113,  K114,  K115 }, \
	{ K200,  KC_NO, K202,  K203,  K204,  K205,  K206,  K207,  K208,  K209,  K210,  K211,  K212,  K213,  K214,  K215 }, \
	{ K300,  KC_NO, K302,  K303,  K304,  K305,  K306,  K307,  K308,  K309,  K310,  K311,  K312,  K313,  KC_NO, KC_NO }, \
	{ K400,  KC_NO,  K402,  K403,  K404,  K405,  K406,  K407,  K408,  K409,  K410,  K411,  KC_NO, K413,  K414,  KC_NO }, \
	{ K500,  K501,  K502,  KC_NO, KC_NO, K505,  KC_NO, KC_NO, KC_NO, KC_NO, K510,  KC_NO,  K512,  K513,  K514,  K515 }  \
}

// ANSI layout with split backspace
#define LAYOUT_75_ansi_7u_splitbs( \
	K000, K001, K002, K003,       K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015, \
	K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112, K113, K114, K115, \
	K200,       K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213, K214, K215, \
	K300,       K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K313,             \
	K400      , K402, K403, K404, K405, K406, K407, K408, K409, K410, K411,       K413, K414,       \
	K500, K501,                   K505,                         K510,       K512, K513, K514, K515  \
) { \
	{ K000,  K001,  K002,  K003,  KC_NO, K005,  K006,  K007,  K008,  K009,  K010,  K011,  K012,  K013,  K014,  K015 }, \
	{ K100,  K101,  K102,  K103,  K104,  K105,  K106,  K107,  K108,  K109,  K110,  K111,  K112,  K113,  K114,  K115 }, \
	{ K200,  KC_NO, K202,  K203,  K204,  K205,  K206,  K207,  K208,  K209,  K210,  K211,  K212,  K213,  K214,  K215 }, \
	{ K300,  KC_NO, K302,  K303,  K304,  K305,  K306,  K307,  K308,  K309,  K310,  K311,  K312,  K313,  KC_NO, KC_NO }, \
	{ K400,  KC_NO,  K402,  K403,  K404,  K405,  K406,  K407,  K408,  K409,  K410,  K411,  KC_NO, K413,  K414,  KC_NO }, \
	{ K500,  K501,  KC_NO,  KC_NO, KC_NO, K505,  KC_NO, KC_NO, KC_NO, KC_NO, K510,  KC_NO,  K512,  K513,  K514,  K515 }  \
}

#define LAYOUT_75_iso( \
	K000, K001, K002, K003,       K005, K006, K007, K008, K009, K010, K011, K012, K013, K014, K015, \
	K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110, K111, K112,       K114, K115, \
	K200,       K202, K203, K204, K205, K206, K207, K208, K209, K210, K211, K212, K213,       K215, \
	K300,       K302, K303, K304, K305, K306, K307, K308, K309, K310, K311, K312, K214, K313,       \
	K400, K401, K402, K403, K404, K405, K406, K407, K408, K409, K410, K411,       K413, K414,       \
	K500, K501, K502,             K505,                         K510,       K512, K513, K514, K515  \
) { \
	{ K000,  K001,  K002,  K003,  KC_NO, K005,  K006,  K007,  K008,  K009,  K010,  K011,  K012,  K013,  K014,  K015 }, \
	{ K100,  K101,  K102,  K103,  K104,  K105,  K106,  K107,  K108,  K109,  K110,  K111,  K112, KC_NO,  K114,  K115 }, \
	{ K200,  KC_NO, K202,  K203,  K204,  K205,  K206,  K207,  K208,  K209,  K210,  K211,  K212,  K213,  K214,  K215 }, \
	{ K300,  KC_NO, K302,  K303,  K304,  K305,  K306,  K307,  K308,  K309,  K310,  K311,  K312,  K313,  KC_NO, KC_NO }, \
	{ K400,  K401,  K402,  K403,  K404,  K405,  K406,  K407,  K408,  K409,  K410,  K411,  KC_NO, K413,  K414,  KC_NO }, \
	{ K500,  K501,  K502,  KC_NO, KC_NO, K505,  KC_NO, KC_NO, KC_NO, KC_NO, K510,  KC_NO,  K512,  K513,  K514,  K515 }  \
}
