#include QMK_KEYBOARD_H

// Each layer gets a name for readability, which is then used in the keymap matrix below.
// The underscores don't mean anything - you can have a layer called STUFF or any other name.
// Layer names don't all need to be of the same length, obviously, and you can also skip them
// entirely and just use numbers.
enum chimera_ortho_plus_layers {
  _QWERTY,
  _CAPS,
  _NUMPAD,
  _SYMBOLS,
  _MACROS,
  _NAV
};

#define KC_NMPD TG(_NUMPAD)
#define KC_SYMB TG(_SYMBOLS)
#define KC_SPFN LT(_NAV,KC_4)
#define KC_SCTL MT(MOD_LCTL, KC_2)
#define KC_SCTR MT(MOD_LCTL, KC_9)
#define KC_SPLT MT(MOD_LALT, KC_3)
#define KC_SPRT MT(MOD_LALT, KC_8)
#define KC_GBRC MT(MOD_RGUI, KC_7)
#define KC_GQOT MT(MOD_LGUI, KC_QUOT)
#define KC_MESC LT(_MACROS, KC_ESC)
#define KC_CAD LALT(LCTL(KC_DEL))

enum custom_keycodes {
  KC_INCL = SAFE_RANGE,
  KC_PULL,
  KC_PUSH,
  KC_SCAP,
  KC_SCOF
};

const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {

  [_QWERTY] = LAYOUT(
  //,-------+-------+-------+-------+-------+-------.     ,-------+-------+-------+-------+-------+-------.
     KC_LBRC, KC_1  ,KC_SCTL,KC_SPLT,KC_SPFN, KC_5  ,       KC_6  ,KC_GBRC,KC_SPRT,KC_SCTR, KC_0  ,KC_RBRC,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
     KC_MESC, KC_Q  , KC_W  , KC_E  , KC_R  , KC_T  ,       KC_Y  , KC_U  , KC_I  , KC_O  , KC_P  ,KC_QUOT,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
     KC_TAB , KC_A  , KC_S  , KC_D  , KC_F  , KC_G  ,       KC_H  , KC_J  , KC_K  , KC_L  ,KC_SCLN,KC_ENT ,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
     SC_LSPO, KC_Z  , KC_X  , KC_C  , KC_V  , KC_B  ,       KC_N  , KC_M  ,KC_COMM,KC_DOT ,KC_SLSH,SC_RSPC,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
                                     KC_NMPD,KC_BSPC,      KC_SPC ,KC_SYMB
  //|-------------------------------+-------+-------|     |-------+-------+-------------------------------|
  ),

  [_CAPS] = LAYOUT(
  //,-------+-------+-------+-------+-------+-------.     ,-------+-------+-------+-------+-------+-------.
     _______,KC_UNDS,_______,_______,_______,_______,      _______,_______,_______,_______,_______,_______,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
     _______,_______,_______,_______,_______,_______,      _______,_______,_______,_______,_______,_______,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
     _______,_______,_______,_______,_______,_______,      _______,_______,_______,_______,KC_COLN,_______,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
     KC_SCOF,_______,_______,_______,_______,_______,      _______,_______,_______,_______,_______,KC_SCOF,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
                                     _______,_______,      _______,_______
  //|-------------------------------+-------+-------|     |-------+-------+-------------------------------|
  ),

  [_NUMPAD] = LAYOUT(
  //,-------+-------+-------+-------+-------+-------.     ,-------+-------+-------+-------+-------+-------.
     _______,_______,_______,_______,_______,_______,      _______,_______,_______,_______,KC_MINS,_______,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
     _______,_______,KC_COLN,_______,_______,_______,      _______, KC_7  , KC_8  , KC_9  ,KC_ASTR,_______,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
     _______,_______,KC_DOT ,_______,_______,_______,      _______, KC_4  , KC_5  , KC_6  ,KC_PLUS,_______,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
     _______,_______,_______,_______,_______,_______,      _______, KC_1  , KC_2  , KC_3  ,KC_SLSH,_______,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
                                     _______,_______,      _______, KC_0
  //|-------------------------------+-------+-------/     |-------+-------+-------------------------------|
  ),

  [_SYMBOLS] = LAYOUT(
  //,-------+-------+-------+-------+-------+-------.     ,-------+-------+-------+-------+-------+-------.
     _______,_______,_______,_______,_______,_______,      _______,_______,_______,_______,_______,_______,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
     _______,KC_EXLM, KC_AT ,KC_HASH,KC_DLR ,KC_PERC,      KC_CIRC,KC_AMPR,KC_ASTR,KC_LPRN,KC_RPRN,KC_BSLS,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
      KC_F1 , KC_F2 , KC_F3 , KC_F4 , KC_F5 , KC_F6 ,      KC_TILD,KC_EQL ,KC_UNDS,KC_LCBR,KC_RCBR,_______,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
      KC_F7 , KC_F8 , KC_F9 ,KC_F10 ,KC_F11 ,KC_F12 ,      KC_GRV ,KC_PLUS,KC_MINS,KC_LBRC,KC_RBRC,_______,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
                                     KC_PIPE,_______,      _______,_______
  //|-------------------------------+-------+-------|     |-------+-------+-------------------------------|
  ),

  [_MACROS] = LAYOUT(  
  //,-------+-------+-------+-------+-------+-------.     ,-------+-------+-------+-------+-------+-------.
     _______,_______,_______,_______,_______,_______,    _______  ,_______,_______,_______,_______,_______,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
     _______,_______,_______,_______,_______,_______,    _______  ,_______,KC_INCL,_______,_______,_______,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
     _______,_______,_______,KC_CAD ,_______,_______,    _______  ,_______,_______,_______,_______,_______,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
     KC_SCAP,_______,_______,_______,_______,_______,    _______  ,_______,KC_PULL,KC_PUSH,_______,_______,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
                                     _______,_______,      _______,_______    
  //|-------------------------------+-------+-------|     |-------+-------+-------------------------------|
  ),

  [_NAV] = LAYOUT(  
  //,-------+-------+-------+-------+-------+-------.     ,-------+-------+-------+-------+-------+-------.
     _______,_______,_______,_______,_______,_______,      _______,_______,_______,_______,_______,_______,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
     _______,_______,_______,_______,_______,_______,      _______,KC_PGUP, KC_UP ,KC_PGDN,KC_PSCR,_______,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
     _______,_______,_______,_______,_______,_______,      _______,KC_LEFT,KC_DOWN,KC_RGHT,_______,_______,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
     _______,_______,_______,_______,_______,_______,      _______,_______,_______,_______,_______,_______,
  //|-------+-------+-------+-------+-------+-------|     |-------+-------+-------+-------+-------+-------|
                                     _______,KC_DEL ,      _______,_______    
  //|-------------------------------+-------+-------|     |-------+-------+-------------------------------|
  )
};


bool process_record_user(uint16_t keycode, keyrecord_t *record) {
  switch(keycode) {
    /* include some kind of library or header */
    case KC_INCL:
      if (record->event.pressed) {
        SEND_STRING("#include <>" SS_TAP(X_LEFT));
      }
      return false;
    case KC_PULL:
      if (record->event.pressed) {
        SEND_STRING("git pull\n");
      }
      return false;
    case KC_PUSH:
      if (record->event.pressed){
        SEND_STRING("git push\n");
      }
      return false;
	case KC_SCAP:
      if (record->event.pressed){
        layer_on(_CAPS);
        tap_code(KC_CAPS);
      }
      return false;
    case KC_SCOF:
      if (record->event.pressed){
        layer_off(_CAPS);
        tap_code(KC_CAPS);
      }
      return false;
  }
  return true;
};
 

void matrix_scan_user(void) {
    uint8_t layer = get_highest_layer(layer_state);
	
    switch (layer) {
    	case _QWERTY:
    	    set_led_green;
    	    break;
	    case _CAPS:
			set_led_white;
			break;
	    case _NUMPAD:
            set_led_blue;
            break;
	    case _SYMBOLS:
            set_led_red;
            break;
	    case _MACROS:
			set_led_cyan;
			break;
		case _NAV:
			set_led_magenta;
			break;
        default:
            set_led_green;
            break;
    }
};
