/* Copyright 2022 david l goodrich <dlg@dsrw.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include QMK_KEYBOARD_H

enum custom_layers {
    _BL,
    _FL,
};

const uint16_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {

  /* Keymap _BL: (Base Layer) Default Layer
   * ,---------------------------------------------------------------.
   * |Esc| 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 0 | - | = | \ |~` |???|
   * |---------------------------------------------------------------|
   * |Tab  | Q | W | E | R | T | Y | U | I | O | P | [ | ] |Bkspc|Del|
   * |---------------------------------------------------------------|
   * |Ctrl  | A | S | D | F | G | H | J | K | L | ; | ' | Enter  |PUp|
   * |---------------------------------------------------------------|
   * |Shift   | Z | X | C | V | B | N | M | , | . | / |Shift |Up |PDn|
   * |---------------------------------------------------------------|
   * |Ctrl|Win |Alt |        Space            |Alt |Fn  ||Lt |Dn |Rt |
   * `--------------------------------------------------''-----------'
   */

    [_BL] = LAYOUT(
       KC_ESC,  KC_1,    KC_2,    KC_3,    KC_4,    KC_5,    KC_6,    KC_7,    KC_8,    KC_9,    KC_0,    KC_MINS, KC_EQL,  KC_BSLS, KC_GRV,  KC_NO,
       KC_TAB,       KC_Q,    KC_W,    KC_E,    KC_R,    KC_T,    KC_Y,    KC_U,    KC_I,    KC_O,    KC_P,    KC_LBRC, KC_RBRC, KC_BSPC,     KC_DEL,
       KC_LCTL,          KC_A,    KC_S,    KC_D,    KC_F,    KC_G,    KC_H,    KC_J,    KC_K,    KC_L,    KC_SCLN, KC_QUOT, KC_ENT,           KC_PGUP,
       KC_LSFT,               KC_Z,    KC_X,    KC_C,    KC_V,    KC_B,    KC_N,    KC_M,    KC_COMM, KC_DOT,  KC_SLSH, KC_LSFT,     KC_UP,   KC_PGDN,
       KC_LCTL,    KC_LGUI,    KC_LALT,                         KC_SPC,                          KC_LALT,    MO(_FL),       KC_LEFT, KC_DOWN, KC_RGHT
    ),

  /* Keymap _FL: Function Layer
   * ,---------------------------------------------------------------.
   * |   |F1 |F2 |F3 |F4 |F5 |F6 |F7 |F8 |F9 |F10|F11|F12|   |RST|   |
   * |---------------------------------------------------------------|
   * |     |   |   |   |   |   |   |   |   |   |PSc|   |   |Del  |Ins|
   * |---------------------------------------------------------------|
   * |      |   |   |   |   |   |   |   |   |   |   |   |        |Hme|
   * |---------------------------------------------------------------|
   * |        |   |   |   |   |   |   |MUT|V- |V+ |   |      |PUp|End|
   * |---------------------------------------------------------------|
   * |    |    |    |                         |    |    ||Hme|PDn|End|
   * `--------------------------------------------------''-----------'
   */
    [_FL] = LAYOUT(
        _______, KC_F1,   KC_F2,   KC_F3,   KC_F4,   KC_F5,   KC_F6,   KC_F7,   KC_F8,   KC_F9,   KC_F10,  KC_F11,  KC_F12,  _______, QK_BOOT,   _______,
        _______,      _______, _______, _______, _______, _______, _______, _______, _______, _______, KC_PSCR, _______, _______, KC_DEL,      KC_INS,
        _______,          _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______, _______,          KC_HOME,
        _______,               _______, _______, _______, _______, _______, _______, KC_MUTE, KC_VOLD, KC_VOLU, _______, _______,     KC_PGUP, KC_END,
        _______,    _______,    _______,                         _______,                         _______,    _______,       KC_HOME, KC_PGDN, KC_END
    )
};
 