/*
Copyright 2021 Robin Liu

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#pragma once

#include "quantum.h"

/*
* Default layout:
* 2.75u - 2.25u spacebar
*/
#define LAYOUT_default( \
	K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K310, \
	K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110,       \
	K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210,       \
	      K301, K302,       K304,       K306,       K308, K309              \
) { \
	{ K000,  K001,  K002,  K003,  K004,  K005,  K006,  K007,  K008,  K009,  K010 }, \
	{ K100,  K101,  K102,  K103,  K104,  K105,  K106,  K107,  K108,  K109,  K110 }, \
	{ K200,  K201,  K202,  K203,  K204,  K205,  K206,  K207,  K208,  K209,  K210 }, \
	{ KC_NO, K301,  K302,  KC_NO, K304,  KC_NO, K306,  KC_NO, K308,  K309,  K310 }  \
}

/*
* Spaceswap layout:
* Electrically identical to default
* 2.25u - 2.75u spacebar
*/
#define LAYOUT_spaceswap( \
	K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K310, \
	K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110,       \
	K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210,       \
	      K301, K302,       K304,       K306,       K308, K309              \
) { \
	{ K000,  K001,  K002,  K003,  K004,  K005,  K006,  K007,  K008,  K009,  K010 }, \
	{ K100,  K101,  K102,  K103,  K104,  K105,  K106,  K107,  K108,  K109,  K110 }, \
	{ K200,  K201,  K202,  K203,  K204,  K205,  K206,  K207,  K208,  K209,  K210 }, \
	{ KC_NO, K301,  K302,  KC_NO, K304,  KC_NO, K306,  KC_NO, K308,  K309,  K310 }  \
}

/*
* 6.25u spacebar layout:
* 6.25u spacebar
*/
#define LAYOUT_space6p25u( \
	K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K310, \
	K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110,       \
	K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210,       \
	      K301, K302,                   K306,             K309              \
) { \
	{ K000,  K001,  K002,  K003,  K004,  K005,  K006,  K007,  K008,  K009,  K010 }, \
	{ K100,  K101,  K102,  K103,  K104,  K105,  K106,  K107,  K108,  K109,  K110 }, \
	{ K200,  K201,  K202,  K203,  K204,  K205,  K206,  K207,  K208,  K209,  K210 }, \
	{ KC_NO, K301,  K302,  KC_NO, KC_NO, KC_NO, K306,  KC_NO, KC_NO, K309,  K310 }  \
}

/*
* 7u spacebar layout:
* 7u spacebar
*/
#define LAYOUT_space7u( \
	K000, K001, K002, K003, K004, K005, K006, K007, K008, K009, K010, K310, \
	K100, K101, K102, K103, K104, K105, K106, K107, K108, K109, K110,       \
	K200, K201, K202, K203, K204, K205, K206, K207, K208, K209, K210,       \
	      K301,             K304,                         K309              \
) { \
	{ K000,  K001,  K002,  K003,  K004,  K005,  K006,  K007,  K008,  K009,  K010 }, \
	{ K100,  K101,  K102,  K103,  K104,  K105,  K106,  K107,  K108,  K109,  K110 }, \
	{ K200,  K201,  K202,  K203,  K204,  K205,  K206,  K207,  K208,  K209,  K210 }, \
	{ KC_NO, K301,  KC_NO, KC_NO, K304,  KC_NO, KC_NO, KC_NO, KC_NO, K309,  K310 }  \
}
