# Kinesis Advantage Keymap

## About this keymap

This keymap is designed after Kinesis Advantage's QWERTY layout with the following key differences:
 - There are only 10 F-keys in the main layer, F1 and F2 are moved to additional LOWER layer.
 - The INS key acts like a LOWER layer activation key and Del in LOWER layer ats like INS.
 - LCtl is placed where CAPS should be and CAPS is moved to a free key after F10.
 - Brigtness and volume control keys are added to LOWER layer.

 The keymap file also contains RAISE layer but it is currently equivalent to LOWER layer and does
 not have an activation key mapped. It is intended for possible extensions.

## Mapping details

        Main QUERTY layer:
        ,-------------------------------------------.                           ,-------------------------------------------.
        | ESC    |  F1  |  F2  |  F3  |  F4  |  F5  |                           |  F6  |  F7  |  F8  |  F9  |  F10 | CAPS   |
        |--------+------+------+------+------+------|                           |------+------+------+------+------+--------|
        | =      |   1  |   2  |   3  |   4  |   5  |                           |   6  |   7  |   8  |   9  |   0  |   -    |
        |--------+------+------+------+------+------|                           |------+------+------+------+------+--------|
        | Tab    |   Q  |   W  |   E  |   R  |   T  |                           |   Y  |   U  |   I  |   O  |   P  |   \    |
        |--------+------+------+------+------+------|                           |------+------+------+------+------+--------|
        | LCtl   |   A  |   S  |   D  |   F  |   G  |                           |   H  |   J  |   K  |   L  |   ;  |   '    |
        |--------+------+------+------+------+------|                           |------+------+------+------+------+--------|
        | LShift |   Z  |   X  |   C  |   V  |   B  |                           |   N  |   M  |   ,  |   .  |   /  | RShift |
        `--------+------+------+------+------+------'                           `------+------+------+------+------+--------'
                 |   `  | LOWER| Left | Rght |                                         |  Up  |  Dn  |   [  |   ]  |
                 `---------------------------'                                         `---------------------------'
                                                ,-------------.      ,-------------.
                                                | LGui | LAlt |      | RCtl | RGui |
                                         ,------|------|------|      |------+------+------.
                                         |      |      | Home |      | PgUp |      |      |
                                         | BkSp | Del  |------|      |------|Enter |Space |
                                         |      |      | End  |      | PgDn |      |      |
                                         `--------------------'      `--------------------'

        LOWER layer:
        ,-------------------------------------------.                           ,-------------------------------------------.
        |        |  F11 |  F12 |      |      |      |                           |BriDn |BriUp |VMute |VolDn |VolUp |        |
        |--------+------+------+------+------+------|                           |------+------+------+------+------+--------|
        |        |      |      |      |      |      |                           |      |      |      |      |      |        |
        |--------+------+------+------+------+------|                           |------+------+------+------+------+--------|
        |        |      |      |      |      |      |                           |      |      |      |      |      |        |
        |--------+------+------+------+------+------|                           |------+------+------+------+------+--------|
        |        |      |      |      |      |      |                           |      |      |      |      |      |        |
        |--------+------+------+------+------+------|                           |------+------+------+------+------+--------|
        |        |      |      |      |      |      |                           |      |      |      |      |      |        |
        `--------+------+------+------+------+------'                           `------+------+------+------+------+--------'
                 |      |      |      |      |                                         |      |      |      |      |
                 `---------------------------'                                         `---------------------------'
                                                ,-------------.      ,-------------.
                                                |      |      |      |      |      |
                                         ,------|------|------|      |------+------+------.
                                         |      |      |      |      |      |      |      |
                                         |      | INS  |------|      |------|      |      |
                                         |      |      |      |      |      |      |      |
                                         `--------------------'      `--------------------'

## Soldering details

The below picture shows correspondence between the keys and the row/column wires of the left and
right halves:

        LOWER layer:
        ,-------------------------------------------.                           ,-------------------------------------------.
        |  L00   | L01  | L02  | L03  | L04  | L05  |                           | R00  | R01  | R02  | R03  | R04  |  R05   |
        |--------+------+------+------+------+------|                           |------+------+------+------+------+--------|
        |  L10   | L11  | L12  | L13  | L14  | L15  |                           | R10  | R11  | R12  | R13  | R14  |  R15   |
        |--------+------+------+------+------+------|                           |------+------+------+------+------+--------|
        |  L20   | L21  | L22  | L23  | L24  | L25  |                           | R20  | R21  | R22  | R23  | R24  |  R25   |
        |--------+------+------+------+------+------|                           |------+------+------+------+------+--------|
        |  L30   | L31  | L32  | L33  | L34  | L35  |                           | R30  | R31  | R32  | R33  | R34  |  R35   |
        |--------+------+------+------+------+------|                           |------+------+------+------+------+--------|
        |  L40   | L41  | L42  | L43  | L44  | L45  |                           | R40  | R41  | R42  | R43  | R44  |  R45   |
        `--------+------+------+------+------+------'                           `------+------+------+------+------+--------'
                 | L50  | L51  | L52  | L53  |                                         | R52  | R53  | R54  | R55  |
                 `---------------------------'                                         `---------------------------'
                                                ,-------------.      ,-------------.
                                                | L64  | L65  |      | R60  | R61  |
                                         ,------|------|------|      |------+------+------.
                                         |      |      | L63  |      | R62  |      |      |
                                         | L54  | L55  |------|      |------| R50  | R51  |
                                         |      |      | L62  |      | R63  |      |      |
                                         `--------------------'      `--------------------'
